\name{metabo}
\alias{metabo}
\docType{data}
\title{
  metabolic profiles in tuberculosis.
%%   ~~ data name/kind ... ~~
}
\description{
  Relative abundances of metabolites from serum samples of three groups of
  individuals
%%  ~~ A concise (1-5 lines) description of the dataset. ~~
}
\usage{data(metabo)}
\format{
  A data frame with 136 observations on the following 425 variables.
  \describe{
    \item{\code{group}}{a factor with levels \code{NEG} \code{POS} \code{TB}}
\item{\code{X1}}{relative level of 1,5-anhydroglucitol (1,5-AG)}
\item{\code{X2}}{relative level of 10-heptadecenoate (17:1n7)}
\item{\code{X3}}{relative level of 10-nonadecenoate (19:1n9)}
\item{\code{X4}}{relative level of 10-undecenoate (11:1n1)}
\item{\code{X5}}{relative level of 1-arachidonoylglycerophosphocholine*}
\item{\code{X6}}{relative level of 1-arachidonoylglycerophosphoethanolamine*}
\item{\code{X7}}{relative level of 1-arachidonoylglycerophosphoinositol*}
\item{\code{X8}}{relative level of 1-docosahexaenoylglycerophosphocholine*}
\item{\code{X9}}{relative level of 1-docosapentaenoylglycerophosphocholine*}
\item{\code{X10}}{relative level of 1-eicosatrienoylglycerophosphocholine*}
\item{\code{X11}}{relative level of 1-heptadecanoylglycerophosphocholine}
\item{\code{X12}}{relative level of 1-linoleoylglycerophosphocholine}
\item{\code{X13}}{relative level of 1-linoleoylglycerophosphoethanolamine*}
\item{\code{X14}}{relative level of 1-myristoylglycerophosphocholine}
\item{\code{X15}}{relative level of 1-oleoylglycerophosphate}
\item{\code{X16}}{relative level of 1-oleoylglycerophosphocholine}
\item{\code{X17}}{relative level of 1-oleoylglycerophosphoethanolamine}
\item{\code{X18}}{relative level of 1-palmitoleoylglycerophosphocholine*}
\item{\code{X19}}{relative level of 1-palmitoylglycerol (1-monopalmitin)}
\item{\code{X20}}{relative level of 1-palmitoylglycerophosphocholine}
\item{\code{X21}}{relative level of 1-palmitoylglycerophosphoethanolamine}
\item{\code{X22}}{relative level of 1-palmitoylglycerophosphoinositol*}
\item{\code{X23}}{relative level of 1-stearoylglycerol (1-monostearin)}
\item{\code{X24}}{relative level of 1-stearoylglycerophosphocholine}
\item{\code{X25}}{relative level of 1-stearoylglycerophosphoinositol}
\item{\code{X26}}{relative level of 21-hydroxypregnenolone disulfate}
\item{\code{X27}}{relative level of 2-aminobutyrate}
\item{\code{X28}}{relative level of 2-arachidonoylglycerophosphoethanolamine*}
\item{\code{X29}}{relative level of 2-hydroxybutyrate (AHB)}
\item{\code{X30}}{relative level of 2-hydroxyhippurate (salicylurate)}
\item{\code{X31}}{relative level of 2-hydroxypalmitate}
\item{\code{X32}}{relative level of 2-hydroxystearate}
\item{\code{X33}}{relative level of 2-isopropylmalate}
\item{\code{X34}}{relative level of 2-methylbutyroylcarnitine}
\item{\code{X35}}{relative level of 2-palmitoylglycerophosphocholine*}
\item{\code{X36}}{relative level of 2-stearoylglycerophosphocholine*}
\item{\code{X37}}{relative level of 3-(4-hydroxyphenyl)lactate}
\item{\code{X38}}{relative level of 3-(cystein-S-yl)acetaminophen*}
\item{\code{X39}}{relative level of 3-carboxy-4-methyl-5-propyl-2-furanpropanoate (CMPF)}
\item{\code{X40}}{relative level of 3-dehydrocarnitine*}
\item{\code{X41}}{relative level of 3-hydroxybutyrate (BHBA)}
\item{\code{X42}}{relative level of 3-hydroxydecanoate}
\item{\code{X43}}{relative level of 3-hydroxykynurenine}
\item{\code{X44}}{relative level of 3-indoxyl sulfate}
\item{\code{X45}}{relative level of 3-methoxytyrosine}
\item{\code{X46}}{relative level of 3-methyl-2-oxobutyrate}
\item{\code{X47}}{relative level of 3-methyl-2-oxovalerate}
\item{\code{X48}}{relative level of 3-methylhistidine}
\item{\code{X49}}{relative level of 3-phenylpropionate (hydrocinnamate)}
\item{\code{X50}}{relative level of 4-acetamidobutanoate}
\item{\code{X51}}{relative level of 4-acetamidophenol}
\item{\code{X52}}{relative level of 4-acetaminophen sulfate}
\item{\code{X53}}{relative level of 4-androsten-3beta,17beta-diol disulfate 1*}
\item{\code{X54}}{relative level of 4-androsten-3beta,17beta-diol disulfate 2*}
\item{\code{X55}}{relative level of 4-ethylphenylsulfate}
\item{\code{X56}}{relative level of 4-methyl-2-oxopentanoate}
\item{\code{X57}}{relative level of 4-vinylphenol sulfate}
\item{\code{X58}}{relative level of 5alpha-androstan-3alpha,17beta-diol monosulfate 1*}
\item{\code{X59}}{relative level of 5alpha-androstan-3beta,17alpha-diol disulfate}
\item{\code{X60}}{relative level of 5alpha-androstan-3beta,17beta-diol disulfate}
\item{\code{X61}}{relative level of 5alpha-pregnan-3alpha,20beta-diol disulfate 1*}
\item{\code{X62}}{relative level of 5alpha-pregnan-3beta,20alpha-diol disulfate}
\item{\code{X63}}{relative level of 5alpha-pregnan-3beta,20alpha-diol monsulfate 2*}
\item{\code{X64}}{relative level of 5alpha-pregnan-3beta,20beta-diol monosulfate 1*}
\item{\code{X65}}{relative level of 5-dodecenoate (12:1n7)}
\item{\code{X66}}{relative level of 5-oxoproline}
\item{\code{X67}}{relative level of 7-alpha-hydroxy-3-oxo-4-cholestenoate (7-Hoca)}
\item{\code{X68}}{relative level of acetylcarnitine}
\item{\code{X69}}{relative level of acetylphosphate}
\item{\code{X70}}{relative level of ADpSGEGDFXAEGGGVR*}
\item{\code{X71}}{relative level of adrenate (22:4n6)}
\item{\code{X72}}{relative level of ADSGEGDFXAEGGGVR*}
\item{\code{X73}}{relative level of alanine}
\item{\code{X74}}{relative level of allantoin}
\item{\code{X75}}{relative level of alpha-hydroxyisovalerate}
\item{\code{X76}}{relative level of alpha-ketoglutarate}
\item{\code{X77}}{relative level of alpha-tocopherol}
\item{\code{X78}}{relative level of andro steroid monosulfate 1*}
\item{\code{X79}}{relative level of andro steroid monosulfate 2*}
\item{\code{X80}}{relative level of androsterone sulfate}
\item{\code{X81}}{relative level of arachidonate (20:4n6)}
\item{\code{X82}}{relative level of arginine}
\item{\code{X83}}{relative level of ascorbate (Vitamin C)}
\item{\code{X84}}{relative level of asparagine}
\item{\code{X85}}{relative level of aspartate}
\item{\code{X86}}{relative level of aspartylphenylalanine}
\item{\code{X87}}{relative level of beta-hydroxyisovalerate}
\item{\code{X88}}{relative level of betaine}
\item{\code{X89}}{relative level of bilirubin (E,E)*}
\item{\code{X90}}{relative level of bilirubin (E,Z or Z,E)*}
\item{\code{X91}}{relative level of bilirubin (Z,Z)}
\item{\code{X92}}{relative level of biliverdin}
\item{\code{X93}}{relative level of bradykinin, des-arg(9)}
\item{\code{X94}}{relative level of butyrylcarnitine}
\item{\code{X95}}{relative level of caffeine}
\item{\code{X96}}{relative level of caprate (10:0)}
\item{\code{X97}}{relative level of caproate (6:0)}
\item{\code{X98}}{relative level of caprylate (8:0)}
\item{\code{X99}}{relative level of carnitine}
\item{\code{X100}}{relative level of catechol sulfate}
\item{\code{X101}}{relative level of C-glycosyltryptophan*}
\item{\code{X102}}{relative level of chenodeoxycholate}
\item{\code{X103}}{relative level of cholate}
\item{\code{X104}}{relative level of cholesterol}
\item{\code{X105}}{relative level of choline}
\item{\code{X106}}{relative level of citrate}
\item{\code{X107}}{relative level of citrulline}
\item{\code{X108}}{relative level of cortisol}
\item{\code{X109}}{relative level of cortisone}
\item{\code{X110}}{relative level of cotinine}
\item{\code{X111}}{relative level of creatine}
\item{\code{X112}}{relative level of creatinine}
\item{\code{X113}}{relative level of cysteine}
\item{\code{X114}}{relative level of cysteine-glutathione disulfide}
\item{\code{X115}}{relative level of cystine}
\item{\code{X116}}{relative level of decanoylcarnitine}
\item{\code{X117}}{relative level of dehydroisoandrosterone sulfate (DHEA-S)}
\item{\code{X118}}{relative level of deoxycarnitine}
\item{\code{X119}}{relative level of deoxycholate}
\item{\code{X120}}{relative level of dihomo-linoleate (20:2n6)}
\item{\code{X121}}{relative level of dihomo-linolenate (20:3n3 or n6)}
\item{\code{X122}}{relative level of dimethylarginine (SDMA + ADMA)}
\item{\code{X123}}{relative level of docosahexaenoate (DHA; 22:6n3)}
\item{\code{X124}}{relative level of docosapentaenoate (n3 DPA; 22:5n3)}
\item{\code{X125}}{relative level of DSGEGDFXAEGGGVR*}
\item{\code{X126}}{relative level of eicosapentaenoate (EPA; 20:5n3)}
\item{\code{X127}}{relative level of eicosenoate (20:1n9 or 11)}
\item{\code{X128}}{relative level of epiandrosterone sulfate}
\item{\code{X129}}{relative level of erythritol}
\item{\code{X130}}{relative level of erythronate*}
\item{\code{X132}}{relative level of fructose}
\item{\code{X133}}{relative level of gamma-glutamylglutamate}
\item{\code{X134}}{relative level of gamma-glutamylglutamine}
\item{\code{X135}}{relative level of gamma-glutamylisoleucine*}
\item{\code{X136}}{relative level of gamma-glutamylleucine}
\item{\code{X137}}{relative level of gamma-glutamylmethionine*}
\item{\code{X138}}{relative level of gamma-glutamylphenylalanine}
\item{\code{X139}}{relative level of gamma-glutamyltyrosine}
\item{\code{X140}}{relative level of gamma-tocopherol}
\item{\code{X141}}{relative level of glucose}
\item{\code{X142}}{relative level of glutamate}
\item{\code{X143}}{relative level of glutamine}
\item{\code{X144}}{relative level of glutaroyl carnitine}
\item{\code{X145}}{relative level of glycerate}
\item{\code{X146}}{relative level of glycerol}
\item{\code{X147}}{relative level of glycerol 2-phosphate}
\item{\code{X148}}{relative level of glycerol 3-phosphate (G3P)}
\item{\code{X149}}{relative level of glycerophosphorylcholine (GPC)}
\item{\code{X150}}{relative level of glycine}
\item{\code{X151}}{relative level of glycochenodeoxycholate}
\item{\code{X152}}{relative level of glycocholate}
\item{\code{X153}}{relative level of glycocholenate sulfate*}
\item{\code{X154}}{relative level of glycolate (hydroxyacetate)}
\item{\code{X155}}{relative level of glycolithocholate sulfate*}
\item{\code{X156}}{relative level of glycylvaline}
\item{\code{X158}}{relative level of heme*}
\item{\code{X159}}{relative level of heptanoate (7:0)}
\item{\code{X160}}{relative level of hexadecanedioate}
\item{\code{X161}}{relative level of hexanoylcarnitine}
\item{\code{X162}}{relative level of hippurate}
\item{\code{X163}}{relative level of histidine}
\item{\code{X164}}{relative level of homostachydrine*}
\item{\code{X165}}{relative level of HWESASXX*}
\item{\code{X166}}{relative level of hyodeoxycholate}
\item{\code{X167}}{relative level of hypoxanthine}
\item{\code{X168}}{relative level of indoleacetate}
\item{\code{X169}}{relative level of indolelactate}
\item{\code{X170}}{relative level of indolepropionate}
\item{\code{X171}}{relative level of inosine}
\item{\code{X172}}{relative level of inositol 1-phosphate (I1P)}
\item{\code{X173}}{relative level of isobutyrylcarnitine}
\item{\code{X174}}{relative level of isoleucine}
\item{\code{X175}}{relative level of isovalerate}
\item{\code{X176}}{relative level of isovalerylcarnitine}
\item{\code{X177}}{relative level of kynurenine}
\item{\code{X178}}{relative level of lactate}
\item{\code{X179}}{relative level of lathosterol}
\item{\code{X180}}{relative level of laurate (12:0)}
\item{\code{X181}}{relative level of laurylcarnitine}
\item{\code{X182}}{relative level of leucine}
\item{\code{X183}}{relative level of leucylleucine}
\item{\code{X184}}{relative level of levulinate (4-oxovalerate)}
\item{\code{X185}}{relative level of linoleate (18:2n6)}
\item{\code{X186}}{relative level of linolenate [alpha or gamma; (18:3n3 or 6)]}
\item{\code{X187}}{relative level of lysine}
\item{\code{X188}}{relative level of malate}
\item{\code{X189}}{relative level of maltose}
\item{\code{X190}}{relative level of mannose}
\item{\code{X191}}{relative level of margarate (17:0)}
\item{\code{X192}}{relative level of mead acid (20:3n9)}
\item{\code{X194}}{relative level of methionine}
\item{\code{X195}}{relative level of myo-inositol}
\item{\code{X196}}{relative level of myristate (14:0)}
\item{\code{X197}}{relative level of myristoleate (14:1n5)}
\item{\code{X198}}{relative level of N1-methyladenosine}
\item{\code{X199}}{relative level of N6-acetyllysine}
\item{\code{X200}}{relative level of N-acetylalanine}
\item{\code{X201}}{relative level of N-acetylglycine}
\item{\code{X202}}{relative level of N-acetylmethionine}
\item{\code{X203}}{relative level of N-acetylneuraminate}
\item{\code{X204}}{relative level of N-acetylornithine}
\item{\code{X205}}{relative level of N-acetylthreonine}
\item{\code{X206}}{relative level of nonadecanoate (19:0)}
\item{\code{X207}}{relative level of octadecanedioate}
\item{\code{X208}}{relative level of octanoylcarnitine}
\item{\code{X209}}{relative level of oleate (18:1n9)}
\item{\code{X210}}{relative level of ornithine}
\item{\code{X211}}{relative level of p-acetamidophenylglucuronide}
\item{\code{X212}}{relative level of palmitate (16:0)}
\item{\code{X213}}{relative level of palmitoleate (16:1n7)}
\item{\code{X214}}{relative level of pantothenate}
\item{\code{X215}}{relative level of paraxanthine}
\item{\code{X216}}{relative level of p-cresol sulfate}
\item{\code{X217}}{relative level of pelargonate (9:0)}
\item{\code{X218}}{relative level of pentadecanoate (15:0)}
\item{\code{X219}}{relative level of phenol sulfate}
\item{\code{X220}}{relative level of phenylacetate}
\item{\code{X221}}{relative level of phenylacetylglutamine}
\item{\code{X222}}{relative level of phenylalanine}
\item{\code{X223}}{relative level of phenyllactate (PLA)}
\item{\code{X224}}{relative level of phosphate}
\item{\code{X225}}{relative level of pipecolate}
\item{\code{X226}}{relative level of piperine}
\item{\code{X227}}{relative level of pregn steroid monosulfate*}
\item{\code{X228}}{relative level of pro-hydroxy-pro}
\item{\code{X229}}{relative level of proline}
\item{\code{X230}}{relative level of propionylcarnitine}
\item{\code{X231}}{relative level of pseudouridine}
\item{\code{X232}}{relative level of pyridoxate}
\item{\code{X233}}{relative level of pyroglutamine*}
\item{\code{X234}}{relative level of pyroglutamylglycine}
\item{\code{X235}}{relative level of pyrophosphate (PPi)}
\item{\code{X236}}{relative level of pyruvate}
\item{\code{X237}}{relative level of quinate}
\item{\code{X238}}{relative level of ribose}
\item{\code{X239}}{relative level of salicylate}
\item{\code{X240}}{relative level of salicyluric glucuronide*}
\item{\code{X241}}{relative level of scyllo-inositol}
\item{\code{X242}}{relative level of serine}
\item{\code{X243}}{relative level of serotonin (5HT)}
\item{\code{X244}}{relative level of stachydrine}
\item{\code{X245}}{relative level of stearate (18:0)}
\item{\code{X246}}{relative level of stearidonate (18:4n3)}
\item{\code{X247}}{relative level of stearoyl sphingomyelin}
\item{\code{X248}}{relative level of succinate}
\item{\code{X249}}{relative level of sucrose}
\item{\code{X250}}{relative level of taurochenodeoxycholate}
\item{\code{X251}}{relative level of taurocholate}
\item{\code{X252}}{relative level of taurocholenate sulfate*}
\item{\code{X253}}{relative level of taurolithocholate 3-sulfate}
\item{\code{X254}}{relative level of theobromine}
\item{\code{X255}}{relative level of theophylline}
\item{\code{X256}}{relative level of threonate}
\item{\code{X257}}{relative level of threonine}
\item{\code{X258}}{relative level of threonylphenylalanine}
\item{\code{X259}}{relative level of trans-4-hydroxyproline}
\item{\code{X260}}{relative level of tryptophan}
\item{\code{X261}}{relative level of tryptophan betaine}
\item{\code{X262}}{relative level of tyrosine}
\item{\code{X263}}{relative level of undecanoate (11:0)}
\item{\code{X264}}{relative level of urate}
\item{\code{X265}}{relative level of urea}
\item{\code{X266}}{relative level of uridine}
\item{\code{X267}}{relative level of valine}
\item{\code{X268}}{relative level of xanthine}
\item{\code{X269}}{relative level of xylitol}
\item{\code{X270}}{relative level of unknown compond X - 01911_200}
\item{\code{X271}}{relative level of unknown compond X - 02249_201}
\item{\code{X272}}{relative level of unknown compond X - 02269_201}
\item{\code{X273}}{relative level of unknown compond X - 03056_200}
\item{\code{X274}}{relative level of unknown compond X - 06126_201}
\item{\code{X275}}{relative level of unknown compond X - 07765_201}
\item{\code{X276}}{relative level of unknown compond X - 09789_201}
\item{\code{X277}}{relative level of unknown compond X - 10346_201}
\item{\code{X278}}{relative level of unknown compond X - 10395}
\item{\code{X279}}{relative level of unknown compond X - 10426}
\item{\code{X280}}{relative level of unknown compond X - 10500}
\item{\code{X281}}{relative level of unknown compond X - 10503}
\item{\code{X282}}{relative level of unknown compond X - 10510}
\item{\code{X283}}{relative level of unknown compond X - 10609}
\item{\code{X284}}{relative level of unknown compond X - 10810}
\item{\code{X285}}{relative level of unknown compond X - 11175}
\item{\code{X286}}{relative level of unknown compond X - 11204}
\item{\code{X287}}{relative level of unknown compond X - 11261}
\item{\code{X288}}{relative level of unknown compond X - 11308}
\item{\code{X289}}{relative level of unknown compond X - 11315}
\item{\code{X290}}{relative level of unknown compond X - 11317}
\item{\code{X291}}{relative level of unknown compond X - 11319}
\item{\code{X292}}{relative level of unknown compond X - 11327}
\item{\code{X293}}{relative level of unknown compond X - 11372}
\item{\code{X294}}{relative level of unknown compond X - 11378}
\item{\code{X295}}{relative level of unknown compond X - 11380}
\item{\code{X296}}{relative level of unknown compond X - 11381_200}
\item{\code{X297}}{relative level of unknown compond X - 11412}
\item{\code{X298}}{relative level of unknown compond X - 11421}
\item{\code{X299}}{relative level of unknown compond X - 11423}
\item{\code{X300}}{relative level of unknown compond X - 11437}
\item{\code{X301}}{relative level of unknown compond X - 11440}
\item{\code{X302}}{relative level of unknown compond X - 11441}
\item{\code{X303}}{relative level of unknown compond X - 11442}
\item{\code{X304}}{relative level of unknown compond X - 11444}
\item{\code{X305}}{relative level of unknown compond X - 11452}
\item{\code{X306}}{relative level of unknown compond X - 11469}
\item{\code{X307}}{relative level of unknown compond X - 11470}
\item{\code{X308}}{relative level of unknown compond X - 11476}
\item{\code{X309}}{relative level of unknown compond X - 11485}
\item{\code{X310}}{relative level of unknown compond X - 11491}
\item{\code{X311}}{relative level of unknown compond X - 11497}
\item{\code{X312}}{relative level of unknown compond X - 11508}
\item{\code{X313}}{relative level of unknown compond X - 11513}
\item{\code{X314}}{relative level of unknown compond X - 11521}
\item{\code{X315}}{relative level of unknown compond X - 11522}
\item{\code{X316}}{relative level of unknown compond X - 11529}
\item{\code{X317}}{relative level of unknown compond X - 11530}
\item{\code{X318}}{relative level of unknown compond X - 11533}
\item{\code{X319}}{relative level of unknown compond X - 11537}
\item{\code{X320}}{relative level of unknown compond X - 11538}
\item{\code{X321}}{relative level of unknown compond X - 11540}
\item{\code{X322}}{relative level of unknown compond X - 11542}
\item{\code{X323}}{relative level of unknown compond X - 11549}
\item{\code{X324}}{relative level of unknown compond X - 11550}
\item{\code{X325}}{relative level of unknown compond X - 11560}
\item{\code{X326}}{relative level of unknown compond X - 11593}
\item{\code{X327}}{relative level of unknown compond X - 11730}
\item{\code{X328}}{relative level of unknown compond X - 11786}
\item{\code{X329}}{relative level of unknown compond X - 11787}
\item{\code{X330}}{relative level of unknown compond X - 11793}
\item{\code{X331}}{relative level of unknown compond X - 11799}
\item{\code{X332}}{relative level of unknown compond X - 11805}
\item{\code{X333}}{relative level of unknown compond X - 11818}
\item{\code{X334}}{relative level of unknown compond X - 11820}
\item{\code{X335}}{relative level of unknown compond X - 11840}
\item{\code{X336}}{relative level of unknown compond X - 11843}
\item{\code{X337}}{relative level of unknown compond X - 11850}
\item{\code{X338}}{relative level of unknown compond X - 11853}
\item{\code{X339}}{relative level of unknown compond X - 11859}
\item{\code{X340}}{relative level of unknown compond X - 11861}
\item{\code{X341}}{relative level of unknown compond X - 11868}
\item{\code{X342}}{relative level of unknown compond X - 11871}
\item{\code{X343}}{relative level of unknown compond X - 11884}
\item{\code{X344}}{relative level of unknown compond X - 11904}
\item{\code{X345}}{relative level of unknown compond X - 12007}
\item{\code{X346}}{relative level of unknown compond X - 12013}
\item{\code{X347}}{relative level of unknown compond X - 12039}
\item{\code{X348}}{relative level of unknown compond X - 12045}
\item{\code{X349}}{relative level of unknown compond X - 12051}
\item{\code{X350}}{relative level of unknown compond X - 12063}
\item{\code{X351}}{relative level of unknown compond X - 12092}
\item{\code{X352}}{relative level of unknown compond X - 12094}
\item{\code{X353}}{relative level of unknown compond X - 12095_200}
\item{\code{X354}}{relative level of unknown compond X - 12100}
\item{\code{X355}}{relative level of unknown compond X - 12217}
\item{\code{X356}}{relative level of unknown compond X - 12230}
\item{\code{X357}}{relative level of unknown compond X - 12231}
\item{\code{X358}}{relative level of unknown compond X - 12253}
\item{\code{X359}}{relative level of unknown compond X - 12261}
\item{\code{X360}}{relative level of unknown compond X - 12268}
\item{\code{X361}}{relative level of unknown compond X - 12441}
\item{\code{X362}}{relative level of unknown compond X - 12442}
\item{\code{X363}}{relative level of unknown compond X - 12456}
\item{\code{X364}}{relative level of unknown compond X - 12510}
\item{\code{X365}}{relative level of unknown compond X - 12536}
\item{\code{X366}}{relative level of unknown compond X - 12539}
\item{\code{X367}}{relative level of unknown compond X - 12627}
\item{\code{X368}}{relative level of unknown compond X - 12644}
\item{\code{X369}}{relative level of unknown compond X - 12734}
\item{\code{X370}}{relative level of unknown compond X - 12776}
\item{\code{X371}}{relative level of unknown compond X - 12795}
\item{\code{X372}}{relative level of unknown compond X - 12801}
\item{\code{X373}}{relative level of unknown compond X - 12844}
\item{\code{X374}}{relative level of unknown compond X - 12849}
\item{\code{X375}}{relative level of unknown compond X - 12850}
\item{\code{X376}}{relative level of unknown compond X - 12851}
\item{\code{X377}}{relative level of unknown compond X - 12949}
\item{\code{X378}}{relative level of unknown compond X - 12990}
\item{\code{X379}}{relative level of unknown compond X - 13215}
\item{\code{X381}}{relative level of unknown compond X - 13425}
\item{\code{X382}}{relative level of unknown compond X - 13426}
\item{\code{X383}}{relative level of unknown compond X - 13429}
\item{\code{X384}}{relative level of unknown compond X - 13435}
\item{\code{X385}}{relative level of unknown compond X - 13496}
\item{\code{X386}}{relative level of unknown compond X - 13543}
\item{\code{X387}}{relative level of unknown compond X - 13619}
\item{\code{X388}}{relative level of unknown compond X - 13640}
\item{\code{X389}}{relative level of unknown compond X - 13859}
\item{\code{X390}}{relative level of unknown compond X - 13871}
\item{\code{X391}}{relative level of unknown compond X - 14056}
\item{\code{X392}}{relative level of unknown compond X - 14086}
\item{\code{X393}}{relative level of unknown compond X - 14147}
\item{\code{X394}}{relative level of unknown compond X - 14152}
\item{\code{X395}}{relative level of unknown compond X - 14189}
\item{\code{X396}}{relative level of unknown compond X - 14205}
\item{\code{X397}}{relative level of unknown compond X - 14208}
\item{\code{X398}}{relative level of unknown compond X - 14272}
\item{\code{X399}}{relative level of unknown compond X - 14478}
\item{\code{X400}}{relative level of unknown compond X - 14541}
\item{\code{X401}}{relative level of unknown compond X - 14551}
\item{\code{X402}}{relative level of unknown compond X - 14588}
\item{\code{X403}}{relative level of unknown compond X - 14600}
\item{\code{X404}}{relative level of unknown compond X - 14603}
\item{\code{X405}}{relative level of unknown compond X - 14625}
\item{\code{X406}}{relative level of unknown compond X - 14649}
\item{\code{X407}}{relative level of unknown compond X - 14658}
\item{\code{X408}}{relative level of unknown compond X - 14662}
\item{\code{X409}}{relative level of unknown compond X - 14745}
\item{\code{X411}}{relative level of unknown compond X - 14939}
\item{\code{X412}}{relative level of unknown compond X - 2973}
\item{\code{X413}}{relative level of unknown compond X - 3003}
\item{\code{X414}}{relative level of unknown compond X - 3094}
\item{\code{X415}}{relative level of unknown compond X - 4272}
\item{\code{X416}}{relative level of unknown compond X - 4357}
\item{\code{X417}}{relative level of unknown compond X - 4498}
\item{\code{X418}}{relative level of unknown compond X - 5524}
\item{\code{X419}}{relative level of unknown compond X - 5907}
\item{\code{X420}}{relative level of unknown compond X - 6227}
\item{\code{X421}}{relative level of unknown compond X - 6267}
\item{\code{X422}}{relative level of unknown compond X - 6307}
\item{\code{X423}}{relative level of unknown compond X - 6346}
\item{\code{X424}}{relative level of unknown compond X - 8766}
\item{\code{X425}}{relative level of unknown compond X - 8889}
\item{\code{X426}}{relative level of unknown compond X - 9044}
\item{\code{X427}}{relative level of unknown compond X - 9045}
\item{\code{X428}}{relative level of unknown compond X - 9108}

  }
}
\details{

  Serum samples from three groups of individuals were compared: tuberculin
  skin test negative (NEG), positive (POS) and clinical tuberculosis (TB).
}
\source{
  Weiner J 3rd, Parida SK, Maertzdorf J, Black GF, Repsilber D, et al.
  (2012) Biomarkers of Inflammation, Immunosuppression and Stress 
  Are Revealed by Metabolomic Profiling of Tuberculosis
  Patients. PLoS ONE 7(7): e40221. doi:10.1371/journal.pone.0040221

}
%\references{
%%  ~~ possibly secondary sources and usages ~~
%}
\examples{
data(metabo)
## maybe str(metabo) ; plot(metabo) ...
pca <- prcomp( metabo[,-1] )
}
\keyword{datasets}
