% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.ddmatrix.r
\docType{methods}
\name{as.ddmatrix}
\alias{as.ddmatrix}
\alias{as.ddmatrix,NULL-method}
\alias{as.ddmatrix,matrix-method}
\alias{as.ddmatrix,vector-method}
\alias{distribute}
\title{Non-Distributed object to Distributed Object Converters}
\usage{
as.ddmatrix(x, ...)

distribute(x, bldim = .pbd_env$BLDIM, xCTXT = 0, ICTXT = .pbd_env$ICTXT)

\S4method{as.ddmatrix}{matrix}(x, bldim = .pbd_env$BLDIM,
  ICTXT = .pbd_env$ICTXT)

\S4method{as.ddmatrix}{`NULL`}(x, bldim = .pbd_env$BLDIM,
  ICTXT = .pbd_env$ICTXT)

\S4method{as.ddmatrix}{vector}(x, bldim = .pbd_env$BLDIM,
  ICTXT = .pbd_env$ICTXT)
}
\arguments{
\item{x}{a numeric matrix}

\item{...}{Additional arguments.}

\item{bldim}{the blocking dimension for block-cyclically distributing the
matrix across the process grid.}

\item{xCTXT}{the BLACS context number for initial distribution of the matrix
\code{x}.}

\item{ICTXT}{BLACS context number for return.}
}
\value{
Returns a distributed matrix.
}
\description{
A simplified interface to the \code{distribute()} and \code{redistribute()}
functions.
}
\details{
A simplified wrapper for the \code{distribute()} function, especially in the
case that the matrix \code{x} is global (which you really should not ever
let happen outside of testing, but I won't stop you).

The function will only work if \code{x} is stored on all processes, or
\code{x} is stored on a single process (does not matter which) and every
other process has NULL stored for x.

If several processes own pieces of the matrix \code{x}, then you can not use
this function. You will have to create an appropriate \code{ddmatrix} on all
processes and redistriubte the data with the \code{redistribute()} function.

As usual, the \code{ICTXT} number is the BLACS context corresponding to the
process grid onto which the output distributed matrix will be distributed.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

if (comm.rank()==0){
  x <- matrix(1:16, ncol=4)
} else {
  x <- NULL
}

dx <- as.ddmatrix(x, bldim=2)
dx

### Can also be common to all ranks
y <- matrix(1:25, 5, bldim=2)
dy <- as.ddmatrix(y)
dy

finalize()
}

}
\keyword{Data}
\keyword{Distributing}

