% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{pricing}
\alias{pricing}
\title{AWS Price List Service}
\usage{
pricing(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS Price List Service API (AWS Price List Service) is a centralized and
convenient way to programmatically query Amazon Web Services for
services, products, and pricing information. The AWS Price List Service
uses standardized product attributes such as \code{Location},
\verb{Storage Class}, and \verb{Operating System}, and provides prices at the SKU
level. You can use the AWS Price List Service to build cost control and
scenario planning tools, reconcile billing data, forecast future spend
for budgeting purposes, and provide cost benefit analysis that compare
your internal workloads with AWS.

Use \code{GetServices} without a service code to retrieve the service codes
for all AWS services, then \code{GetServices} with a service code to retreive
the attribute names for that service. After you have the service code
and attribute names, you can use \code{GetAttributeValues} to see what values
are available for an attribute. With the service code and an attribute
name and value, you can use \code{GetProducts} to find specific products that
you\'re interested in, such as an \code{AmazonEC2} instance, with a
\verb{Provisioned IOPS} \code{volumeType}.

Service Endpoint

AWS Price List Service API provides the following two endpoints:
\itemize{
\item https://api.pricing.us-east-1.amazonaws.com
\item https://api.pricing.ap-south-1.amazonaws.com
}
}
\section{Service syntax}{
\preformatted{svc <- pricing(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=pricing_describe_services]{describe_services} \tab Returns the metadata for one service or a list of the metadata for all services\cr
\link[=pricing_get_attribute_values]{get_attribute_values} \tab Returns a list of attribute values \cr
\link[=pricing_get_products]{get_products} \tab Returns a list of all products that match the filter criteria
}
}

\examples{
\dontrun{
svc <- pricing()
svc$describe_services(
  FormatVersion = "aws_v1",
  MaxResults = 1L,
  ServiceCode = "AmazonEC2"
)
}

}
