% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_objects}
\alias{s3_list_objects}
\title{This operation is not supported for directory buckets}
\usage{
s3_list_objects(
  Bucket,
  Delimiter = NULL,
  EncodingType = NULL,
  Marker = NULL,
  MaxKeys = NULL,
  Prefix = NULL,
  RequestPayer = NULL,
  ExpectedBucketOwner = NULL,
  OptionalObjectAttributes = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the objects.

\strong{Directory buckets} - When you use this operation with a directory
bucket, you must use virtual-hosted-style requests in the format
\code{ Bucket-name.s3express-zone-id.region-code.amazonaws.com}. Path-style
requests are not supported. Directory bucket names must be unique in the
chosen Zone (Availability Zone or Local Zone). Bucket names must follow
the format \code{ bucket-base-name--zone-id--x-s3} (for example,
\code{ DOC-EXAMPLE-BUCKET--usw2-az1--x-s3}). For information about bucket
naming restrictions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html}{Directory bucket naming rules}
in the \emph{Amazon S3 User Guide}.

\strong{Access points} - When you use this action with an access point, you
must provide the alias of the access point in place of the bucket name
or specify the access point ARN. When using the access point ARN, you
must direct requests to the access point hostname. The access point
hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

Access points and Object Lambda access points are not supported by
directory buckets.

\strong{S3 on Outposts} - When you use this action with Amazon S3 on
Outposts, you must direct requests to the S3 on Outposts hostname. The
S3 on Outposts hostname takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts access point ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/s3-outposts/S3onOutposts.html}{What is S3 on Outposts?}
in the \emph{Amazon S3 User Guide}.}

\item{Delimiter}{A delimiter is a character that you use to group keys.}

\item{EncodingType}{}

\item{Marker}{Marker is where you want Amazon S3 to start listing from. Amazon S3
starts listing after this specified key. Marker can be any key in the
bucket.}

\item{MaxKeys}{Sets the maximum number of keys returned in the response. By default,
the action returns up to 1,000 key names. The response might contain
fewer keys but will never contain more.}

\item{Prefix}{Limits the response to keys that begin with the specified prefix.}

\item{RequestPayer}{Confirms that the requester knows that she or he will be charged for the
list objects request. Bucket owners need not specify this parameter in
their requests.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}

\item{OptionalObjectAttributes}{Specifies the optional fields that you want returned in the response.
Fields that you do not specify are not returned.}
}
\description{
This operation is not supported for directory buckets.

See \url{https://www.paws-r-sdk.com/docs/s3_list_objects/} for full documentation.
}
\keyword{internal}
