# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include storagegateway_service.R
NULL

#' Activates the gateway you previously deployed on your host
#'
#' @description
#' Activates the gateway you previously deployed on your host. In the activation process, you specify information such as the Amazon Web Services Region that you want to use for storing snapshots or tapes, the time zone for scheduled snapshots the gateway snapshot schedule window, an activation key, and a name for your gateway. The activation process also associates your gateway with your account. For more information, see [`update_gateway_information`][storagegateway_update_gateway_information].
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_activate_gateway/](https://www.paws-r-sdk.com/docs/storagegateway_activate_gateway/) for full documentation.
#'
#' @param ActivationKey &#91;required&#93; Your gateway activation key. You can obtain the activation key by
#' sending an HTTP GET request with redirects enabled to the gateway IP
#' address (port 80). The redirect URL returned in the response provides
#' you the activation key for your gateway in the query string parameter
#' `activationKey`. It may also include other activation-related
#' parameters, however, these are merely defaults -- the arguments you pass
#' to the [`activate_gateway`][storagegateway_activate_gateway] API call
#' determine the actual configuration of your gateway.
#' 
#' For more information, see [Getting activation
#' key](https://docs.aws.amazon.com/storagegateway/) in the *Storage
#' Gateway User Guide*.
#' @param GatewayName &#91;required&#93; The name you configured for your gateway.
#' @param GatewayTimezone &#91;required&#93; A value that indicates the time zone you want to set for the gateway.
#' The time zone is of the format "GMT", "GMT-hr:mm", or "GMT+hr:mm". For
#' example, GMT indicates Greenwich Mean Time without any offset. GMT-4:00
#' indicates the time is 4 hours behind GMT. GMT+2:00 indicates the time is
#' 2 hours ahead of GMT. The time zone is used, for example, for scheduling
#' snapshots and your gateway's maintenance schedule.
#' @param GatewayRegion &#91;required&#93; A value that indicates the Amazon Web Services Region where you want to
#' store your data. The gateway Amazon Web Services Region specified must
#' be the same Amazon Web Services Region as the Amazon Web Services Region
#' in your `Host` header in the request. For more information about
#' available Amazon Web Services Regions and endpoints for Storage Gateway,
#' see [Storage Gateway endpoints and
#' quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html) in the
#' *Amazon Web Services General Reference*.
#' 
#' Valid Values: See [Storage Gateway endpoints and
#' quotas](https://docs.aws.amazon.com/general/latest/gr/sg.html) in the
#' *Amazon Web Services General Reference*.
#' @param GatewayType A value that defines the type of gateway to activate. The type specified
#' is critical to all later functions of the gateway and cannot be changed
#' after activation. The default value is `CACHED`.
#' 
#' Valid Values: `STORED` | `CACHED` | `VTL` | `FILE_S3` | `FILE_FSX_SMB`
#' @param TapeDriveType The value that indicates the type of tape drive to use for tape gateway.
#' This field is optional.
#' 
#' Valid Values: `IBM-ULT3580-TD5`
#' @param MediumChangerType The value that indicates the type of medium changer to use for tape
#' gateway. This field is optional.
#' 
#' Valid Values: `STK-L700` | `AWS-Gateway-VTL` | `IBM-03584L32-0402`
#' @param Tags A list of up to 50 tags that you can assign to the gateway. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers that
#' can be represented in UTF-8 format, and the following special
#' characters: + - = . _ : / @@. The maximum length of a tag's key is 128
#' characters, and the maximum length for a tag's value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname storagegateway_activate_gateway
storagegateway_activate_gateway <- function(ActivationKey, GatewayName, GatewayTimezone, GatewayRegion, GatewayType = NULL, TapeDriveType = NULL, MediumChangerType = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ActivateGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$activate_gateway_input(ActivationKey = ActivationKey, GatewayName = GatewayName, GatewayTimezone = GatewayTimezone, GatewayRegion = GatewayRegion, GatewayType = GatewayType, TapeDriveType = TapeDriveType, MediumChangerType = MediumChangerType, Tags = Tags)
  output <- .storagegateway$activate_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$activate_gateway <- storagegateway_activate_gateway

#' Configures one or more gateway local disks as cache for a gateway
#'
#' @description
#' Configures one or more gateway local disks as cache for a gateway. This operation is only supported in the cached volume, tape, and file gateway type (see [How Storage Gateway works (architecture)](https://docs.aws.amazon.com/storagegateway/).
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_add_cache/](https://www.paws-r-sdk.com/docs/storagegateway_add_cache/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskIds &#91;required&#93; An array of strings that identify disks that are to be configured as
#' working storage. Each string has a minimum length of 1 and maximum
#' length of 300. You can get the disk IDs from the
#' [`list_local_disks`][storagegateway_list_local_disks] API.
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_cache
storagegateway_add_cache <- function(GatewayARN, DiskIds) {
  op <- new_operation(
    name = "AddCache",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$add_cache_input(GatewayARN = GatewayARN, DiskIds = DiskIds)
  output <- .storagegateway$add_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_cache <- storagegateway_add_cache

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource. You use tags to add metadata to resources, which you can use to categorize these resources. For example, you can categorize resources by purpose, owner, environment, or team. Each tag consists of a key and a value, which you define. You can add tags to the following Storage Gateway resources:
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_add_tags_to_resource/](https://www.paws-r-sdk.com/docs/storagegateway_add_tags_to_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to add tags to.
#' @param Tags &#91;required&#93; The key-value pair that represents the tag you want to add to the
#' resource. The value can be an empty string.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_tags_to_resource
storagegateway_add_tags_to_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$add_tags_to_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .storagegateway$add_tags_to_resource_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_tags_to_resource <- storagegateway_add_tags_to_resource

#' Configures one or more gateway local disks as upload buffer for a
#' specified gateway
#'
#' @description
#' Configures one or more gateway local disks as upload buffer for a specified gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_add_upload_buffer/](https://www.paws-r-sdk.com/docs/storagegateway_add_upload_buffer/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskIds &#91;required&#93; An array of strings that identify disks that are to be configured as
#' working storage. Each string has a minimum length of 1 and maximum
#' length of 300. You can get the disk IDs from the
#' [`list_local_disks`][storagegateway_list_local_disks] API.
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_upload_buffer
storagegateway_add_upload_buffer <- function(GatewayARN, DiskIds) {
  op <- new_operation(
    name = "AddUploadBuffer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$add_upload_buffer_input(GatewayARN = GatewayARN, DiskIds = DiskIds)
  output <- .storagegateway$add_upload_buffer_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_upload_buffer <- storagegateway_add_upload_buffer

#' Configures one or more gateway local disks as working storage for a
#' gateway
#'
#' @description
#' Configures one or more gateway local disks as working storage for a gateway. This operation is only supported in the stored volume gateway type. This operation is deprecated in cached volume API version 20120630. Use [`add_upload_buffer`][storagegateway_add_upload_buffer] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_add_working_storage/](https://www.paws-r-sdk.com/docs/storagegateway_add_working_storage/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskIds &#91;required&#93; An array of strings that identify disks that are to be configured as
#' working storage. Each string has a minimum length of 1 and maximum
#' length of 300. You can get the disk IDs from the
#' [`list_local_disks`][storagegateway_list_local_disks] API.
#'
#' @keywords internal
#'
#' @rdname storagegateway_add_working_storage
storagegateway_add_working_storage <- function(GatewayARN, DiskIds) {
  op <- new_operation(
    name = "AddWorkingStorage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$add_working_storage_input(GatewayARN = GatewayARN, DiskIds = DiskIds)
  output <- .storagegateway$add_working_storage_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$add_working_storage <- storagegateway_add_working_storage

#' Assigns a tape to a tape pool for archiving
#'
#' @description
#' Assigns a tape to a tape pool for archiving. The tape assigned to a pool is archived in the S3 storage class that is associated with the pool. When you use your backup application to eject the tape, the tape is archived directly into the S3 storage class (S3 Glacier or S3 Glacier Deep Archive) that corresponds to the pool.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_assign_tape_pool/](https://www.paws-r-sdk.com/docs/storagegateway_assign_tape_pool/) for full documentation.
#'
#' @param TapeARN &#91;required&#93; The unique Amazon Resource Name (ARN) of the virtual tape that you want
#' to add to the tape pool.
#' @param PoolId &#91;required&#93; The ID of the pool that you want to add your tape to for archiving. The
#' tape in this pool is archived in the S3 storage class that is associated
#' with the pool. When you use your backup application to eject the tape,
#' the tape is archived directly into the storage class (S3 Glacier or S3
#' Glacier Deep Archive) that corresponds to the pool.
#' @param BypassGovernanceRetention Set permissions to bypass governance retention. If the lock type of the
#' archived tape is `Governance`, the tape's archived age is not older than
#' `RetentionLockInDays`, and the user does not already have
#' `BypassGovernanceRetention`, setting this to TRUE enables the user to
#' bypass the retention lock. This parameter is set to true by default for
#' calls from the console.
#' 
#' Valid values: `TRUE` | `FALSE`
#'
#' @keywords internal
#'
#' @rdname storagegateway_assign_tape_pool
storagegateway_assign_tape_pool <- function(TapeARN, PoolId, BypassGovernanceRetention = NULL) {
  op <- new_operation(
    name = "AssignTapePool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$assign_tape_pool_input(TapeARN = TapeARN, PoolId = PoolId, BypassGovernanceRetention = BypassGovernanceRetention)
  output <- .storagegateway$assign_tape_pool_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$assign_tape_pool <- storagegateway_assign_tape_pool

#' Associate an Amazon FSx file system with the FSx File Gateway
#'
#' @description
#' Associate an Amazon FSx file system with the FSx File Gateway. After the association process is complete, the file shares on the Amazon FSx file system are available for access through the gateway. This operation only supports the FSx File Gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_associate_file_system/](https://www.paws-r-sdk.com/docs/storagegateway_associate_file_system/) for full documentation.
#'
#' @param UserName &#91;required&#93; The user name of the user credential that has permission to access the
#' root share D$ of the Amazon FSx file system. The user account must
#' belong to the Amazon FSx delegated admin user group.
#' @param Password &#91;required&#93; The password of the user credential.
#' @param ClientToken &#91;required&#93; A unique string value that you supply that is used by the FSx File
#' Gateway to ensure idempotent file system association creation.
#' @param GatewayARN &#91;required&#93; 
#' @param LocationARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon FSx file system to
#' associate with the FSx File Gateway.
#' @param Tags A list of up to 50 tags that can be assigned to the file system
#' association. Each tag is a key-value pair.
#' @param AuditDestinationARN The Amazon Resource Name (ARN) of the storage used for the audit logs.
#' @param CacheAttributes 
#' @param EndpointNetworkConfiguration Specifies the network configuration information for the gateway
#' associated with the Amazon FSx file system.
#' 
#' If multiple file systems are associated with this gateway, this
#' parameter's `IpAddresses` field is required.
#'
#' @keywords internal
#'
#' @rdname storagegateway_associate_file_system
storagegateway_associate_file_system <- function(UserName, Password, ClientToken, GatewayARN, LocationARN, Tags = NULL, AuditDestinationARN = NULL, CacheAttributes = NULL, EndpointNetworkConfiguration = NULL) {
  op <- new_operation(
    name = "AssociateFileSystem",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$associate_file_system_input(UserName = UserName, Password = Password, ClientToken = ClientToken, GatewayARN = GatewayARN, LocationARN = LocationARN, Tags = Tags, AuditDestinationARN = AuditDestinationARN, CacheAttributes = CacheAttributes, EndpointNetworkConfiguration = EndpointNetworkConfiguration)
  output <- .storagegateway$associate_file_system_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$associate_file_system <- storagegateway_associate_file_system

#' Connects a volume to an iSCSI connection and then attaches the volume to
#' the specified gateway
#'
#' @description
#' Connects a volume to an iSCSI connection and then attaches the volume to the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_attach_volume/](https://www.paws-r-sdk.com/docs/storagegateway_attach_volume/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the gateway that you want to attach
#' the volume to.
#' @param TargetName The name of the iSCSI target used by an initiator to connect to a volume
#' and used as a suffix for the target ARN. For example, specifying
#' `TargetName` as *myvolume* results in the target ARN of
#' `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`.
#' The target name must be unique across all volumes on a gateway.
#' 
#' If you don't specify a value, Storage Gateway uses the value that was
#' previously used for this volume as the new target name.
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume to attach to the specified
#' gateway.
#' @param NetworkInterfaceId &#91;required&#93; The network interface of the gateway on which to expose the iSCSI
#' target. Only IPv4 addresses are accepted. Use
#' [`describe_gateway_information`][storagegateway_describe_gateway_information]
#' to get a list of the network interfaces available on a gateway.
#' 
#' Valid Values: A valid IP address.
#' @param DiskId The unique device ID or other distinguishing data that identifies the
#' local disk used to create the volume. This value is only required when
#' you are attaching a stored volume.
#'
#' @keywords internal
#'
#' @rdname storagegateway_attach_volume
storagegateway_attach_volume <- function(GatewayARN, TargetName = NULL, VolumeARN, NetworkInterfaceId, DiskId = NULL) {
  op <- new_operation(
    name = "AttachVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$attach_volume_input(GatewayARN = GatewayARN, TargetName = TargetName, VolumeARN = VolumeARN, NetworkInterfaceId = NetworkInterfaceId, DiskId = DiskId)
  output <- .storagegateway$attach_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$attach_volume <- storagegateway_attach_volume

#' Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
#' after the archiving process is initiated
#'
#' @description
#' Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after the archiving process is initiated. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_cancel_archival/](https://www.paws-r-sdk.com/docs/storagegateway_cancel_archival/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape you want to cancel
#' archiving for.
#'
#' @keywords internal
#'
#' @rdname storagegateway_cancel_archival
storagegateway_cancel_archival <- function(GatewayARN, TapeARN) {
  op <- new_operation(
    name = "CancelArchival",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$cancel_archival_input(GatewayARN = GatewayARN, TapeARN = TapeARN)
  output <- .storagegateway$cancel_archival_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$cancel_archival <- storagegateway_cancel_archival

#' Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
#' a gateway after the retrieval process is initiated
#'
#' @description
#' Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to a gateway after the retrieval process is initiated. The virtual tape is returned to the VTS. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_cancel_retrieval/](https://www.paws-r-sdk.com/docs/storagegateway_cancel_retrieval/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape you want to cancel
#' retrieval for.
#'
#' @keywords internal
#'
#' @rdname storagegateway_cancel_retrieval
storagegateway_cancel_retrieval <- function(GatewayARN, TapeARN) {
  op <- new_operation(
    name = "CancelRetrieval",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$cancel_retrieval_input(GatewayARN = GatewayARN, TapeARN = TapeARN)
  output <- .storagegateway$cancel_retrieval_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$cancel_retrieval <- storagegateway_cancel_retrieval

#' Creates a cached volume on a specified cached volume gateway
#'
#' @description
#' Creates a cached volume on a specified cached volume gateway. This operation is only supported in the cached volume gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_cachedi_scsi_volume/](https://www.paws-r-sdk.com/docs/storagegateway_create_cachedi_scsi_volume/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param VolumeSizeInBytes &#91;required&#93; The size of the volume in bytes.
#' @param SnapshotId The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the
#' new cached volume. Specify this field if you want to create the iSCSI
#' storage volume from a snapshot; otherwise, do not include this field. To
#' list snapshots for your account use
#' [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html)
#' in the *Amazon Elastic Compute Cloud API Reference*.
#' @param TargetName &#91;required&#93; The name of the iSCSI target used by an initiator to connect to a volume
#' and used as a suffix for the target ARN. For example, specifying
#' `TargetName` as *myvolume* results in the target ARN of
#' `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`.
#' The target name must be unique across all volumes on a gateway.
#' 
#' If you don't specify a value, Storage Gateway uses the value that was
#' previously used for this volume as the new target name.
#' @param SourceVolumeARN The ARN for an existing volume. Specifying this ARN makes the new volume
#' into an exact copy of the specified existing volume's latest recovery
#' point. The `VolumeSizeInBytes` value for this new volume must be equal
#' to or larger than the size of the existing volume, in bytes.
#' @param NetworkInterfaceId &#91;required&#93; The network interface of the gateway on which to expose the iSCSI
#' target. Only IPv4 addresses are accepted. Use
#' [`describe_gateway_information`][storagegateway_describe_gateway_information]
#' to get a list of the network interfaces available on a gateway.
#' 
#' Valid Values: A valid IP address.
#' @param ClientToken &#91;required&#93; A unique identifier that you use to retry a request. If you retry a
#' request, use the same `ClientToken` you specified in the initial
#' request.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param Tags A list of up to 50 tags that you can assign to a cached volume. Each tag
#' is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers that
#' you can represent in UTF-8 format, and the following special
#' characters: + - = . _ : / @@. The maximum length of a tag's key is 128
#' characters, and the maximum length for a tag's value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_cachedi_scsi_volume
storagegateway_create_cachedi_scsi_volume <- function(GatewayARN, VolumeSizeInBytes, SnapshotId = NULL, TargetName, SourceVolumeARN = NULL, NetworkInterfaceId, ClientToken, KMSEncrypted = NULL, KMSKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCachediSCSIVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_cachedi_scsi_volume_input(GatewayARN = GatewayARN, VolumeSizeInBytes = VolumeSizeInBytes, SnapshotId = SnapshotId, TargetName = TargetName, SourceVolumeARN = SourceVolumeARN, NetworkInterfaceId = NetworkInterfaceId, ClientToken = ClientToken, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Tags = Tags)
  output <- .storagegateway$create_cachedi_scsi_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_cachedi_scsi_volume <- storagegateway_create_cachedi_scsi_volume

#' Creates a Network File System (NFS) file share on an existing S3 File
#' Gateway
#'
#' @description
#' Creates a Network File System (NFS) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an NFS interface. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_nfs_file_share/](https://www.paws-r-sdk.com/docs/storagegateway_create_nfs_file_share/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; A unique string value that you supply that is used by S3 File Gateway to
#' ensure idempotent file share creation.
#' @param NFSFileShareDefaults File share default values. Optional.
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the S3 File Gateway on which you want
#' to create a file share.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param Role &#91;required&#93; The ARN of the Identity and Access Management (IAM) role that an S3 File
#' Gateway assumes when it accesses the underlying storage.
#' @param LocationARN &#91;required&#93; A custom ARN for the backend storage used for storing data for file
#' shares. It includes a resource ARN with an optional prefix
#' concatenation. The prefix must end with a forward slash (/).
#' 
#' You can specify LocationARN as a bucket ARN, access point ARN or access
#' point alias, as shown in the following examples.
#' 
#' Bucket ARN:
#' 
#' `arn:aws:s3:::my-bucket/prefix/`
#' 
#' Access point ARN:
#' 
#' `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
#' 
#' If you specify an access point, the bucket policy must be configured to
#' delegate access control to the access point. For information, see
#' [Delegating access control to access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control)
#' in the *Amazon S3 User Guide*.
#' 
#' Access point alias:
#' 
#' `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
#' 
#' Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` |
#' `S3_STANDARD_IA` | `S3_ONEZONE_IA`
#' @param ObjectACL A value that sets the access control list (ACL) permission for objects
#' in the S3 bucket that a S3 File Gateway puts objects into. The default
#' value is `private`.
#' @param ClientList The list of clients that are allowed to access the S3 File Gateway. The
#' list must contain either valid IP addresses or valid CIDR blocks.
#' @param Squash A value that maps a user to anonymous user.
#' 
#' Valid values are the following:
#' 
#' -   `RootSquash`: Only root is mapped to anonymous user.
#' 
#' -   `NoSquash`: No one is mapped to anonymous user.
#' 
#' -   `AllSquash`: Everyone is mapped to anonymous user.
#' @param ReadOnly A value that sets the write status of a file share. Set this value to
#' `true` to set the write status to read-only, otherwise set to `false`.
#' 
#' Valid Values: `true` | `false`
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to `true` to enable MIME type
#' guessing, otherwise set to `false`. The default value is `true`.
#' 
#' Valid Values: `true` | `false`
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to `true`, the requester pays the costs; otherwise, the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' 
#' Valid Values: `true` | `false`
#' @param Tags A list of up to 50 tags that can be assigned to the NFS file share. Each
#' tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#' @param FileShareName The name of the file share. Optional.
#' 
#' `FileShareName` must be set if an S3 prefix name is set in
#' `LocationARN`, or if an access point or access point alias is used.
#' @param CacheAttributes Specifies refresh cache information for the file share.
#' @param NotificationPolicy The notification policy of the file share. `SettlingTimeInSeconds`
#' controls the number of seconds to wait after the last point in time a
#' client wrote to a file before generating an `ObjectUploaded`
#' notification. Because clients can make many small writes to files, it's
#' best to set this parameter for as long as possible to avoid generating
#' multiple notifications for the same file in a small time period.
#' 
#' `SettlingTimeInSeconds` has no effect on the timing of the object
#' uploading to Amazon S3, only the timing of the notification.
#' 
#' The following example sets `NotificationPolicy` on with
#' `SettlingTimeInSeconds` set to 60.
#' 
#' `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
#' 
#' The following example sets `NotificationPolicy` off.
#' 
#' `{}`
#' @param VPCEndpointDNSName Specifies the DNS name for the VPC endpoint that the NFS file share uses
#' to connect to Amazon S3.
#' 
#' This parameter is required for NFS file shares that connect to Amazon S3
#' through a VPC endpoint, a VPC access point, or an access point alias
#' that points to a VPC access point.
#' @param BucketRegion Specifies the Region of the S3 bucket where the NFS file share stores
#' files.
#' 
#' This parameter is required for NFS file shares that connect to Amazon S3
#' through a VPC endpoint, a VPC access point, or an access point alias
#' that points to a VPC access point.
#' @param AuditDestinationARN The Amazon Resource Name (ARN) of the storage used for audit logs.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_nfs_file_share
storagegateway_create_nfs_file_share <- function(ClientToken, NFSFileShareDefaults = NULL, GatewayARN, KMSEncrypted = NULL, KMSKey = NULL, Role, LocationARN, DefaultStorageClass = NULL, ObjectACL = NULL, ClientList = NULL, Squash = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, Tags = NULL, FileShareName = NULL, CacheAttributes = NULL, NotificationPolicy = NULL, VPCEndpointDNSName = NULL, BucketRegion = NULL, AuditDestinationARN = NULL) {
  op <- new_operation(
    name = "CreateNFSFileShare",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_nfs_file_share_input(ClientToken = ClientToken, NFSFileShareDefaults = NFSFileShareDefaults, GatewayARN = GatewayARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Role = Role, LocationARN = LocationARN, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ClientList = ClientList, Squash = Squash, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, Tags = Tags, FileShareName = FileShareName, CacheAttributes = CacheAttributes, NotificationPolicy = NotificationPolicy, VPCEndpointDNSName = VPCEndpointDNSName, BucketRegion = BucketRegion, AuditDestinationARN = AuditDestinationARN)
  output <- .storagegateway$create_nfs_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_nfs_file_share <- storagegateway_create_nfs_file_share

#' Creates a Server Message Block (SMB) file share on an existing S3 File
#' Gateway
#'
#' @description
#' Creates a Server Message Block (SMB) file share on an existing S3 File Gateway. In Storage Gateway, a file share is a file system mount point backed by Amazon S3 cloud storage. Storage Gateway exposes file shares using an SMB interface. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_smb_file_share/](https://www.paws-r-sdk.com/docs/storagegateway_create_smb_file_share/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; A unique string value that you supply that is used by S3 File Gateway to
#' ensure idempotent file share creation.
#' @param GatewayARN &#91;required&#93; The ARN of the S3 File Gateway on which you want to create a file share.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param Role &#91;required&#93; The ARN of the Identity and Access Management (IAM) role that an S3 File
#' Gateway assumes when it accesses the underlying storage.
#' @param LocationARN &#91;required&#93; A custom ARN for the backend storage used for storing data for file
#' shares. It includes a resource ARN with an optional prefix
#' concatenation. The prefix must end with a forward slash (/).
#' 
#' You can specify LocationARN as a bucket ARN, access point ARN or access
#' point alias, as shown in the following examples.
#' 
#' Bucket ARN:
#' 
#' `arn:aws:s3:::my-bucket/prefix/`
#' 
#' Access point ARN:
#' 
#' `arn:aws:s3:region:account-id:accesspoint/access-point-name/prefix/`
#' 
#' If you specify an access point, the bucket policy must be configured to
#' delegate access control to the access point. For information, see
#' [Delegating access control to access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-policies.html#access-points-delegating-control)
#' in the *Amazon S3 User Guide*.
#' 
#' Access point alias:
#' 
#' `test-ap-ab123cdef4gehijklmn5opqrstuvuse1a-s3alias`
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
#' 
#' Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` |
#' `S3_STANDARD_IA` | `S3_ONEZONE_IA`
#' @param ObjectACL A value that sets the access control list (ACL) permission for objects
#' in the S3 bucket that a S3 File Gateway puts objects into. The default
#' value is `private`.
#' @param ReadOnly A value that sets the write status of a file share. Set this value to
#' `true` to set the write status to read-only, otherwise set to `false`.
#' 
#' Valid Values: `true` | `false`
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to `true` to enable MIME type
#' guessing, otherwise set to `false`. The default value is `true`.
#' 
#' Valid Values: `true` | `false`
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to `true`, the requester pays the costs; otherwise, the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' 
#' Valid Values: `true` | `false`
#' @param SMBACLEnabled Set this value to `true` to enable access control list (ACL) on the SMB
#' file share. Set it to `false` to map file and directory permissions to
#' the POSIX permissions.
#' 
#' For more information, see [Using Microsoft Windows ACLs to control
#' access to an SMB file
#' share](https://docs.aws.amazon.com/storagegateway/) in the *Storage
#' Gateway User Guide*.
#' 
#' Valid Values: `true` | `false`
#' @param AccessBasedEnumeration The files and folders on this share will only be visible to users with
#' read access.
#' @param AdminUserList A list of users or groups in the Active Directory that will be granted
#' administrator privileges on the file share. These users can do all file
#' operations as the super-user. Acceptable formats include:
#' `DOMAIN\\User1`, `user1`, `@@group1`, and `@@DOMAIN\\group1`.
#' 
#' Use this option very carefully, because any user in this list can do
#' anything they like on the file share, regardless of file permissions.
#' @param ValidUserList A list of users or groups in the Active Directory that are allowed to
#' access the file share. A group must be prefixed with the @@ character.
#' Acceptable formats include: `DOMAIN\\User1`, `user1`, `@@group1`, and
#' `@@DOMAIN\\group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param InvalidUserList A list of users or groups in the Active Directory that are not allowed
#' to access the file share. A group must be prefixed with the @@ character.
#' Acceptable formats include: `DOMAIN\\User1`, `user1`, `@@group1`, and
#' `@@DOMAIN\\group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param AuditDestinationARN The Amazon Resource Name (ARN) of the storage used for audit logs.
#' @param Authentication The authentication method that users use to access the file share. The
#' default is `ActiveDirectory`.
#' 
#' Valid Values: `ActiveDirectory` | `GuestAccess`
#' @param CaseSensitivity The case of an object name in an Amazon S3 bucket. For
#' `ClientSpecified`, the client determines the case sensitivity. For
#' `CaseSensitive`, the gateway determines the case sensitivity. The
#' default value is `ClientSpecified`.
#' @param Tags A list of up to 50 tags that can be assigned to the NFS file share. Each
#' tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#' @param FileShareName The name of the file share. Optional.
#' 
#' `FileShareName` must be set if an S3 prefix name is set in
#' `LocationARN`, or if an access point or access point alias is used.
#' @param CacheAttributes Specifies refresh cache information for the file share.
#' @param NotificationPolicy The notification policy of the file share. `SettlingTimeInSeconds`
#' controls the number of seconds to wait after the last point in time a
#' client wrote to a file before generating an `ObjectUploaded`
#' notification. Because clients can make many small writes to files, it's
#' best to set this parameter for as long as possible to avoid generating
#' multiple notifications for the same file in a small time period.
#' 
#' `SettlingTimeInSeconds` has no effect on the timing of the object
#' uploading to Amazon S3, only the timing of the notification.
#' 
#' The following example sets `NotificationPolicy` on with
#' `SettlingTimeInSeconds` set to 60.
#' 
#' `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
#' 
#' The following example sets `NotificationPolicy` off.
#' 
#' `{}`
#' @param VPCEndpointDNSName Specifies the DNS name for the VPC endpoint that the SMB file share uses
#' to connect to Amazon S3.
#' 
#' This parameter is required for SMB file shares that connect to Amazon S3
#' through a VPC endpoint, a VPC access point, or an access point alias
#' that points to a VPC access point.
#' @param BucketRegion Specifies the Region of the S3 bucket where the SMB file share stores
#' files.
#' 
#' This parameter is required for SMB file shares that connect to Amazon S3
#' through a VPC endpoint, a VPC access point, or an access point alias
#' that points to a VPC access point.
#' @param OplocksEnabled Specifies whether opportunistic locking is enabled for the SMB file
#' share.
#' 
#' Enabling opportunistic locking on case-sensitive shares is not
#' recommended for workloads that involve access to files with the same
#' name in different case.
#' 
#' Valid Values: `true` | `false`
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_smb_file_share
storagegateway_create_smb_file_share <- function(ClientToken, GatewayARN, KMSEncrypted = NULL, KMSKey = NULL, Role, LocationARN, DefaultStorageClass = NULL, ObjectACL = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, SMBACLEnabled = NULL, AccessBasedEnumeration = NULL, AdminUserList = NULL, ValidUserList = NULL, InvalidUserList = NULL, AuditDestinationARN = NULL, Authentication = NULL, CaseSensitivity = NULL, Tags = NULL, FileShareName = NULL, CacheAttributes = NULL, NotificationPolicy = NULL, VPCEndpointDNSName = NULL, BucketRegion = NULL, OplocksEnabled = NULL) {
  op <- new_operation(
    name = "CreateSMBFileShare",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_smb_file_share_input(ClientToken = ClientToken, GatewayARN = GatewayARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Role = Role, LocationARN = LocationARN, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, SMBACLEnabled = SMBACLEnabled, AccessBasedEnumeration = AccessBasedEnumeration, AdminUserList = AdminUserList, ValidUserList = ValidUserList, InvalidUserList = InvalidUserList, AuditDestinationARN = AuditDestinationARN, Authentication = Authentication, CaseSensitivity = CaseSensitivity, Tags = Tags, FileShareName = FileShareName, CacheAttributes = CacheAttributes, NotificationPolicy = NotificationPolicy, VPCEndpointDNSName = VPCEndpointDNSName, BucketRegion = BucketRegion, OplocksEnabled = OplocksEnabled)
  output <- .storagegateway$create_smb_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_smb_file_share <- storagegateway_create_smb_file_share

#' Initiates a snapshot of a volume
#'
#' @description
#' Initiates a snapshot of a volume.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_snapshot/](https://www.paws-r-sdk.com/docs/storagegateway_create_snapshot/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the
#' [`list_volumes`][storagegateway_list_volumes] operation to return a list
#' of gateway volumes.
#' @param SnapshotDescription &#91;required&#93; Textual description of the snapshot that appears in the Amazon EC2
#' console, Elastic Block Store snapshots panel in the **Description**
#' field, and in the Storage Gateway snapshot **Details** pane,
#' **Description** field.
#' @param Tags A list of up to 50 tags that can be assigned to a snapshot. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_snapshot
storagegateway_create_snapshot <- function(VolumeARN, SnapshotDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_snapshot_input(VolumeARN = VolumeARN, SnapshotDescription = SnapshotDescription, Tags = Tags)
  output <- .storagegateway$create_snapshot_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_snapshot <- storagegateway_create_snapshot

#' Initiates a snapshot of a gateway from a volume recovery point
#'
#' @description
#' Initiates a snapshot of a gateway from a volume recovery point. This operation is only supported in the cached volume gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_snapshot_from_volume_recovery_point/](https://www.paws-r-sdk.com/docs/storagegateway_create_snapshot_from_volume_recovery_point/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' [`describe_storedi_scsi_volumes`][storagegateway_describe_storedi_scsi_volumes]
#' operation to return to retrieve the TargetARN for specified VolumeARN.
#' @param SnapshotDescription &#91;required&#93; Textual description of the snapshot that appears in the Amazon EC2
#' console, Elastic Block Store snapshots panel in the **Description**
#' field, and in the Storage Gateway snapshot **Details** pane,
#' **Description** field.
#' @param Tags A list of up to 50 tags that can be assigned to a snapshot. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_snapshot_from_volume_recovery_point
storagegateway_create_snapshot_from_volume_recovery_point <- function(VolumeARN, SnapshotDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshotFromVolumeRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_snapshot_from_volume_recovery_point_input(VolumeARN = VolumeARN, SnapshotDescription = SnapshotDescription, Tags = Tags)
  output <- .storagegateway$create_snapshot_from_volume_recovery_point_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_snapshot_from_volume_recovery_point <- storagegateway_create_snapshot_from_volume_recovery_point

#' Creates a volume on a specified gateway
#'
#' @description
#' Creates a volume on a specified gateway. This operation is only supported in the stored volume gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_storedi_scsi_volume/](https://www.paws-r-sdk.com/docs/storagegateway_create_storedi_scsi_volume/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param DiskId &#91;required&#93; The unique identifier for the gateway local disk that is configured as a
#' stored volume. Use [`list_local_disks`][storagegateway_list_local_disks]
#' to list disk IDs for a gateway.
#' @param SnapshotId The snapshot ID (e.g., "snap-1122aabb") of the snapshot to restore as
#' the new stored volume. Specify this field if you want to create the
#' iSCSI storage volume from a snapshot; otherwise, do not include this
#' field. To list snapshots for your account use
#' [DescribeSnapshots](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSnapshots.html)
#' in the *Amazon Elastic Compute Cloud API Reference*.
#' @param PreserveExistingData &#91;required&#93; Set to `true` if you want to preserve the data on the local disk.
#' Otherwise, set to `false` to create an empty volume.
#' 
#' Valid Values: `true` | `false`
#' @param TargetName &#91;required&#93; The name of the iSCSI target used by an initiator to connect to a volume
#' and used as a suffix for the target ARN. For example, specifying
#' `TargetName` as *myvolume* results in the target ARN of
#' `arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume`.
#' The target name must be unique across all volumes on a gateway.
#' 
#' If you don't specify a value, Storage Gateway uses the value that was
#' previously used for this volume as the new target name.
#' @param NetworkInterfaceId &#91;required&#93; The network interface of the gateway on which to expose the iSCSI
#' target. Only IPv4 addresses are accepted. Use
#' [`describe_gateway_information`][storagegateway_describe_gateway_information]
#' to get a list of the network interfaces available on a gateway.
#' 
#' Valid Values: A valid IP address.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param Tags A list of up to 50 tags that can be assigned to a stored volume. Each
#' tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_storedi_scsi_volume
storagegateway_create_storedi_scsi_volume <- function(GatewayARN, DiskId, SnapshotId = NULL, PreserveExistingData, TargetName, NetworkInterfaceId, KMSEncrypted = NULL, KMSKey = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateStorediSCSIVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_storedi_scsi_volume_input(GatewayARN = GatewayARN, DiskId = DiskId, SnapshotId = SnapshotId, PreserveExistingData = PreserveExistingData, TargetName = TargetName, NetworkInterfaceId = NetworkInterfaceId, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, Tags = Tags)
  output <- .storagegateway$create_storedi_scsi_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_storedi_scsi_volume <- storagegateway_create_storedi_scsi_volume

#' Creates a new custom tape pool
#'
#' @description
#' Creates a new custom tape pool. You can use custom tape pool to enable tape retention lock on tapes that are archived in the custom pool.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_tape_pool/](https://www.paws-r-sdk.com/docs/storagegateway_create_tape_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; The name of the new custom tape pool.
#' @param StorageClass &#91;required&#93; The storage class that is associated with the new custom pool. When you
#' use your backup application to eject the tape, the tape is archived
#' directly into the storage class (S3 Glacier or S3 Glacier Deep Archive)
#' that corresponds to the pool.
#' @param RetentionLockType Tape retention lock can be configured in two modes. When configured in
#' governance mode, Amazon Web Services accounts with specific IAM
#' permissions are authorized to remove the tape retention lock from
#' archived virtual tapes. When configured in compliance mode, the tape
#' retention lock cannot be removed by any user, including the root Amazon
#' Web Services account.
#' @param RetentionLockTimeInDays Tape retention lock time is set in days. Tape retention lock can be
#' enabled for up to 100 years (36,500 days).
#' @param Tags A list of up to 50 tags that can be assigned to tape pool. Each tag is a
#' key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_tape_pool
storagegateway_create_tape_pool <- function(PoolName, StorageClass, RetentionLockType = NULL, RetentionLockTimeInDays = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTapePool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_tape_pool_input(PoolName = PoolName, StorageClass = StorageClass, RetentionLockType = RetentionLockType, RetentionLockTimeInDays = RetentionLockTimeInDays, Tags = Tags)
  output <- .storagegateway$create_tape_pool_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_tape_pool <- storagegateway_create_tape_pool

#' Creates a virtual tape by using your own barcode
#'
#' @description
#' Creates a virtual tape by using your own barcode. You write data to the virtual tape and then archive the tape. A barcode is unique and cannot be reused if it has already been used on a tape. This applies to barcodes used on deleted tapes. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_tape_with_barcode/](https://www.paws-r-sdk.com/docs/storagegateway_create_tape_with_barcode/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; The unique Amazon Resource Name (ARN) that represents the gateway to
#' associate the virtual tape with. Use the
#' [`list_gateways`][storagegateway_list_gateways] operation to return a
#' list of gateways for your account and Amazon Web Services Region.
#' @param TapeSizeInBytes &#91;required&#93; The size, in bytes, of the virtual tape that you want to create.
#' 
#' The size must be aligned by gigabyte (1024*1024*1024 bytes).
#' @param TapeBarcode &#91;required&#93; The barcode that you want to assign to the tape.
#' 
#' Barcodes cannot be reused. This includes barcodes used for tapes that
#' have been deleted.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param PoolId The ID of the pool that you want to add your tape to for archiving. The
#' tape in this pool is archived in the S3 storage class that is associated
#' with the pool. When you use your backup application to eject the tape,
#' the tape is archived directly into the storage class (S3 Glacier or S3
#' Deep Archive) that corresponds to the pool.
#' @param Worm Set to `TRUE` if the tape you are creating is to be configured as a
#' write-once-read-many (WORM) tape.
#' @param Tags A list of up to 50 tags that can be assigned to a virtual tape that has
#' a barcode. Each tag is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_tape_with_barcode
storagegateway_create_tape_with_barcode <- function(GatewayARN, TapeSizeInBytes, TapeBarcode, KMSEncrypted = NULL, KMSKey = NULL, PoolId = NULL, Worm = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTapeWithBarcode",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_tape_with_barcode_input(GatewayARN = GatewayARN, TapeSizeInBytes = TapeSizeInBytes, TapeBarcode = TapeBarcode, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, PoolId = PoolId, Worm = Worm, Tags = Tags)
  output <- .storagegateway$create_tape_with_barcode_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_tape_with_barcode <- storagegateway_create_tape_with_barcode

#' Creates one or more virtual tapes
#'
#' @description
#' Creates one or more virtual tapes. You write data to the virtual tapes and then archive the tapes. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_create_tapes/](https://www.paws-r-sdk.com/docs/storagegateway_create_tapes/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; The unique Amazon Resource Name (ARN) that represents the gateway to
#' associate the virtual tapes with. Use the
#' [`list_gateways`][storagegateway_list_gateways] operation to return a
#' list of gateways for your account and Amazon Web Services Region.
#' @param TapeSizeInBytes &#91;required&#93; The size, in bytes, of the virtual tapes that you want to create.
#' 
#' The size must be aligned by gigabyte (1024*1024*1024 bytes).
#' @param ClientToken &#91;required&#93; A unique identifier that you use to retry a request. If you retry a
#' request, use the same `ClientToken` you specified in the initial
#' request.
#' 
#' Using the same `ClientToken` prevents creating the tape multiple times.
#' @param NumTapesToCreate &#91;required&#93; The number of virtual tapes that you want to create.
#' @param TapeBarcodePrefix &#91;required&#93; A prefix that you append to the barcode of the virtual tape you are
#' creating. This prefix makes the barcode unique.
#' 
#' The prefix must be 1-4 characters in length and must be one of the
#' uppercase letters from A to Z.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param PoolId The ID of the pool that you want to add your tape to for archiving. The
#' tape in this pool is archived in the S3 storage class that is associated
#' with the pool. When you use your backup application to eject the tape,
#' the tape is archived directly into the storage class (S3 Glacier or S3
#' Glacier Deep Archive) that corresponds to the pool.
#' @param Worm Set to `TRUE` if the tape you are creating is to be configured as a
#' write-once-read-many (WORM) tape.
#' @param Tags A list of up to 50 tags that can be assigned to a virtual tape. Each tag
#' is a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_create_tapes
storagegateway_create_tapes <- function(GatewayARN, TapeSizeInBytes, ClientToken, NumTapesToCreate, TapeBarcodePrefix, KMSEncrypted = NULL, KMSKey = NULL, PoolId = NULL, Worm = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTapes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$create_tapes_input(GatewayARN = GatewayARN, TapeSizeInBytes = TapeSizeInBytes, ClientToken = ClientToken, NumTapesToCreate = NumTapesToCreate, TapeBarcodePrefix = TapeBarcodePrefix, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, PoolId = PoolId, Worm = Worm, Tags = Tags)
  output <- .storagegateway$create_tapes_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$create_tapes <- storagegateway_create_tapes

#' Deletes the automatic tape creation policy of a gateway
#'
#' @description
#' Deletes the automatic tape creation policy of a gateway. If you delete this policy, new virtual tapes must be created manually. Use the Amazon Resource Name (ARN) of the gateway in your request to remove the policy.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_automatic_tape_creation_policy/](https://www.paws-r-sdk.com/docs/storagegateway_delete_automatic_tape_creation_policy/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_automatic_tape_creation_policy
storagegateway_delete_automatic_tape_creation_policy <- function(GatewayARN) {
  op <- new_operation(
    name = "DeleteAutomaticTapeCreationPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_automatic_tape_creation_policy_input(GatewayARN = GatewayARN)
  output <- .storagegateway$delete_automatic_tape_creation_policy_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_automatic_tape_creation_policy <- storagegateway_delete_automatic_tape_creation_policy

#' Deletes the bandwidth rate limits of a gateway
#'
#' @description
#' Deletes the bandwidth rate limits of a gateway. You can delete either the upload and download bandwidth rate limit, or you can delete both. If you delete only one of the limits, the other limit remains unchanged. To specify which gateway to work with, use the Amazon Resource Name (ARN) of the gateway in your request. This operation is supported only for the stored volume, cached volume, and tape gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_bandwidth_rate_limit/](https://www.paws-r-sdk.com/docs/storagegateway_delete_bandwidth_rate_limit/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param BandwidthType &#91;required&#93; One of the BandwidthType values that indicates the gateway bandwidth
#' rate limit to delete.
#' 
#' Valid Values: `UPLOAD` | `DOWNLOAD` | `ALL`
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_bandwidth_rate_limit
storagegateway_delete_bandwidth_rate_limit <- function(GatewayARN, BandwidthType) {
  op <- new_operation(
    name = "DeleteBandwidthRateLimit",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_bandwidth_rate_limit_input(GatewayARN = GatewayARN, BandwidthType = BandwidthType)
  output <- .storagegateway$delete_bandwidth_rate_limit_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_bandwidth_rate_limit <- storagegateway_delete_bandwidth_rate_limit

#' Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
#' for a specified iSCSI target and initiator pair
#'
#' @description
#' Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target and initiator pair. This operation is supported in volume and tape gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_chap_credentials/](https://www.paws-r-sdk.com/docs/storagegateway_delete_chap_credentials/) for full documentation.
#'
#' @param TargetARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' [`describe_storedi_scsi_volumes`][storagegateway_describe_storedi_scsi_volumes]
#' operation to return to retrieve the TargetARN for specified VolumeARN.
#' @param InitiatorName &#91;required&#93; The iSCSI initiator that connects to the target.
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_chap_credentials
storagegateway_delete_chap_credentials <- function(TargetARN, InitiatorName) {
  op <- new_operation(
    name = "DeleteChapCredentials",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_chap_credentials_input(TargetARN = TargetARN, InitiatorName = InitiatorName)
  output <- .storagegateway$delete_chap_credentials_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_chap_credentials <- storagegateway_delete_chap_credentials

#' Deletes a file share from an S3 File Gateway
#'
#' @description
#' Deletes a file share from an S3 File Gateway. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_file_share/](https://www.paws-r-sdk.com/docs/storagegateway_delete_file_share/) for full documentation.
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the file share to be deleted.
#' @param ForceDelete If this value is set to `true`, the operation deletes a file share
#' immediately and aborts all data uploads to Amazon Web Services.
#' Otherwise, the file share is not deleted until all data is uploaded to
#' Amazon Web Services. This process aborts the data upload process, and
#' the file share enters the `FORCE_DELETING` status.
#' 
#' Valid Values: `true` | `false`
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_file_share
storagegateway_delete_file_share <- function(FileShareARN, ForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteFileShare",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_file_share_input(FileShareARN = FileShareARN, ForceDelete = ForceDelete)
  output <- .storagegateway$delete_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_file_share <- storagegateway_delete_file_share

#' Deletes a gateway
#'
#' @description
#' Deletes a gateway. To specify which gateway to delete, use the Amazon Resource Name (ARN) of the gateway in your request. The operation deletes the gateway; however, it does not delete the gateway virtual machine (VM) from your host computer.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_gateway/](https://www.paws-r-sdk.com/docs/storagegateway_delete_gateway/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_gateway
storagegateway_delete_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "DeleteGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$delete_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_gateway <- storagegateway_delete_gateway

#' Deletes a snapshot of a volume
#'
#' @description
#' Deletes a snapshot of a volume.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_snapshot_schedule/](https://www.paws-r-sdk.com/docs/storagegateway_delete_snapshot_schedule/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The volume which snapshot schedule to delete.
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_snapshot_schedule
storagegateway_delete_snapshot_schedule <- function(VolumeARN) {
  op <- new_operation(
    name = "DeleteSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_snapshot_schedule_input(VolumeARN = VolumeARN)
  output <- .storagegateway$delete_snapshot_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_snapshot_schedule <- storagegateway_delete_snapshot_schedule

#' Deletes the specified virtual tape
#'
#' @description
#' Deletes the specified virtual tape. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_tape/](https://www.paws-r-sdk.com/docs/storagegateway_delete_tape/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; The unique Amazon Resource Name (ARN) of the gateway that the virtual
#' tape to delete is associated with. Use the
#' [`list_gateways`][storagegateway_list_gateways] operation to return a
#' list of gateways for your account and Amazon Web Services Region.
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape to delete.
#' @param BypassGovernanceRetention Set to `TRUE` to delete an archived tape that belongs to a custom pool
#' with tape retention lock. Only archived tapes with tape retention lock
#' set to `governance` can be deleted. Archived tapes with tape retention
#' lock set to `compliance` can't be deleted.
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_tape
storagegateway_delete_tape <- function(GatewayARN, TapeARN, BypassGovernanceRetention = NULL) {
  op <- new_operation(
    name = "DeleteTape",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_tape_input(GatewayARN = GatewayARN, TapeARN = TapeARN, BypassGovernanceRetention = BypassGovernanceRetention)
  output <- .storagegateway$delete_tape_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_tape <- storagegateway_delete_tape

#' Deletes the specified virtual tape from the virtual tape shelf (VTS)
#'
#' @description
#' Deletes the specified virtual tape from the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_tape_archive/](https://www.paws-r-sdk.com/docs/storagegateway_delete_tape_archive/) for full documentation.
#'
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape to delete from the
#' virtual tape shelf (VTS).
#' @param BypassGovernanceRetention Set to `TRUE` to delete an archived tape that belongs to a custom pool
#' with tape retention lock. Only archived tapes with tape retention lock
#' set to `governance` can be deleted. Archived tapes with tape retention
#' lock set to `compliance` can't be deleted.
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_tape_archive
storagegateway_delete_tape_archive <- function(TapeARN, BypassGovernanceRetention = NULL) {
  op <- new_operation(
    name = "DeleteTapeArchive",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_tape_archive_input(TapeARN = TapeARN, BypassGovernanceRetention = BypassGovernanceRetention)
  output <- .storagegateway$delete_tape_archive_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_tape_archive <- storagegateway_delete_tape_archive

#' Delete a custom tape pool
#'
#' @description
#' Delete a custom tape pool. A custom tape pool can only be deleted if there are no tapes in the pool and if there are no automatic tape creation policies that reference the custom tape pool.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_tape_pool/](https://www.paws-r-sdk.com/docs/storagegateway_delete_tape_pool/) for full documentation.
#'
#' @param PoolARN &#91;required&#93; The Amazon Resource Name (ARN) of the custom tape pool to delete.
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_tape_pool
storagegateway_delete_tape_pool <- function(PoolARN) {
  op <- new_operation(
    name = "DeleteTapePool",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_tape_pool_input(PoolARN = PoolARN)
  output <- .storagegateway$delete_tape_pool_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_tape_pool <- storagegateway_delete_tape_pool

#' Deletes the specified storage volume that you previously created using
#' the CreateCachediSCSIVolume or CreateStorediSCSIVolume API
#'
#' @description
#' Deletes the specified storage volume that you previously created using the [`create_cachedi_scsi_volume`][storagegateway_create_cachedi_scsi_volume] or [`create_storedi_scsi_volume`][storagegateway_create_storedi_scsi_volume] API. This operation is only supported in the cached volume and stored volume types. For stored volume gateways, the local disk that was configured as the storage volume is not deleted. You can reuse the local disk to create another storage volume.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_delete_volume/](https://www.paws-r-sdk.com/docs/storagegateway_delete_volume/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the
#' [`list_volumes`][storagegateway_list_volumes] operation to return a list
#' of gateway volumes.
#'
#' @keywords internal
#'
#' @rdname storagegateway_delete_volume
storagegateway_delete_volume <- function(VolumeARN) {
  op <- new_operation(
    name = "DeleteVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$delete_volume_input(VolumeARN = VolumeARN)
  output <- .storagegateway$delete_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$delete_volume <- storagegateway_delete_volume

#' Returns information about the most recent high availability monitoring
#' test that was performed on the host in a cluster
#'
#' @description
#' Returns information about the most recent high availability monitoring test that was performed on the host in a cluster. If a test isn't performed, the status and start time in the response would be null.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_availability_monitor_test/](https://www.paws-r-sdk.com/docs/storagegateway_describe_availability_monitor_test/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_availability_monitor_test
storagegateway_describe_availability_monitor_test <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeAvailabilityMonitorTest",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_availability_monitor_test_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_availability_monitor_test_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_availability_monitor_test <- storagegateway_describe_availability_monitor_test

#' Returns the bandwidth rate limits of a gateway
#'
#' @description
#' Returns the bandwidth rate limits of a gateway. By default, these limits are not set, which means no bandwidth rate limiting is in effect. This operation is supported only for the stored volume, cached volume, and tape gateway types. To describe bandwidth rate limits for S3 file gateways, use [`describe_bandwidth_rate_limit_schedule`][storagegateway_describe_bandwidth_rate_limit_schedule].
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_bandwidth_rate_limit/](https://www.paws-r-sdk.com/docs/storagegateway_describe_bandwidth_rate_limit/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_bandwidth_rate_limit
storagegateway_describe_bandwidth_rate_limit <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeBandwidthRateLimit",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_bandwidth_rate_limit_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_bandwidth_rate_limit_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_bandwidth_rate_limit <- storagegateway_describe_bandwidth_rate_limit

#' Returns information about the bandwidth rate limit schedule of a gateway
#'
#' @description
#' Returns information about the bandwidth rate limit schedule of a gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. This operation is supported only for volume, tape and S3 file gateways. FSx file gateways do not support bandwidth rate limits.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_bandwidth_rate_limit_schedule/](https://www.paws-r-sdk.com/docs/storagegateway_describe_bandwidth_rate_limit_schedule/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_bandwidth_rate_limit_schedule
storagegateway_describe_bandwidth_rate_limit_schedule <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeBandwidthRateLimitSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_bandwidth_rate_limit_schedule_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_bandwidth_rate_limit_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_bandwidth_rate_limit_schedule <- storagegateway_describe_bandwidth_rate_limit_schedule

#' Returns information about the cache of a gateway
#'
#' @description
#' Returns information about the cache of a gateway. This operation is only supported in the cached volume, tape, and file gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_cache/](https://www.paws-r-sdk.com/docs/storagegateway_describe_cache/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_cache
storagegateway_describe_cache <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeCache",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_cache_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_cache <- storagegateway_describe_cache

#' Returns a description of the gateway volumes specified in the request
#'
#' @description
#' Returns a description of the gateway volumes specified in the request. This operation is only supported in the cached volume gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_cachedi_scsi_volumes/](https://www.paws-r-sdk.com/docs/storagegateway_describe_cachedi_scsi_volumes/) for full documentation.
#'
#' @param VolumeARNs &#91;required&#93; An array of strings where each string represents the Amazon Resource
#' Name (ARN) of a cached volume. All of the specified cached volumes must
#' be from the same gateway. Use
#' [`list_volumes`][storagegateway_list_volumes] to get volume ARNs for a
#' gateway.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_cachedi_scsi_volumes
storagegateway_describe_cachedi_scsi_volumes <- function(VolumeARNs) {
  op <- new_operation(
    name = "DescribeCachediSCSIVolumes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "CachediSCSIVolumes")
  )
  input <- .storagegateway$describe_cachedi_scsi_volumes_input(VolumeARNs = VolumeARNs)
  output <- .storagegateway$describe_cachedi_scsi_volumes_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_cachedi_scsi_volumes <- storagegateway_describe_cachedi_scsi_volumes

#' Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
#' credentials information for a specified iSCSI target, one for each
#' target-initiator pair
#'
#' @description
#' Returns an array of Challenge-Handshake Authentication Protocol (CHAP) credentials information for a specified iSCSI target, one for each target-initiator pair. This operation is supported in the volume and tape gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_chap_credentials/](https://www.paws-r-sdk.com/docs/storagegateway_describe_chap_credentials/) for full documentation.
#'
#' @param TargetARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' [`describe_storedi_scsi_volumes`][storagegateway_describe_storedi_scsi_volumes]
#' operation to return to retrieve the TargetARN for specified VolumeARN.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_chap_credentials
storagegateway_describe_chap_credentials <- function(TargetARN) {
  op <- new_operation(
    name = "DescribeChapCredentials",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_chap_credentials_input(TargetARN = TargetARN)
  output <- .storagegateway$describe_chap_credentials_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_chap_credentials <- storagegateway_describe_chap_credentials

#' Gets the file system association information
#'
#' @description
#' Gets the file system association information. This operation is only supported for FSx File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_file_system_associations/](https://www.paws-r-sdk.com/docs/storagegateway_describe_file_system_associations/) for full documentation.
#'
#' @param FileSystemAssociationARNList &#91;required&#93; An array containing the Amazon Resource Name (ARN) of each file system
#' association to be described.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_file_system_associations
storagegateway_describe_file_system_associations <- function(FileSystemAssociationARNList) {
  op <- new_operation(
    name = "DescribeFileSystemAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_file_system_associations_input(FileSystemAssociationARNList = FileSystemAssociationARNList)
  output <- .storagegateway$describe_file_system_associations_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_file_system_associations <- storagegateway_describe_file_system_associations

#' Returns metadata about a gateway such as its name, network interfaces,
#' time zone, status, and software version
#'
#' @description
#' Returns metadata about a gateway such as its name, network interfaces, time zone, status, and software version. To specify which gateway to describe, use the Amazon Resource Name (ARN) of the gateway in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_gateway_information/](https://www.paws-r-sdk.com/docs/storagegateway_describe_gateway_information/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_gateway_information
storagegateway_describe_gateway_information <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeGatewayInformation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_gateway_information_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_gateway_information_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_gateway_information <- storagegateway_describe_gateway_information

#' Returns your gateway's maintenance window schedule information, with
#' values for monthly or weekly cadence, specific day and time to begin
#' maintenance, and which types of updates to apply
#'
#' @description
#' Returns your gateway's maintenance window schedule information, with values for monthly or weekly cadence, specific day and time to begin maintenance, and which types of updates to apply. Time values returned are for the gateway's time zone.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_maintenance_start_time/](https://www.paws-r-sdk.com/docs/storagegateway_describe_maintenance_start_time/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_maintenance_start_time
storagegateway_describe_maintenance_start_time <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeMaintenanceStartTime",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_maintenance_start_time_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_maintenance_start_time_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_maintenance_start_time <- storagegateway_describe_maintenance_start_time

#' Gets a description for one or more Network File System (NFS) file shares
#' from an S3 File Gateway
#'
#' @description
#' Gets a description for one or more Network File System (NFS) file shares from an S3 File Gateway. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_nfs_file_shares/](https://www.paws-r-sdk.com/docs/storagegateway_describe_nfs_file_shares/) for full documentation.
#'
#' @param FileShareARNList &#91;required&#93; An array containing the Amazon Resource Name (ARN) of each file share to
#' be described.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_nfs_file_shares
storagegateway_describe_nfs_file_shares <- function(FileShareARNList) {
  op <- new_operation(
    name = "DescribeNFSFileShares",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_nfs_file_shares_input(FileShareARNList = FileShareARNList)
  output <- .storagegateway$describe_nfs_file_shares_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_nfs_file_shares <- storagegateway_describe_nfs_file_shares

#' Gets a description for one or more Server Message Block (SMB) file
#' shares from a S3 File Gateway
#'
#' @description
#' Gets a description for one or more Server Message Block (SMB) file shares from a S3 File Gateway. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_smb_file_shares/](https://www.paws-r-sdk.com/docs/storagegateway_describe_smb_file_shares/) for full documentation.
#'
#' @param FileShareARNList &#91;required&#93; An array containing the Amazon Resource Name (ARN) of each file share to
#' be described.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_smb_file_shares
storagegateway_describe_smb_file_shares <- function(FileShareARNList) {
  op <- new_operation(
    name = "DescribeSMBFileShares",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_smb_file_shares_input(FileShareARNList = FileShareARNList)
  output <- .storagegateway$describe_smb_file_shares_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_smb_file_shares <- storagegateway_describe_smb_file_shares

#' Gets a description of a Server Message Block (SMB) file share settings
#' from a file gateway
#'
#' @description
#' Gets a description of a Server Message Block (SMB) file share settings from a file gateway. This operation is only supported for file gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_smb_settings/](https://www.paws-r-sdk.com/docs/storagegateway_describe_smb_settings/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_smb_settings
storagegateway_describe_smb_settings <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeSMBSettings",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_smb_settings_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_smb_settings_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_smb_settings <- storagegateway_describe_smb_settings

#' Describes the snapshot schedule for the specified gateway volume
#'
#' @description
#' Describes the snapshot schedule for the specified gateway volume. The snapshot schedule information includes intervals at which snapshots are automatically initiated on the volume. This operation is only supported in the cached volume and stored volume types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_snapshot_schedule/](https://www.paws-r-sdk.com/docs/storagegateway_describe_snapshot_schedule/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the
#' [`list_volumes`][storagegateway_list_volumes] operation to return a list
#' of gateway volumes.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_snapshot_schedule
storagegateway_describe_snapshot_schedule <- function(VolumeARN) {
  op <- new_operation(
    name = "DescribeSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_snapshot_schedule_input(VolumeARN = VolumeARN)
  output <- .storagegateway$describe_snapshot_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_snapshot_schedule <- storagegateway_describe_snapshot_schedule

#' Returns the description of the gateway volumes specified in the request
#'
#' @description
#' Returns the description of the gateway volumes specified in the request. The list of gateway volumes in the request must be from one gateway. In the response, Storage Gateway returns volume information sorted by volume ARNs. This operation is only supported in stored volume gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_storedi_scsi_volumes/](https://www.paws-r-sdk.com/docs/storagegateway_describe_storedi_scsi_volumes/) for full documentation.
#'
#' @param VolumeARNs &#91;required&#93; An array of strings where each string represents the Amazon Resource
#' Name (ARN) of a stored volume. All of the specified stored volumes must
#' be from the same gateway. Use
#' [`list_volumes`][storagegateway_list_volumes] to get volume ARNs for a
#' gateway.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_storedi_scsi_volumes
storagegateway_describe_storedi_scsi_volumes <- function(VolumeARNs) {
  op <- new_operation(
    name = "DescribeStorediSCSIVolumes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "StorediSCSIVolumes")
  )
  input <- .storagegateway$describe_storedi_scsi_volumes_input(VolumeARNs = VolumeARNs)
  output <- .storagegateway$describe_storedi_scsi_volumes_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_storedi_scsi_volumes <- storagegateway_describe_storedi_scsi_volumes

#' Returns a description of specified virtual tapes in the virtual tape
#' shelf (VTS)
#'
#' @description
#' Returns a description of specified virtual tapes in the virtual tape shelf (VTS). This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_tape_archives/](https://www.paws-r-sdk.com/docs/storagegateway_describe_tape_archives/) for full documentation.
#'
#' @param TapeARNs Specifies one or more unique Amazon Resource Names (ARNs) that represent
#' the virtual tapes you want to describe.
#' @param Marker An opaque string that indicates the position at which to begin
#' describing virtual tapes.
#' @param Limit Specifies that the number of virtual tapes described be limited to the
#' specified number.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_tape_archives
storagegateway_describe_tape_archives <- function(TapeARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTapeArchives",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "TapeArchives")
  )
  input <- .storagegateway$describe_tape_archives_input(TapeARNs = TapeARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_tape_archives_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_tape_archives <- storagegateway_describe_tape_archives

#' Returns a list of virtual tape recovery points that are available for
#' the specified tape gateway
#'
#' @description
#' Returns a list of virtual tape recovery points that are available for the specified tape gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_tape_recovery_points/](https://www.paws-r-sdk.com/docs/storagegateway_describe_tape_recovery_points/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param Marker An opaque string that indicates the position at which to begin
#' describing the virtual tape recovery points.
#' @param Limit Specifies that the number of virtual tape recovery points that are
#' described be limited to the specified number.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_tape_recovery_points
storagegateway_describe_tape_recovery_points <- function(GatewayARN, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTapeRecoveryPoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "TapeRecoveryPointInfos")
  )
  input <- .storagegateway$describe_tape_recovery_points_input(GatewayARN = GatewayARN, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_tape_recovery_points_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_tape_recovery_points <- storagegateway_describe_tape_recovery_points

#' Returns a description of virtual tapes that correspond to the specified
#' Amazon Resource Names (ARNs)
#'
#' @description
#' Returns a description of virtual tapes that correspond to the specified Amazon Resource Names (ARNs). If `TapeARN` is not specified, returns a description of the virtual tapes associated with the specified gateway. This operation is only supported for the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_tapes/](https://www.paws-r-sdk.com/docs/storagegateway_describe_tapes/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param TapeARNs Specifies one or more unique Amazon Resource Names (ARNs) that represent
#' the virtual tapes you want to describe. If this parameter is not
#' specified, Tape gateway returns a description of all virtual tapes
#' associated with the specified gateway.
#' @param Marker A marker value, obtained in a previous call to
#' [`describe_tapes`][storagegateway_describe_tapes]. This marker indicates
#' which page of results to retrieve.
#' 
#' If not specified, the first page of results is retrieved.
#' @param Limit Specifies that the number of virtual tapes described be limited to the
#' specified number.
#' 
#' Amazon Web Services may impose its own limit, if this field is not set.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_tapes
storagegateway_describe_tapes <- function(GatewayARN, TapeARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeTapes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "Tapes")
  )
  input <- .storagegateway$describe_tapes_input(GatewayARN = GatewayARN, TapeARNs = TapeARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_tapes_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_tapes <- storagegateway_describe_tapes

#' Returns information about the upload buffer of a gateway
#'
#' @description
#' Returns information about the upload buffer of a gateway. This operation is supported for the stored volume, cached volume, and tape gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_upload_buffer/](https://www.paws-r-sdk.com/docs/storagegateway_describe_upload_buffer/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_upload_buffer
storagegateway_describe_upload_buffer <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeUploadBuffer",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_upload_buffer_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_upload_buffer_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_upload_buffer <- storagegateway_describe_upload_buffer

#' Returns a description of virtual tape library (VTL) devices for the
#' specified tape gateway
#'
#' @description
#' Returns a description of virtual tape library (VTL) devices for the specified tape gateway. In the response, Storage Gateway returns VTL device information.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_vtl_devices/](https://www.paws-r-sdk.com/docs/storagegateway_describe_vtl_devices/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param VTLDeviceARNs An array of strings, where each string represents the Amazon Resource
#' Name (ARN) of a VTL device.
#' 
#' All of the specified VTL devices must be from the same gateway. If no
#' VTL devices are specified, the result will contain all devices on the
#' specified gateway.
#' @param Marker An opaque string that indicates the position at which to begin
#' describing the VTL devices.
#' @param Limit Specifies that the number of VTL devices described be limited to the
#' specified number.
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_vtl_devices
storagegateway_describe_vtl_devices <- function(GatewayARN, VTLDeviceARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeVTLDevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "VTLDevices")
  )
  input <- .storagegateway$describe_vtl_devices_input(GatewayARN = GatewayARN, VTLDeviceARNs = VTLDeviceARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$describe_vtl_devices_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_vtl_devices <- storagegateway_describe_vtl_devices

#' Returns information about the working storage of a gateway
#'
#' @description
#' Returns information about the working storage of a gateway. This operation is only supported in the stored volumes gateway type. This operation is deprecated in cached volumes API version (20120630). Use DescribeUploadBuffer instead.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_describe_working_storage/](https://www.paws-r-sdk.com/docs/storagegateway_describe_working_storage/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_describe_working_storage
storagegateway_describe_working_storage <- function(GatewayARN) {
  op <- new_operation(
    name = "DescribeWorkingStorage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$describe_working_storage_input(GatewayARN = GatewayARN)
  output <- .storagegateway$describe_working_storage_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$describe_working_storage <- storagegateway_describe_working_storage

#' Disconnects a volume from an iSCSI connection and then detaches the
#' volume from the specified gateway
#'
#' @description
#' Disconnects a volume from an iSCSI connection and then detaches the volume from the specified gateway. Detaching and attaching a volume enables you to recover your data from one gateway to a different gateway without creating a snapshot. It also makes it easier to move your volumes from an on-premises gateway to a gateway hosted on an Amazon EC2 instance. This operation is only supported in the volume gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_detach_volume/](https://www.paws-r-sdk.com/docs/storagegateway_detach_volume/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume to detach from the gateway.
#' @param ForceDetach Set to `true` to forcibly remove the iSCSI connection of the target
#' volume and detach the volume. The default is `false`. If this value is
#' set to `false`, you must manually disconnect the iSCSI connection from
#' the target volume.
#' 
#' Valid Values: `true` | `false`
#'
#' @keywords internal
#'
#' @rdname storagegateway_detach_volume
storagegateway_detach_volume <- function(VolumeARN, ForceDetach = NULL) {
  op <- new_operation(
    name = "DetachVolume",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$detach_volume_input(VolumeARN = VolumeARN, ForceDetach = ForceDetach)
  output <- .storagegateway$detach_volume_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$detach_volume <- storagegateway_detach_volume

#' Disables a tape gateway when the gateway is no longer functioning
#'
#' @description
#' Disables a tape gateway when the gateway is no longer functioning. For example, if your gateway VM is damaged, you can disable the gateway so you can recover virtual tapes.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_disable_gateway/](https://www.paws-r-sdk.com/docs/storagegateway_disable_gateway/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_disable_gateway
storagegateway_disable_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "DisableGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$disable_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$disable_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$disable_gateway <- storagegateway_disable_gateway

#' Disassociates an Amazon FSx file system from the specified gateway
#'
#' @description
#' Disassociates an Amazon FSx file system from the specified gateway. After the disassociation process finishes, the gateway can no longer access the Amazon FSx file system. This operation is only supported in the FSx File Gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_disassociate_file_system/](https://www.paws-r-sdk.com/docs/storagegateway_disassociate_file_system/) for full documentation.
#'
#' @param FileSystemAssociationARN &#91;required&#93; The Amazon Resource Name (ARN) of the file system association to be
#' deleted.
#' @param ForceDelete If this value is set to true, the operation disassociates an Amazon FSx
#' file system immediately. It ends all data uploads to the file system,
#' and the file system association enters the `FORCE_DELETING` status. If
#' this value is set to false, the Amazon FSx file system does not
#' disassociate until all data is uploaded.
#'
#' @keywords internal
#'
#' @rdname storagegateway_disassociate_file_system
storagegateway_disassociate_file_system <- function(FileSystemAssociationARN, ForceDelete = NULL) {
  op <- new_operation(
    name = "DisassociateFileSystem",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$disassociate_file_system_input(FileSystemAssociationARN = FileSystemAssociationARN, ForceDelete = ForceDelete)
  output <- .storagegateway$disassociate_file_system_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$disassociate_file_system <- storagegateway_disassociate_file_system

#' Adds a file gateway to an Active Directory domain
#'
#' @description
#' Adds a file gateway to an Active Directory domain. This operation is only supported for file gateways that support the SMB file protocol.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_join_domain/](https://www.paws-r-sdk.com/docs/storagegateway_join_domain/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the gateway. Use the
#' [`list_gateways`][storagegateway_list_gateways] operation to return a
#' list of gateways for your account and Amazon Web Services Region.
#' @param DomainName &#91;required&#93; The name of the domain that you want the gateway to join.
#' @param OrganizationalUnit The organizational unit (OU) is a container in an Active Directory that
#' can hold users, groups, computers, and other OUs and this parameter
#' specifies the OU that the gateway will join within the AD domain.
#' @param DomainControllers List of IPv4 addresses, NetBIOS names, or host names of your domain
#' server. If you need to specify the port number include it after the
#' colon (“:”). For example, `mydc.mydomain.com:389`.
#' @param TimeoutInSeconds Specifies the time in seconds, in which the
#' [`join_domain`][storagegateway_join_domain] operation must complete. The
#' default is 20 seconds.
#' @param UserName &#91;required&#93; Sets the user name of user who has permission to add the gateway to the
#' Active Directory domain. The domain user account should be enabled to
#' join computers to the domain. For example, you can use the domain
#' administrator account or an account with delegated permissions to join
#' computers to the domain.
#' @param Password &#91;required&#93; Sets the password of the user who has permission to add the gateway to
#' the Active Directory domain.
#'
#' @keywords internal
#'
#' @rdname storagegateway_join_domain
storagegateway_join_domain <- function(GatewayARN, DomainName, OrganizationalUnit = NULL, DomainControllers = NULL, TimeoutInSeconds = NULL, UserName, Password) {
  op <- new_operation(
    name = "JoinDomain",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$join_domain_input(GatewayARN = GatewayARN, DomainName = DomainName, OrganizationalUnit = OrganizationalUnit, DomainControllers = DomainControllers, TimeoutInSeconds = TimeoutInSeconds, UserName = UserName, Password = Password)
  output <- .storagegateway$join_domain_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$join_domain <- storagegateway_join_domain

#' Lists the automatic tape creation policies for a gateway
#'
#' @description
#' Lists the automatic tape creation policies for a gateway. If there are no automatic tape creation policies for the gateway, it returns an empty list.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_automatic_tape_creation_policies/](https://www.paws-r-sdk.com/docs/storagegateway_list_automatic_tape_creation_policies/) for full documentation.
#'
#' @param GatewayARN 
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_automatic_tape_creation_policies
storagegateway_list_automatic_tape_creation_policies <- function(GatewayARN = NULL) {
  op <- new_operation(
    name = "ListAutomaticTapeCreationPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$list_automatic_tape_creation_policies_input(GatewayARN = GatewayARN)
  output <- .storagegateway$list_automatic_tape_creation_policies_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_automatic_tape_creation_policies <- storagegateway_list_automatic_tape_creation_policies

#' Gets a list of the file shares for a specific S3 File Gateway, or the
#' list of file shares that belong to the calling Amazon Web Services
#' account
#'
#' @description
#' Gets a list of the file shares for a specific S3 File Gateway, or the list of file shares that belong to the calling Amazon Web Services account. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_file_shares/](https://www.paws-r-sdk.com/docs/storagegateway_list_file_shares/) for full documentation.
#'
#' @param GatewayARN The Amazon Resource Name (ARN) of the gateway whose file shares you want
#' to list. If this field is not present, all file shares under your
#' account are listed.
#' @param Limit The maximum number of file shares to return in the response. The value
#' must be an integer with a value greater than zero. Optional.
#' @param Marker Opaque pagination token returned from a previous ListFileShares
#' operation. If present, `Marker` specifies where to continue the list
#' from after a previous call to ListFileShares. Optional.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_file_shares
storagegateway_list_file_shares <- function(GatewayARN = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListFileShares",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", non_aggregate_keys = list( "Marker"), output_token = "NextMarker", result_key = "FileShareInfoList")
  )
  input <- .storagegateway$list_file_shares_input(GatewayARN = GatewayARN, Limit = Limit, Marker = Marker)
  output <- .storagegateway$list_file_shares_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_file_shares <- storagegateway_list_file_shares

#' Gets a list of FileSystemAssociationSummary objects
#'
#' @description
#' Gets a list of `FileSystemAssociationSummary` objects. Each object contains a summary of a file system association. This operation is only supported for FSx File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_file_system_associations/](https://www.paws-r-sdk.com/docs/storagegateway_list_file_system_associations/) for full documentation.
#'
#' @param GatewayARN 
#' @param Limit The maximum number of file system associations to return in the
#' response. If present, `Limit` must be an integer with a value greater
#' than zero. Optional.
#' @param Marker Opaque pagination token returned from a previous
#' [`list_file_system_associations`][storagegateway_list_file_system_associations]
#' operation. If present, `Marker` specifies where to continue the list
#' from after a previous call to
#' [`list_file_system_associations`][storagegateway_list_file_system_associations].
#' Optional.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_file_system_associations
storagegateway_list_file_system_associations <- function(GatewayARN = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListFileSystemAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", non_aggregate_keys = list( "Marker"), output_token = "NextMarker", result_key = "FileSystemAssociationSummaryList")
  )
  input <- .storagegateway$list_file_system_associations_input(GatewayARN = GatewayARN, Limit = Limit, Marker = Marker)
  output <- .storagegateway$list_file_system_associations_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_file_system_associations <- storagegateway_list_file_system_associations

#' Lists gateways owned by an Amazon Web Services account in an Amazon Web
#' Services Region specified in the request
#'
#' @description
#' Lists gateways owned by an Amazon Web Services account in an Amazon Web Services Region specified in the request. The returned list is ordered by gateway Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_gateways/](https://www.paws-r-sdk.com/docs/storagegateway_list_gateways/) for full documentation.
#'
#' @param Marker An opaque string that indicates the position at which to begin the
#' returned list of gateways.
#' @param Limit Specifies that the list of gateways returned be limited to the specified
#' number of items.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_gateways
storagegateway_list_gateways <- function(Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListGateways",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "Gateways")
  )
  input <- .storagegateway$list_gateways_input(Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_gateways_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_gateways <- storagegateway_list_gateways

#' Returns a list of the gateway's local disks
#'
#' @description
#' Returns a list of the gateway's local disks. To specify which gateway to describe, you use the Amazon Resource Name (ARN) of the gateway in the body of the request.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_local_disks/](https://www.paws-r-sdk.com/docs/storagegateway_list_local_disks/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_local_disks
storagegateway_list_local_disks <- function(GatewayARN) {
  op <- new_operation(
    name = "ListLocalDisks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "Disks")
  )
  input <- .storagegateway$list_local_disks_input(GatewayARN = GatewayARN)
  output <- .storagegateway$list_local_disks_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_local_disks <- storagegateway_list_local_disks

#' Lists the tags that have been added to the specified resource
#'
#' @description
#' Lists the tags that have been added to the specified resource. This operation is supported in storage gateways of all types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/storagegateway_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which you want to
#' list tags.
#' @param Marker An opaque string that indicates the position at which to begin returning
#' the list of tags.
#' @param Limit Specifies that the list of tags returned be limited to the specified
#' number of items.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_tags_for_resource
storagegateway_list_tags_for_resource <- function(ResourceARN, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", non_aggregate_keys = list( "ResourceARN"), output_token = "Marker", result_key = "Tags")
  )
  input <- .storagegateway$list_tags_for_resource_input(ResourceARN = ResourceARN, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_tags_for_resource_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_tags_for_resource <- storagegateway_list_tags_for_resource

#' Lists custom tape pools
#'
#' @description
#' Lists custom tape pools. You specify custom tape pools to list by specifying one or more custom tape pool Amazon Resource Names (ARNs). If you don't specify a custom tape pool ARN, the operation lists all custom tape pools.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_tape_pools/](https://www.paws-r-sdk.com/docs/storagegateway_list_tape_pools/) for full documentation.
#'
#' @param PoolARNs The Amazon Resource Name (ARN) of each of the custom tape pools you want
#' to list. If you don't specify a custom tape pool ARN, the response lists
#' all custom tape pools.
#' @param Marker A string that indicates the position at which to begin the returned list
#' of tape pools.
#' @param Limit An optional number limit for the tape pools in the list returned by this
#' call.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_tape_pools
storagegateway_list_tape_pools <- function(PoolARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTapePools",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "PoolInfos")
  )
  input <- .storagegateway$list_tape_pools_input(PoolARNs = PoolARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_tape_pools_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_tape_pools <- storagegateway_list_tape_pools

#' Lists virtual tapes in your virtual tape library (VTL) and your virtual
#' tape shelf (VTS)
#'
#' @description
#' Lists virtual tapes in your virtual tape library (VTL) and your virtual tape shelf (VTS). You specify the tapes to list by specifying one or more tape Amazon Resource Names (ARNs). If you don't specify a tape ARN, the operation lists all virtual tapes in both your VTL and VTS.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_tapes/](https://www.paws-r-sdk.com/docs/storagegateway_list_tapes/) for full documentation.
#'
#' @param TapeARNs 
#' @param Marker A string that indicates the position at which to begin the returned list
#' of tapes.
#' @param Limit An optional number limit for the tapes in the list returned by this
#' call.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_tapes
storagegateway_list_tapes <- function(TapeARNs = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTapes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "TapeInfos")
  )
  input <- .storagegateway$list_tapes_input(TapeARNs = TapeARNs, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_tapes_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_tapes <- storagegateway_list_tapes

#' Lists iSCSI initiators that are connected to a volume
#'
#' @description
#' Lists iSCSI initiators that are connected to a volume. You can use this operation to determine whether a volume is being used or not. This operation is only supported in the cached volume and stored volume gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_volume_initiators/](https://www.paws-r-sdk.com/docs/storagegateway_list_volume_initiators/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the
#' [`list_volumes`][storagegateway_list_volumes] operation to return a list
#' of gateway volumes for the gateway.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_volume_initiators
storagegateway_list_volume_initiators <- function(VolumeARN) {
  op <- new_operation(
    name = "ListVolumeInitiators",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$list_volume_initiators_input(VolumeARN = VolumeARN)
  output <- .storagegateway$list_volume_initiators_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_volume_initiators <- storagegateway_list_volume_initiators

#' Lists the recovery points for a specified gateway
#'
#' @description
#' Lists the recovery points for a specified gateway. This operation is only supported in the cached volume gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_volume_recovery_points/](https://www.paws-r-sdk.com/docs/storagegateway_list_volume_recovery_points/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_volume_recovery_points
storagegateway_list_volume_recovery_points <- function(GatewayARN) {
  op <- new_operation(
    name = "ListVolumeRecoveryPoints",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(result_key = "VolumeRecoveryPointInfos")
  )
  input <- .storagegateway$list_volume_recovery_points_input(GatewayARN = GatewayARN)
  output <- .storagegateway$list_volume_recovery_points_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_volume_recovery_points <- storagegateway_list_volume_recovery_points

#' Lists the iSCSI stored volumes of a gateway
#'
#' @description
#' Lists the iSCSI stored volumes of a gateway. Results are sorted by volume ARN. The response includes only the volume ARNs. If you want additional volume information, use the [`describe_storedi_scsi_volumes`][storagegateway_describe_storedi_scsi_volumes] or the [`describe_cachedi_scsi_volumes`][storagegateway_describe_cachedi_scsi_volumes] API.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_list_volumes/](https://www.paws-r-sdk.com/docs/storagegateway_list_volumes/) for full documentation.
#'
#' @param GatewayARN 
#' @param Marker A string that indicates the position at which to begin the returned list
#' of volumes. Obtain the marker from the response of a previous List iSCSI
#' Volumes request.
#' @param Limit Specifies that the list of volumes returned be limited to the specified
#' number of items.
#'
#' @keywords internal
#'
#' @rdname storagegateway_list_volumes
storagegateway_list_volumes <- function(GatewayARN = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListVolumes",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "Limit", output_token = "Marker", result_key = "VolumeInfos")
  )
  input <- .storagegateway$list_volumes_input(GatewayARN = GatewayARN, Marker = Marker, Limit = Limit)
  output <- .storagegateway$list_volumes_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$list_volumes <- storagegateway_list_volumes

#' Sends you notification through CloudWatch Events when all files written
#' to your file share have been uploaded to Amazon S3
#'
#' @description
#' Sends you notification through CloudWatch Events when all files written to your file share have been uploaded to Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_notify_when_uploaded/](https://www.paws-r-sdk.com/docs/storagegateway_notify_when_uploaded/) for full documentation.
#'
#' @param FileShareARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_notify_when_uploaded
storagegateway_notify_when_uploaded <- function(FileShareARN) {
  op <- new_operation(
    name = "NotifyWhenUploaded",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$notify_when_uploaded_input(FileShareARN = FileShareARN)
  output <- .storagegateway$notify_when_uploaded_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$notify_when_uploaded <- storagegateway_notify_when_uploaded

#' Refreshes the cached inventory of objects for the specified file share
#'
#' @description
#' Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only supported in the S3 File Gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_refresh_cache/](https://www.paws-r-sdk.com/docs/storagegateway_refresh_cache/) for full documentation.
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the file share you want to refresh.
#' @param FolderList A comma-separated list of the paths of folders to refresh in the cache.
#' The default is \[`"/"`\]. The default refreshes objects and folders at
#' the root of the Amazon S3 bucket. If `Recursive` is set to `true`, the
#' entire S3 bucket that the file share has access to is refreshed.
#' 
#' Do not include `/` when specifying folder names. For example, you would
#' specify `samplefolder` rather than `samplefolder/`.
#' @param Recursive A value that specifies whether to recursively refresh folders in the
#' cache. The refresh includes folders that were in the cache the last time
#' the gateway listed the folder's contents. If this value set to `true`,
#' each folder that is listed in `FolderList` is recursively updated.
#' Otherwise, subfolders listed in `FolderList` are not refreshed. Only
#' objects that are in folders listed directly under `FolderList` are found
#' and used for the update. The default is `true`.
#' 
#' Valid Values: `true` | `false`
#'
#' @keywords internal
#'
#' @rdname storagegateway_refresh_cache
storagegateway_refresh_cache <- function(FileShareARN, FolderList = NULL, Recursive = NULL) {
  op <- new_operation(
    name = "RefreshCache",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$refresh_cache_input(FileShareARN = FileShareARN, FolderList = FolderList, Recursive = Recursive)
  output <- .storagegateway$refresh_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$refresh_cache <- storagegateway_refresh_cache

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource. This operation is supported in storage gateways of all types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_remove_tags_from_resource/](https://www.paws-r-sdk.com/docs/storagegateway_remove_tags_from_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to remove the
#' tags from.
#' @param TagKeys &#91;required&#93; The keys of the tags you want to remove from the specified resource. A
#' tag is composed of a key-value pair.
#'
#' @keywords internal
#'
#' @rdname storagegateway_remove_tags_from_resource
storagegateway_remove_tags_from_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$remove_tags_from_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .storagegateway$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$remove_tags_from_resource <- storagegateway_remove_tags_from_resource

#' Resets all cache disks that have encountered an error and makes the
#' disks available for reconfiguration as cache storage
#'
#' @description
#' Resets all cache disks that have encountered an error and makes the disks available for reconfiguration as cache storage. If your cache disk encounters an error, the gateway prevents read and write operations on virtual tapes in the gateway. For example, an error can occur when a disk is corrupted or removed from the gateway. When a cache is reset, the gateway loses its cache storage. At this point, you can reconfigure the disks as cache disks. This operation is only supported in the cached volume and tape types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_reset_cache/](https://www.paws-r-sdk.com/docs/storagegateway_reset_cache/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_reset_cache
storagegateway_reset_cache <- function(GatewayARN) {
  op <- new_operation(
    name = "ResetCache",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$reset_cache_input(GatewayARN = GatewayARN)
  output <- .storagegateway$reset_cache_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$reset_cache <- storagegateway_reset_cache

#' Retrieves an archived virtual tape from the virtual tape shelf (VTS) to
#' a tape gateway
#'
#' @description
#' Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a tape gateway. Virtual tapes archived in the VTS are not associated with any gateway. However after a tape is retrieved, it is associated with a gateway, even though it is also listed in the VTS, that is, archive. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_retrieve_tape_archive/](https://www.paws-r-sdk.com/docs/storagegateway_retrieve_tape_archive/) for full documentation.
#'
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape you want to retrieve
#' from the virtual tape shelf (VTS).
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the gateway you want to retrieve the
#' virtual tape to. Use the [`list_gateways`][storagegateway_list_gateways]
#' operation to return a list of gateways for your account and Amazon Web
#' Services Region.
#' 
#' You retrieve archived virtual tapes to only one gateway and the gateway
#' must be a tape gateway.
#'
#' @keywords internal
#'
#' @rdname storagegateway_retrieve_tape_archive
storagegateway_retrieve_tape_archive <- function(TapeARN, GatewayARN) {
  op <- new_operation(
    name = "RetrieveTapeArchive",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$retrieve_tape_archive_input(TapeARN = TapeARN, GatewayARN = GatewayARN)
  output <- .storagegateway$retrieve_tape_archive_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$retrieve_tape_archive <- storagegateway_retrieve_tape_archive

#' Retrieves the recovery point for the specified virtual tape
#'
#' @description
#' Retrieves the recovery point for the specified virtual tape. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_retrieve_tape_recovery_point/](https://www.paws-r-sdk.com/docs/storagegateway_retrieve_tape_recovery_point/) for full documentation.
#'
#' @param TapeARN &#91;required&#93; The Amazon Resource Name (ARN) of the virtual tape for which you want to
#' retrieve the recovery point.
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_retrieve_tape_recovery_point
storagegateway_retrieve_tape_recovery_point <- function(TapeARN, GatewayARN) {
  op <- new_operation(
    name = "RetrieveTapeRecoveryPoint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$retrieve_tape_recovery_point_input(TapeARN = TapeARN, GatewayARN = GatewayARN)
  output <- .storagegateway$retrieve_tape_recovery_point_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$retrieve_tape_recovery_point <- storagegateway_retrieve_tape_recovery_point

#' Sets the password for your VM local console
#'
#' @description
#' Sets the password for your VM local console. When you log in to the local console for the first time, you log in to the VM with the default credentials. We recommend that you set a new password. You don't need to know the default password to set a new password.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_set_local_console_password/](https://www.paws-r-sdk.com/docs/storagegateway_set_local_console_password/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param LocalConsolePassword &#91;required&#93; The password you want to set for your VM local console.
#'
#' @keywords internal
#'
#' @rdname storagegateway_set_local_console_password
storagegateway_set_local_console_password <- function(GatewayARN, LocalConsolePassword) {
  op <- new_operation(
    name = "SetLocalConsolePassword",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$set_local_console_password_input(GatewayARN = GatewayARN, LocalConsolePassword = LocalConsolePassword)
  output <- .storagegateway$set_local_console_password_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$set_local_console_password <- storagegateway_set_local_console_password

#' Sets the password for the guest user smbguest
#'
#' @description
#' Sets the password for the guest user `smbguest`. The `smbguest` user is the user when the authentication method for the file share is set to `GuestAccess`. This operation only supported for S3 File Gateways
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_set_smb_guest_password/](https://www.paws-r-sdk.com/docs/storagegateway_set_smb_guest_password/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; The Amazon Resource Name (ARN) of the S3 File Gateway the SMB file share
#' is associated with.
#' @param Password &#91;required&#93; The password that you want to set for your SMB server.
#'
#' @keywords internal
#'
#' @rdname storagegateway_set_smb_guest_password
storagegateway_set_smb_guest_password <- function(GatewayARN, Password) {
  op <- new_operation(
    name = "SetSMBGuestPassword",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$set_smb_guest_password_input(GatewayARN = GatewayARN, Password = Password)
  output <- .storagegateway$set_smb_guest_password_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$set_smb_guest_password <- storagegateway_set_smb_guest_password

#' Shuts down a Tape Gateway or Volume Gateway
#'
#' @description
#' Shuts down a Tape Gateway or Volume Gateway. To specify which gateway to shut down, use the Amazon Resource Name (ARN) of the gateway in the body of your request.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_shutdown_gateway/](https://www.paws-r-sdk.com/docs/storagegateway_shutdown_gateway/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_shutdown_gateway
storagegateway_shutdown_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "ShutdownGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$shutdown_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$shutdown_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$shutdown_gateway <- storagegateway_shutdown_gateway

#' Start a test that verifies that the specified gateway is configured for
#' High Availability monitoring in your host environment
#'
#' @description
#' Start a test that verifies that the specified gateway is configured for High Availability monitoring in your host environment. This request only initiates the test and that a successful response only indicates that the test was started. It doesn't indicate that the test passed. For the status of the test, invoke the [`describe_availability_monitor_test`][storagegateway_describe_availability_monitor_test] API.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_start_availability_monitor_test/](https://www.paws-r-sdk.com/docs/storagegateway_start_availability_monitor_test/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_start_availability_monitor_test
storagegateway_start_availability_monitor_test <- function(GatewayARN) {
  op <- new_operation(
    name = "StartAvailabilityMonitorTest",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$start_availability_monitor_test_input(GatewayARN = GatewayARN)
  output <- .storagegateway$start_availability_monitor_test_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$start_availability_monitor_test <- storagegateway_start_availability_monitor_test

#' Starts a gateway that you previously shut down (see ShutdownGateway)
#'
#' @description
#' Starts a gateway that you previously shut down (see [`shutdown_gateway`][storagegateway_shutdown_gateway]). After the gateway starts, you can then make other API calls, your applications can read from or write to the gateway's storage volumes and you will be able to take snapshot backups.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_start_gateway/](https://www.paws-r-sdk.com/docs/storagegateway_start_gateway/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_start_gateway
storagegateway_start_gateway <- function(GatewayARN) {
  op <- new_operation(
    name = "StartGateway",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$start_gateway_input(GatewayARN = GatewayARN)
  output <- .storagegateway$start_gateway_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$start_gateway <- storagegateway_start_gateway

#' Updates the automatic tape creation policy of a gateway
#'
#' @description
#' Updates the automatic tape creation policy of a gateway. Use this to update the policy with a new set of automatic tape creation rules. This is only supported for tape gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_automatic_tape_creation_policy/](https://www.paws-r-sdk.com/docs/storagegateway_update_automatic_tape_creation_policy/) for full documentation.
#'
#' @param AutomaticTapeCreationRules &#91;required&#93; An automatic tape creation policy consists of a list of automatic tape
#' creation rules. The rules determine when and how to automatically create
#' new tapes.
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_automatic_tape_creation_policy
storagegateway_update_automatic_tape_creation_policy <- function(AutomaticTapeCreationRules, GatewayARN) {
  op <- new_operation(
    name = "UpdateAutomaticTapeCreationPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_automatic_tape_creation_policy_input(AutomaticTapeCreationRules = AutomaticTapeCreationRules, GatewayARN = GatewayARN)
  output <- .storagegateway$update_automatic_tape_creation_policy_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_automatic_tape_creation_policy <- storagegateway_update_automatic_tape_creation_policy

#' Updates the bandwidth rate limits of a gateway
#'
#' @description
#' Updates the bandwidth rate limits of a gateway. You can update both the upload and download bandwidth rate limit or specify only one of the two. If you don't set a bandwidth rate limit, the existing rate limit remains. This operation is supported only for the stored volume, cached volume, and tape gateway types. To update bandwidth rate limits for S3 file gateways, use [`update_bandwidth_rate_limit_schedule`][storagegateway_update_bandwidth_rate_limit_schedule].
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_bandwidth_rate_limit/](https://www.paws-r-sdk.com/docs/storagegateway_update_bandwidth_rate_limit/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param AverageUploadRateLimitInBitsPerSec The average upload bandwidth rate limit in bits per second.
#' @param AverageDownloadRateLimitInBitsPerSec The average download bandwidth rate limit in bits per second.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_bandwidth_rate_limit
storagegateway_update_bandwidth_rate_limit <- function(GatewayARN, AverageUploadRateLimitInBitsPerSec = NULL, AverageDownloadRateLimitInBitsPerSec = NULL) {
  op <- new_operation(
    name = "UpdateBandwidthRateLimit",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_bandwidth_rate_limit_input(GatewayARN = GatewayARN, AverageUploadRateLimitInBitsPerSec = AverageUploadRateLimitInBitsPerSec, AverageDownloadRateLimitInBitsPerSec = AverageDownloadRateLimitInBitsPerSec)
  output <- .storagegateway$update_bandwidth_rate_limit_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_bandwidth_rate_limit <- storagegateway_update_bandwidth_rate_limit

#' Updates the bandwidth rate limit schedule for a specified gateway
#'
#' @description
#' Updates the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have bandwidth rate limit schedules, which means no bandwidth rate limiting is in effect. Use this to initiate or update a gateway's bandwidth rate limit schedule. This operation is supported for volume, tape, and S3 file gateways. S3 file gateways support bandwidth rate limits for upload only. FSx file gateways do not support bandwidth rate limits.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_bandwidth_rate_limit_schedule/](https://www.paws-r-sdk.com/docs/storagegateway_update_bandwidth_rate_limit_schedule/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param BandwidthRateLimitIntervals &#91;required&#93; An array containing bandwidth rate limit schedule intervals for a
#' gateway. When no bandwidth rate limit intervals have been scheduled, the
#' array is empty.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_bandwidth_rate_limit_schedule
storagegateway_update_bandwidth_rate_limit_schedule <- function(GatewayARN, BandwidthRateLimitIntervals) {
  op <- new_operation(
    name = "UpdateBandwidthRateLimitSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_bandwidth_rate_limit_schedule_input(GatewayARN = GatewayARN, BandwidthRateLimitIntervals = BandwidthRateLimitIntervals)
  output <- .storagegateway$update_bandwidth_rate_limit_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_bandwidth_rate_limit_schedule <- storagegateway_update_bandwidth_rate_limit_schedule

#' Updates the Challenge-Handshake Authentication Protocol (CHAP)
#' credentials for a specified iSCSI target
#'
#' @description
#' Updates the Challenge-Handshake Authentication Protocol (CHAP) credentials for a specified iSCSI target. By default, a gateway does not have CHAP enabled; however, for added security, you might use it. This operation is supported in the volume and tape gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_chap_credentials/](https://www.paws-r-sdk.com/docs/storagegateway_update_chap_credentials/) for full documentation.
#'
#' @param TargetARN &#91;required&#93; The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
#' [`describe_storedi_scsi_volumes`][storagegateway_describe_storedi_scsi_volumes]
#' operation to return the TargetARN for specified VolumeARN.
#' @param SecretToAuthenticateInitiator &#91;required&#93; The secret key that the initiator (for example, the Windows client) must
#' provide to participate in mutual CHAP with the target.
#' 
#' The secret key must be between 12 and 16 bytes when encoded in UTF-8.
#' @param InitiatorName &#91;required&#93; The iSCSI initiator that connects to the target.
#' @param SecretToAuthenticateTarget The secret key that the target must provide to participate in mutual
#' CHAP with the initiator (e.g. Windows client).
#' 
#' Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
#' 
#' The secret key must be between 12 and 16 bytes when encoded in UTF-8.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_chap_credentials
storagegateway_update_chap_credentials <- function(TargetARN, SecretToAuthenticateInitiator, InitiatorName, SecretToAuthenticateTarget = NULL) {
  op <- new_operation(
    name = "UpdateChapCredentials",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_chap_credentials_input(TargetARN = TargetARN, SecretToAuthenticateInitiator = SecretToAuthenticateInitiator, InitiatorName = InitiatorName, SecretToAuthenticateTarget = SecretToAuthenticateTarget)
  output <- .storagegateway$update_chap_credentials_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_chap_credentials <- storagegateway_update_chap_credentials

#' Updates a file system association
#'
#' @description
#' Updates a file system association. This operation is only supported in the FSx File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_file_system_association/](https://www.paws-r-sdk.com/docs/storagegateway_update_file_system_association/) for full documentation.
#'
#' @param FileSystemAssociationARN &#91;required&#93; The Amazon Resource Name (ARN) of the file system association that you
#' want to update.
#' @param UserName The user name of the user credential that has permission to access the
#' root share D$ of the Amazon FSx file system. The user account must
#' belong to the Amazon FSx delegated admin user group.
#' @param Password The password of the user credential.
#' @param AuditDestinationARN The Amazon Resource Name (ARN) of the storage used for the audit logs.
#' @param CacheAttributes 
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_file_system_association
storagegateway_update_file_system_association <- function(FileSystemAssociationARN, UserName = NULL, Password = NULL, AuditDestinationARN = NULL, CacheAttributes = NULL) {
  op <- new_operation(
    name = "UpdateFileSystemAssociation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_file_system_association_input(FileSystemAssociationARN = FileSystemAssociationARN, UserName = UserName, Password = Password, AuditDestinationARN = AuditDestinationARN, CacheAttributes = CacheAttributes)
  output <- .storagegateway$update_file_system_association_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_file_system_association <- storagegateway_update_file_system_association

#' Updates a gateway's metadata, which includes the gateway's name, time
#' zone, and metadata cache size
#'
#' @description
#' Updates a gateway's metadata, which includes the gateway's name, time zone, and metadata cache size. To specify which gateway to update, use the Amazon Resource Name (ARN) of the gateway in your request.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_gateway_information/](https://www.paws-r-sdk.com/docs/storagegateway_update_gateway_information/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param GatewayName 
#' @param GatewayTimezone A value that indicates the time zone of the gateway.
#' @param CloudWatchLogGroupARN The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that
#' you want to use to monitor and log events in the gateway.
#' 
#' For more information, see [What is Amazon CloudWatch
#' Logs?](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html)
#' @param GatewayCapacity Specifies the size of the gateway's metadata cache. This setting impacts
#' gateway performance and hardware recommendations. For more information,
#' see [Performance guidance for gateways with multiple file
#' shares](https://docs.aws.amazon.com/filegateway/latest/files3/Performance.html#performance-multiple-file-shares)
#' in the *Amazon S3 File Gateway User Guide*.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_gateway_information
storagegateway_update_gateway_information <- function(GatewayARN, GatewayName = NULL, GatewayTimezone = NULL, CloudWatchLogGroupARN = NULL, GatewayCapacity = NULL) {
  op <- new_operation(
    name = "UpdateGatewayInformation",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_gateway_information_input(GatewayARN = GatewayARN, GatewayName = GatewayName, GatewayTimezone = GatewayTimezone, CloudWatchLogGroupARN = CloudWatchLogGroupARN, GatewayCapacity = GatewayCapacity)
  output <- .storagegateway$update_gateway_information_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_gateway_information <- storagegateway_update_gateway_information

#' Updates the gateway virtual machine (VM) software
#'
#' @description
#' Updates the gateway virtual machine (VM) software. The request immediately triggers the software update.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_gateway_software_now/](https://www.paws-r-sdk.com/docs/storagegateway_update_gateway_software_now/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_gateway_software_now
storagegateway_update_gateway_software_now <- function(GatewayARN) {
  op <- new_operation(
    name = "UpdateGatewaySoftwareNow",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_gateway_software_now_input(GatewayARN = GatewayARN)
  output <- .storagegateway$update_gateway_software_now_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_gateway_software_now <- storagegateway_update_gateway_software_now

#' Updates a gateway's maintenance window schedule, with settings for
#' monthly or weekly cadence, specific day and time to begin maintenance,
#' and which types of updates to apply
#'
#' @description
#' Updates a gateway's maintenance window schedule, with settings for monthly or weekly cadence, specific day and time to begin maintenance, and which types of updates to apply. Time configuration uses the gateway's time zone. You can pass values for a complete maintenance schedule, or update policy, or both. Previous values will persist for whichever setting you choose not to modify. If an incomplete or invalid maintenance schedule is passed, the entire request will be rejected with an error and no changes will occur.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_maintenance_start_time/](https://www.paws-r-sdk.com/docs/storagegateway_update_maintenance_start_time/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param HourOfDay The hour component of the maintenance start time represented as *hh*,
#' where *hh* is the hour (00 to 23). The hour of the day is in the time
#' zone of the gateway.
#' @param MinuteOfHour The minute component of the maintenance start time represented as *mm*,
#' where *mm* is the minute (00 to 59). The minute of the hour is in the
#' time zone of the gateway.
#' @param DayOfWeek The day of the week component of the maintenance start time week
#' represented as an ordinal number from 0 to 6, where 0 represents Sunday
#' and 6 represents Saturday.
#' @param DayOfMonth The day of the month component of the maintenance start time represented
#' as an ordinal number from 1 to 28, where 1 represents the first day of
#' the month. It is not possible to set the maintenance schedule to start
#' on days 29 through 31.
#' @param SoftwareUpdatePreferences A set of variables indicating the software update preferences for the
#' gateway.
#' 
#' Includes `AutomaticUpdatePolicy` field with the following inputs:
#' 
#' `ALL_VERSIONS` - Enables regular gateway maintenance updates.
#' 
#' `EMERGENCY_VERSIONS_ONLY` - Disables regular gateway maintenance
#' updates.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_maintenance_start_time
storagegateway_update_maintenance_start_time <- function(GatewayARN, HourOfDay = NULL, MinuteOfHour = NULL, DayOfWeek = NULL, DayOfMonth = NULL, SoftwareUpdatePreferences = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceStartTime",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_maintenance_start_time_input(GatewayARN = GatewayARN, HourOfDay = HourOfDay, MinuteOfHour = MinuteOfHour, DayOfWeek = DayOfWeek, DayOfMonth = DayOfMonth, SoftwareUpdatePreferences = SoftwareUpdatePreferences)
  output <- .storagegateway$update_maintenance_start_time_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_maintenance_start_time <- storagegateway_update_maintenance_start_time

#' Updates a Network File System (NFS) file share
#'
#' @description
#' Updates a Network File System (NFS) file share. This operation is only supported in S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_nfs_file_share/](https://www.paws-r-sdk.com/docs/storagegateway_update_nfs_file_share/) for full documentation.
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the file share to be updated.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param NFSFileShareDefaults The default values for the file share. Optional.
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
#' 
#' Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` |
#' `S3_STANDARD_IA` | `S3_ONEZONE_IA`
#' @param ObjectACL A value that sets the access control list (ACL) permission for objects
#' in the S3 bucket that a S3 File Gateway puts objects into. The default
#' value is `private`.
#' @param ClientList The list of clients that are allowed to access the S3 File Gateway. The
#' list must contain either valid IP addresses or valid CIDR blocks.
#' @param Squash The user mapped to anonymous user.
#' 
#' Valid values are the following:
#' 
#' -   `RootSquash`: Only root is mapped to anonymous user.
#' 
#' -   `NoSquash`: No one is mapped to anonymous user.
#' 
#' -   `AllSquash`: Everyone is mapped to anonymous user.
#' @param ReadOnly A value that sets the write status of a file share. Set this value to
#' `true` to set the write status to read-only, otherwise set to `false`.
#' 
#' Valid Values: `true` | `false`
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to `true` to enable MIME type
#' guessing, otherwise set to `false`. The default value is `true`.
#' 
#' Valid Values: `true` | `false`
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to `true`, the requester pays the costs; otherwise, the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' 
#' Valid Values: `true` | `false`
#' @param FileShareName The name of the file share. Optional.
#' 
#' `FileShareName` must be set if an S3 prefix name is set in
#' `LocationARN`, or if an access point or access point alias is used.
#' @param CacheAttributes Specifies refresh cache information for the file share.
#' @param NotificationPolicy The notification policy of the file share. `SettlingTimeInSeconds`
#' controls the number of seconds to wait after the last point in time a
#' client wrote to a file before generating an `ObjectUploaded`
#' notification. Because clients can make many small writes to files, it's
#' best to set this parameter for as long as possible to avoid generating
#' multiple notifications for the same file in a small time period.
#' 
#' `SettlingTimeInSeconds` has no effect on the timing of the object
#' uploading to Amazon S3, only the timing of the notification.
#' 
#' The following example sets `NotificationPolicy` on with
#' `SettlingTimeInSeconds` set to 60.
#' 
#' `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
#' 
#' The following example sets `NotificationPolicy` off.
#' 
#' `{}`
#' @param AuditDestinationARN The Amazon Resource Name (ARN) of the storage used for audit logs.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_nfs_file_share
storagegateway_update_nfs_file_share <- function(FileShareARN, KMSEncrypted = NULL, KMSKey = NULL, NFSFileShareDefaults = NULL, DefaultStorageClass = NULL, ObjectACL = NULL, ClientList = NULL, Squash = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, FileShareName = NULL, CacheAttributes = NULL, NotificationPolicy = NULL, AuditDestinationARN = NULL) {
  op <- new_operation(
    name = "UpdateNFSFileShare",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_nfs_file_share_input(FileShareARN = FileShareARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, NFSFileShareDefaults = NFSFileShareDefaults, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ClientList = ClientList, Squash = Squash, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, FileShareName = FileShareName, CacheAttributes = CacheAttributes, NotificationPolicy = NotificationPolicy, AuditDestinationARN = AuditDestinationARN)
  output <- .storagegateway$update_nfs_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_nfs_file_share <- storagegateway_update_nfs_file_share

#' Updates a Server Message Block (SMB) file share
#'
#' @description
#' Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_smb_file_share/](https://www.paws-r-sdk.com/docs/storagegateway_update_smb_file_share/) for full documentation.
#'
#' @param FileShareARN &#91;required&#93; The Amazon Resource Name (ARN) of the SMB file share that you want to
#' update.
#' @param KMSEncrypted Set to `true` to use Amazon S3 server-side encryption with your own KMS
#' key, or `false` to use a key managed by Amazon S3. Optional.
#' 
#' Valid Values: `true` | `false`
#' @param KMSKey The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
#' used for Amazon S3 server-side encryption. Storage Gateway does not
#' support asymmetric CMKs. This value can only be set when `KMSEncrypted`
#' is `true`. Optional.
#' @param DefaultStorageClass The default storage class for objects put into an Amazon S3 bucket by
#' the S3 File Gateway. The default value is `S3_STANDARD`. Optional.
#' 
#' Valid Values: `S3_STANDARD` | `S3_INTELLIGENT_TIERING` |
#' `S3_STANDARD_IA` | `S3_ONEZONE_IA`
#' @param ObjectACL A value that sets the access control list (ACL) permission for objects
#' in the S3 bucket that a S3 File Gateway puts objects into. The default
#' value is `private`.
#' @param ReadOnly A value that sets the write status of a file share. Set this value to
#' `true` to set write status to read-only, otherwise set to `false`.
#' 
#' Valid Values: `true` | `false`
#' @param GuessMIMETypeEnabled A value that enables guessing of the MIME type for uploaded objects
#' based on file extensions. Set this value to `true` to enable MIME type
#' guessing, otherwise set to `false`. The default value is `true`.
#' 
#' Valid Values: `true` | `false`
#' @param RequesterPays A value that sets who pays the cost of the request and the cost
#' associated with data download from the S3 bucket. If this value is set
#' to `true`, the requester pays the costs; otherwise, the S3 bucket owner
#' pays. However, the S3 bucket owner always pays the cost of storing data.
#' 
#' `RequesterPays` is a configuration for the S3 bucket that backs the file
#' share, so make sure that the configuration on the file share is the same
#' as the S3 bucket configuration.
#' 
#' Valid Values: `true` | `false`
#' @param SMBACLEnabled Set this value to `true` to enable access control list (ACL) on the SMB
#' file share. Set it to `false` to map file and directory permissions to
#' the POSIX permissions.
#' 
#' For more information, see [Using Microsoft Windows ACLs to control
#' access to an SMB file
#' share](https://docs.aws.amazon.com/storagegateway/) in the *Storage
#' Gateway User Guide*.
#' 
#' Valid Values: `true` | `false`
#' @param AccessBasedEnumeration The files and folders on this share will only be visible to users with
#' read access.
#' @param AdminUserList A list of users or groups in the Active Directory that have
#' administrator rights to the file share. A group must be prefixed with
#' the @@ character. Acceptable formats include: `DOMAIN\\User1`, `user1`,
#' `@@group1`, and `@@DOMAIN\\group1`. Can only be set if Authentication is
#' set to `ActiveDirectory`.
#' @param ValidUserList A list of users or groups in the Active Directory that are allowed to
#' access the file share. A group must be prefixed with the @@ character.
#' Acceptable formats include: `DOMAIN\\User1`, `user1`, `@@group1`, and
#' `@@DOMAIN\\group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param InvalidUserList A list of users or groups in the Active Directory that are not allowed
#' to access the file share. A group must be prefixed with the @@ character.
#' Acceptable formats include: `DOMAIN\\User1`, `user1`, `@@group1`, and
#' `@@DOMAIN\\group1`. Can only be set if Authentication is set to
#' `ActiveDirectory`.
#' @param AuditDestinationARN The Amazon Resource Name (ARN) of the storage used for audit logs.
#' @param CaseSensitivity The case of an object name in an Amazon S3 bucket. For
#' `ClientSpecified`, the client determines the case sensitivity. For
#' `CaseSensitive`, the gateway determines the case sensitivity. The
#' default value is `ClientSpecified`.
#' @param FileShareName The name of the file share. Optional.
#' 
#' `FileShareName` must be set if an S3 prefix name is set in
#' `LocationARN`, or if an access point or access point alias is used.
#' @param CacheAttributes Specifies refresh cache information for the file share.
#' @param NotificationPolicy The notification policy of the file share. `SettlingTimeInSeconds`
#' controls the number of seconds to wait after the last point in time a
#' client wrote to a file before generating an `ObjectUploaded`
#' notification. Because clients can make many small writes to files, it's
#' best to set this parameter for as long as possible to avoid generating
#' multiple notifications for the same file in a small time period.
#' 
#' `SettlingTimeInSeconds` has no effect on the timing of the object
#' uploading to Amazon S3, only the timing of the notification.
#' 
#' The following example sets `NotificationPolicy` on with
#' `SettlingTimeInSeconds` set to 60.
#' 
#' `{\"Upload\": {\"SettlingTimeInSeconds\": 60}}`
#' 
#' The following example sets `NotificationPolicy` off.
#' 
#' `{}`
#' @param OplocksEnabled Specifies whether opportunistic locking is enabled for the SMB file
#' share.
#' 
#' Enabling opportunistic locking on case-sensitive shares is not
#' recommended for workloads that involve access to files with the same
#' name in different case.
#' 
#' Valid Values: `true` | `false`
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_smb_file_share
storagegateway_update_smb_file_share <- function(FileShareARN, KMSEncrypted = NULL, KMSKey = NULL, DefaultStorageClass = NULL, ObjectACL = NULL, ReadOnly = NULL, GuessMIMETypeEnabled = NULL, RequesterPays = NULL, SMBACLEnabled = NULL, AccessBasedEnumeration = NULL, AdminUserList = NULL, ValidUserList = NULL, InvalidUserList = NULL, AuditDestinationARN = NULL, CaseSensitivity = NULL, FileShareName = NULL, CacheAttributes = NULL, NotificationPolicy = NULL, OplocksEnabled = NULL) {
  op <- new_operation(
    name = "UpdateSMBFileShare",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_smb_file_share_input(FileShareARN = FileShareARN, KMSEncrypted = KMSEncrypted, KMSKey = KMSKey, DefaultStorageClass = DefaultStorageClass, ObjectACL = ObjectACL, ReadOnly = ReadOnly, GuessMIMETypeEnabled = GuessMIMETypeEnabled, RequesterPays = RequesterPays, SMBACLEnabled = SMBACLEnabled, AccessBasedEnumeration = AccessBasedEnumeration, AdminUserList = AdminUserList, ValidUserList = ValidUserList, InvalidUserList = InvalidUserList, AuditDestinationARN = AuditDestinationARN, CaseSensitivity = CaseSensitivity, FileShareName = FileShareName, CacheAttributes = CacheAttributes, NotificationPolicy = NotificationPolicy, OplocksEnabled = OplocksEnabled)
  output <- .storagegateway$update_smb_file_share_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_smb_file_share <- storagegateway_update_smb_file_share

#' Controls whether the shares on an S3 File Gateway are visible in a net
#' view or browse list
#'
#' @description
#' Controls whether the shares on an S3 File Gateway are visible in a net view or browse list. The operation is only supported for S3 File Gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_smb_file_share_visibility/](https://www.paws-r-sdk.com/docs/storagegateway_update_smb_file_share_visibility/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param FileSharesVisible &#91;required&#93; The shares on this gateway appear when listing shares.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_smb_file_share_visibility
storagegateway_update_smb_file_share_visibility <- function(GatewayARN, FileSharesVisible) {
  op <- new_operation(
    name = "UpdateSMBFileShareVisibility",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_smb_file_share_visibility_input(GatewayARN = GatewayARN, FileSharesVisible = FileSharesVisible)
  output <- .storagegateway$update_smb_file_share_visibility_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_smb_file_share_visibility <- storagegateway_update_smb_file_share_visibility

#' Updates the list of Active Directory users and groups that have special
#' permissions for SMB file shares on the gateway
#'
#' @description
#' Updates the list of Active Directory users and groups that have special permissions for SMB file shares on the gateway.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_smb_local_groups/](https://www.paws-r-sdk.com/docs/storagegateway_update_smb_local_groups/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param SMBLocalGroups &#91;required&#93; A list of Active Directory users and groups that you want to grant
#' special permissions for SMB file shares on the gateway.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_smb_local_groups
storagegateway_update_smb_local_groups <- function(GatewayARN, SMBLocalGroups) {
  op <- new_operation(
    name = "UpdateSMBLocalGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_smb_local_groups_input(GatewayARN = GatewayARN, SMBLocalGroups = SMBLocalGroups)
  output <- .storagegateway$update_smb_local_groups_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_smb_local_groups <- storagegateway_update_smb_local_groups

#' Updates the SMB security strategy level for an Amazon S3 file gateway
#'
#' @description
#' Updates the SMB security strategy level for an Amazon S3 file gateway. This action is only supported for Amazon S3 file gateways.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_smb_security_strategy/](https://www.paws-r-sdk.com/docs/storagegateway_update_smb_security_strategy/) for full documentation.
#'
#' @param GatewayARN &#91;required&#93; 
#' @param SMBSecurityStrategy &#91;required&#93; Specifies the type of security strategy.
#' 
#' `ClientSpecified`: If you choose this option, requests are established
#' based on what is negotiated by the client. This option is recommended
#' when you want to maximize compatibility across different clients in your
#' environment. Supported only for S3 File Gateway.
#' 
#' `MandatorySigning`: If you choose this option, File Gateway only allows
#' connections from SMBv2 or SMBv3 clients that have signing enabled. This
#' option works with SMB clients on Microsoft Windows Vista, Windows Server
#' 2008 or newer.
#' 
#' `MandatoryEncryption`: If you choose this option, File Gateway only
#' allows connections from SMBv3 clients that have encryption enabled. This
#' option is recommended for environments that handle sensitive data. This
#' option works with SMB clients on Microsoft Windows 8, Windows Server
#' 2012 or newer.
#' 
#' `MandatoryEncryptionNoAes128`: If you choose this option, File Gateway
#' only allows connections from SMBv3 clients that use 256-bit AES
#' encryption algorithms. 128-bit algorithms are not allowed. This option
#' is recommended for environments that handle sensitive data. It works
#' with SMB clients on Microsoft Windows 8, Windows Server 2012, or later.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_smb_security_strategy
storagegateway_update_smb_security_strategy <- function(GatewayARN, SMBSecurityStrategy) {
  op <- new_operation(
    name = "UpdateSMBSecurityStrategy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_smb_security_strategy_input(GatewayARN = GatewayARN, SMBSecurityStrategy = SMBSecurityStrategy)
  output <- .storagegateway$update_smb_security_strategy_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_smb_security_strategy <- storagegateway_update_smb_security_strategy

#' Updates a snapshot schedule configured for a gateway volume
#'
#' @description
#' Updates a snapshot schedule configured for a gateway volume. This operation is only supported in the cached volume and stored volume gateway types.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_snapshot_schedule/](https://www.paws-r-sdk.com/docs/storagegateway_update_snapshot_schedule/) for full documentation.
#'
#' @param VolumeARN &#91;required&#93; The Amazon Resource Name (ARN) of the volume. Use the
#' [`list_volumes`][storagegateway_list_volumes] operation to return a list
#' of gateway volumes.
#' @param StartAt &#91;required&#93; The hour of the day at which the snapshot schedule begins represented as
#' *hh*, where *hh* is the hour (0 to 23). The hour of the day is in the
#' time zone of the gateway.
#' @param RecurrenceInHours &#91;required&#93; Frequency of snapshots. Specify the number of hours between snapshots.
#' @param Description Optional description of the snapshot that overwrites the existing
#' description.
#' @param Tags A list of up to 50 tags that can be assigned to a snapshot. Each tag is
#' a key-value pair.
#' 
#' Valid characters for key and value are letters, spaces, and numbers
#' representable in UTF-8 format, and the following special characters: + -
#' = . _ : / @@. The maximum length of a tag's key is 128 characters, and
#' the maximum length for a tag's value is 256.
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_snapshot_schedule
storagegateway_update_snapshot_schedule <- function(VolumeARN, StartAt, RecurrenceInHours, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UpdateSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_snapshot_schedule_input(VolumeARN = VolumeARN, StartAt = StartAt, RecurrenceInHours = RecurrenceInHours, Description = Description, Tags = Tags)
  output <- .storagegateway$update_snapshot_schedule_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_snapshot_schedule <- storagegateway_update_snapshot_schedule

#' Updates the type of medium changer in a tape gateway
#'
#' @description
#' Updates the type of medium changer in a tape gateway. When you activate a tape gateway, you select a medium changer type for the tape gateway. This operation enables you to select a different type of medium changer after a tape gateway is activated. This operation is only supported in the tape gateway type.
#'
#' See [https://www.paws-r-sdk.com/docs/storagegateway_update_vtl_device_type/](https://www.paws-r-sdk.com/docs/storagegateway_update_vtl_device_type/) for full documentation.
#'
#' @param VTLDeviceARN &#91;required&#93; The Amazon Resource Name (ARN) of the medium changer you want to select.
#' @param DeviceType &#91;required&#93; The type of medium changer you want to select.
#' 
#' Valid Values: `STK-L700` | `AWS-Gateway-VTL` | `IBM-03584L32-0402`
#'
#' @keywords internal
#'
#' @rdname storagegateway_update_vtl_device_type
storagegateway_update_vtl_device_type <- function(VTLDeviceARN, DeviceType) {
  op <- new_operation(
    name = "UpdateVTLDeviceType",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .storagegateway$update_vtl_device_type_input(VTLDeviceARN = VTLDeviceARN, DeviceType = DeviceType)
  output <- .storagegateway$update_vtl_device_type_output()
  config <- get_config()
  svc <- .storagegateway$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.storagegateway$operations$update_vtl_device_type <- storagegateway_update_vtl_device_type
