% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_request_payment}
\alias{s3_get_bucket_request_payment}
\title{Returns the request payment configuration of a bucket}
\usage{
s3_get_bucket_request_payment(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the payment request
configuration}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns the request payment configuration of a bucket. To use this version of the operation, you must be the bucket owner. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html}{Requester Pays Buckets}.

See \url{https://paws-r.github.io/docs/s3/get_bucket_request_payment.html} for full documentation.
}
\keyword{internal}
