% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_update_job_priority}
\alias{s3control_update_job_priority}
\title{Updates an existing Amazon S3 Batch Operations job's priority}
\usage{
s3control_update_job_priority(AccountId, JobId, Priority)
}
\arguments{
\item{AccountId}{[required]}

\item{JobId}{[required] The ID for the job whose priority you want to update.}

\item{Priority}{[required] The priority you want to assign to this job.}
}
\description{
Updates an existing Amazon S3 Batch Operations job\'s priority. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/batch-ops-basics.html}{Amazon S3 Batch Operations}
in the Amazon Simple Storage Service Developer Guide.
}
\details{
Related actions include:
\itemize{
\item CreateJob
\item ListJobs
\item DescribeJob
\item UpdateJobStatus
}
}
\section{Request syntax}{
\preformatted{svc$update_job_priority(
  AccountId = "string",
  JobId = "string",
  Priority = 123
)
}
}

\keyword{internal}
