% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_describe_tags}
\alias{efs_describe_tags}
\title{Returns the tags associated with a file system}
\usage{
efs_describe_tags(MaxItems, Marker, FileSystemId)
}
\arguments{
\item{MaxItems}{(Optional) The maximum number of file system tags to return in the
response. Currently, this number is automatically set to 100, and other
values are ignored. The response is paginated at 100 per page if you
have more than 100 tags.}

\item{Marker}{(Optional) An opaque pagination token returned from a previous
\code{DescribeTags} operation (String). If present, it specifies to continue
the list from where the previous call left off.}

\item{FileSystemId}{[required] The ID of the file system whose tag set you want to retrieve.}
}
\description{
Returns the tags associated with a file system. The order of tags
returned in the response of one \code{DescribeTags} call and the order of
tags returned across the responses of a multiple-call iteration (when
using pagination) is unspecified.
}
\details{
This operation requires permissions for the
\code{elasticfilesystem:DescribeTags} action.
}
\section{Request syntax}{
\preformatted{svc$describe_tags(
  MaxItems = 123,
  Marker = "string",
  FileSystemId = "string"
)
}
}

\examples{
\dontrun{
# This operation describes all of a file system's tags.
svc$describe_tags(
  FileSystemId = "fs-01234567"
)
}

}
\keyword{internal}
