% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_retrieve_tape_recovery_point}
\alias{storagegateway_retrieve_tape_recovery_point}
\title{Retrieves the recovery point for the specified virtual tape}
\usage{
storagegateway_retrieve_tape_recovery_point(TapeARN, GatewayARN)
}
\arguments{
\item{TapeARN}{[required] The Amazon Resource Name (ARN) of the virtual tape for which you want to
retrieve the recovery point.}

\item{GatewayARN}{[required]}
}
\description{
Retrieves the recovery point for the specified virtual tape. This
operation is only supported in the tape gateway type.
}
\details{
A recovery point is a point in time view of a virtual tape at which all
the data on the tape is consistent. If your gateway crashes, virtual
tapes that have recovery points can be recovered to a new gateway.

The virtual tape can be retrieved to only one gateway. The retrieved
tape is read-only. The virtual tape can be retrieved to only a tape
gateway. There is no charge for retrieving recovery points.
}
\section{Request syntax}{
\preformatted{svc$retrieve_tape_recovery_point(
  TapeARN = "string",
  GatewayARN = "string"
)
}
}

\examples{
# Retrieves the recovery point for the specified virtual tape.
\dontrun{svc$retrieve_tape_recovery_point(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
  TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST0AA2AF"
)}

}
\keyword{internal}
