% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_create_mount_target}
\alias{efs_create_mount_target}
\title{Creates a mount target for a file system}
\usage{
efs_create_mount_target(FileSystemId, SubnetId, IpAddress,
  SecurityGroups)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system for which to create the mount target.}

\item{SubnetId}{[required] The ID of the subnet to add the mount target in.}

\item{IpAddress}{Valid IPv4 address within the address range of the specified subnet.}

\item{SecurityGroups}{Up to five VPC security group IDs, of the form \code{sg-xxxxxxxx}. These must
be for the same VPC as subnet specified.}
}
\description{
Creates a mount target for a file system. You can then mount the file
system on EC2 instances by using the mount target.
}
\details{
You can create one mount target in each Availability Zone in your VPC.
All EC2 instances in a VPC within a given Availability Zone share a
single mount target for a given file system. If you have multiple
subnets in an Availability Zone, you create a mount target in one of the
subnets. EC2 instances do not need to be in the same subnet as the mount
target in order to access their file system. For more information, see
\href{https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html}{Amazon EFS: How it Works}.

In the request, you also specify a file system ID for which you are
creating the mount target and the file system's lifecycle state must be
\code{available}. For more information, see DescribeFileSystems.

In the request, you also provide a subnet ID, which determines the
following:
\itemize{
\item VPC in which Amazon EFS creates the mount target
\item Availability Zone in which Amazon EFS creates the mount target
\item IP address range from which Amazon EFS selects the IP address of the
mount target (if you don't specify an IP address in the request)
}

After creating the mount target, Amazon EFS returns a response that
includes, a \code{MountTargetId} and an \code{IpAddress}. You use this IP address
when mounting the file system in an EC2 instance. You can also use the
mount target's DNS name when mounting the file system. The EC2 instance
on which you mount the file system by using the mount target can resolve
the mount target's DNS name to its IP address. For more information,
see \href{https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation}{How it Works: Implementation Overview}.

Note that you can create mount targets for a file system in only one
VPC, and there can be only one mount target per Availability Zone. That
is, if the file system already has one or more mount targets created for
it, the subnet specified in the request to add another mount target must
meet the following requirements:
\itemize{
\item Must belong to the same VPC as the subnets of the existing mount
targets
\item Must not be in the same Availability Zone as any of the subnets of
the existing mount targets
}

If the request satisfies the requirements, Amazon EFS does the
following:
\itemize{
\item Creates a new mount target in the specified subnet.
\item Also creates a new network interface in the subnet as follows:
\item If the request provides an \code{IpAddress}, Amazon EFS assigns that
IP address to the network interface. Otherwise, Amazon EFS
assigns a free address in the subnet (in the same way that the
Amazon EC2 \code{CreateNetworkInterface} call does when a request
does not specify a primary private IP address).
\item If the request provides \code{SecurityGroups}, this network interface
is associated with those security groups. Otherwise, it belongs
to the default security group for the subnet's VPC.
\item Assigns the description
\code{Mount target <i>fsmt-id</i> for file system <i>fs-id</i> }
where \code{<i>fsmt-id</i>} is the mount target ID, and
\code{<i>fs-id</i>} is the \code{FileSystemId}.
\item Sets the \code{requesterManaged} property of the network interface to
\code{true}, and the \code{requesterId} value to \code{EFS}.
}

Each Amazon EFS mount target has one corresponding requester-managed
EC2 network interface. After the network interface is created,
Amazon EFS sets the \code{NetworkInterfaceId} field in the mount
target's description to the network interface ID, and the
\code{IpAddress} field to its address. If network interface creation
fails, the entire \code{CreateMountTarget} operation fails.

The \code{CreateMountTarget} call returns only after creating the network
interface, but while the mount target state is still \code{creating}, you can
check the mount target creation status by calling the
DescribeMountTargets operation, which among other things returns the
mount target state.

We recommend that you create a mount target in each of the Availability
Zones. There are cost considerations for using a file system in an
Availability Zone through a mount target created in another Availability
Zone. For more information, see \href{http://aws.amazon.com/efs/}{Amazon EFS}. In addition, by always using a mount
target local to the instance's Availability Zone, you eliminate a
partial failure scenario. If the Availability Zone in which your mount
target is created goes down, then you can't access your file system
through that mount target.

This operation requires permissions for the following action on the file
system:
\itemize{
\item \code{elasticfilesystem:CreateMountTarget}
}

This operation also requires permissions for the following Amazon EC2
actions:
\itemize{
\item \code{ec2:DescribeSubnets}
\item \code{ec2:DescribeNetworkInterfaces}
\item \code{ec2:CreateNetworkInterface}
}
}
\section{Request syntax}{
\preformatted{svc$create_mount_target(
  FileSystemId = "string",
  SubnetId = "string",
  IpAddress = "string",
  SecurityGroups = list(
    "string"
  )
)
}
}

\examples{
# This operation creates a new mount target for an EFS file system.
\donttest{svc$create_mount_target(
  FileSystemId = "fs-01234567",
  SubnetId = "subnet-1234abcd"
)}

}
\keyword{internal}
