% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_delete_chap_credentials}
\alias{storagegateway_delete_chap_credentials}
\title{Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
for a specified iSCSI target and initiator pair}
\usage{
storagegateway_delete_chap_credentials(TargetARN, InitiatorName)
}
\arguments{
\item{TargetARN}{[required] The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
\code{\link[=storagegateway_describe_storedi_scsi_volumes]{describe_storedi_scsi_volumes}}
operation to return to retrieve the TargetARN for specified VolumeARN.}

\item{InitiatorName}{[required] The iSCSI initiator that connects to the target.}
}
\value{
A list with the following syntax:\preformatted{list(
  TargetARN = "string",
  InitiatorName = "string"
)
}
}
\description{
Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
for a specified iSCSI target and initiator pair. This operation is
supported in volume and tape gateway types.
}
\section{Request syntax}{
\preformatted{svc$delete_chap_credentials(
  TargetARN = "string",
  InitiatorName = "string"
)
}
}

\examples{
\dontrun{
# Deletes Challenge-Handshake Authentication Protocol (CHAP) credentials
# for a specified iSCSI target and initiator pair.
svc$delete_chap_credentials(
  InitiatorName = "iqn.1991-05.com.microsoft:computername.domain.example.com",
  TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12..."
)
}

}
\keyword{internal}
