% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_cancel_archival}
\alias{storagegateway_cancel_archival}
\title{Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
after the archiving process is initiated}
\usage{
storagegateway_cancel_archival(GatewayARN, TapeARN)
}
\arguments{
\item{GatewayARN}{[required]}

\item{TapeARN}{[required] The Amazon Resource Name (ARN) of the virtual tape you want to cancel
archiving for.}
}
\value{
A list with the following syntax:\preformatted{list(
  TapeARN = "string"
)
}
}
\description{
Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
after the archiving process is initiated. This operation is only
supported in the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$cancel_archival(
  GatewayARN = "string",
  TapeARN = "string"
)
}
}

\examples{
\dontrun{
# Cancels archiving of a virtual tape to the virtual tape shelf (VTS)
# after the archiving process is initiated.
svc$cancel_archival(
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
  TapeARN = "arn:aws:storagegateway:us-east-1:999999999999:tape/AMZN01A2A4"
)
}

}
\keyword{internal}
