# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon FSx
#'
#' @description
#' Amazon FSx is a fully managed service that makes it easy for storage and
#' application administrators to launch and use shared file storage.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- fsx(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- fsx()
#' # This operation creates a new backup.
#' svc$create_backup(
#'   FileSystemId = "fs-0498eed5fe91001ec",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyBackup"
#'     )
#'   )
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=fsx_associate_file_system_aliases]{associate_file_system_aliases} \tab Use this action to associate one or more Domain Name Server (DNS) aliases with an existing Amazon FSx for Windows File Server file system\cr
#'  \link[=fsx_cancel_data_repository_task]{cancel_data_repository_task} \tab Cancels an existing Amazon FSx for Lustre data repository task if that task is in either the PENDING or EXECUTING state\cr
#'  \link[=fsx_create_backup]{create_backup} \tab Creates a backup of an existing Amazon FSx file system\cr
#'  \link[=fsx_create_data_repository_task]{create_data_repository_task} \tab Creates an Amazon FSx for Lustre data repository task\cr
#'  \link[=fsx_create_file_system]{create_file_system} \tab Creates a new, empty Amazon FSx file system\cr
#'  \link[=fsx_create_file_system_from_backup]{create_file_system_from_backup} \tab Creates a new Amazon FSx file system from an existing Amazon FSx backup\cr
#'  \link[=fsx_delete_backup]{delete_backup} \tab Deletes an Amazon FSx backup, deleting its contents\cr
#'  \link[=fsx_delete_file_system]{delete_file_system} \tab Deletes a file system, deleting its contents\cr
#'  \link[=fsx_describe_backups]{describe_backups} \tab Returns the description of specific Amazon FSx backups, if a BackupIds value is provided for that backup\cr
#'  \link[=fsx_describe_data_repository_tasks]{describe_data_repository_tasks} \tab Returns the description of specific Amazon FSx for Lustre data repository tasks, if one or more TaskIds values are provided in the request, or if filters are used in the request\cr
#'  \link[=fsx_describe_file_system_aliases]{describe_file_system_aliases} \tab Returns the DNS aliases that are associated with the specified Amazon FSx for Windows File Server file system\cr
#'  \link[=fsx_describe_file_systems]{describe_file_systems} \tab Returns the description of specific Amazon FSx file systems, if a FileSystemIds value is provided for that file system\cr
#'  \link[=fsx_disassociate_file_system_aliases]{disassociate_file_system_aliases} \tab Use this action to disassociate, or remove, one or more Domain Name Service (DNS) aliases from an Amazon FSx for Windows File Server file system\cr
#'  \link[=fsx_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags for an Amazon FSx file systems and backups in the case of Amazon FSx for Windows File Server\cr
#'  \link[=fsx_tag_resource]{tag_resource} \tab Tags an Amazon FSx resource\cr
#'  \link[=fsx_untag_resource]{untag_resource} \tab This action removes a tag from an Amazon FSx resource\cr
#'  \link[=fsx_update_file_system]{update_file_system} \tab Use this operation to update the configuration of an existing Amazon FSx file system
#' }
#'
#' @rdname fsx
#' @export
fsx <- function(config = list()) {
  svc <- .fsx$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.fsx <- list()

.fsx$operations <- list()

.fsx$metadata <- list(
  service_name = "fsx",
  endpoints = list("*" = list(endpoint = "fsx.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "fsx.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "fsx.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "fsx.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "FSx",
  api_version = "2018-03-01",
  signing_name = "fsx",
  json_version = "1.1",
  target_prefix = "AWSSimbaAPIService_v20180301"
)

.fsx$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.fsx$metadata, handlers, config)
}
