% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_versioning}
\alias{s3_get_bucket_versioning}
\title{Returns the versioning state of a bucket}
\usage{
s3_get_bucket_versioning(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the versioning information.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Returns the versioning state of a bucket.

To retrieve the versioning state of a bucket, you must be the bucket
owner.

This implementation also returns the MFA Delete status of the versioning
state. If the MFA Delete status is \code{enabled}, the bucket owner must use
an authentication device to change the versioning state of the bucket.

The following operations are related to \code{GetBucketVersioning}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html}{GetObject}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html}{PutObject}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html}{DeleteObject}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_versioning(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example retrieves bucket versioning configuration.
svc$get_bucket_versioning(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
