% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_cors}
\alias{s3_get_bucket_cors}
\title{Returns the cors configuration information set for the bucket}
\usage{
s3_get_bucket_cors(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the cors configuration.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Returns the cors configuration information set for the bucket.

To use this operation, you must have permission to perform the
s3:GetBucketCORS action. By default, the bucket owner has this
permission and can grant it to others.

For more information about cors, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html}{Enabling Cross-Origin Resource Sharing}.

The following operations are related to \code{GetBucketCors}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketCors.html}{PutBucketCors}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketCors.html}{DeleteBucketCors}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_cors(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example returns cross-origin resource sharing (CORS)
# configuration set on a bucket.
svc$get_bucket_cors(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
