% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_backup_plans}
\alias{backup_list_backup_plans}
\title{Returns a list of existing backup plans for an authenticated account}
\usage{
backup_list_backup_plans(NextToken, MaxResults, IncludeDeleted)
}
\arguments{
\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{IncludeDeleted}{A Boolean value with a default value of \code{FALSE} that returns deleted
backup plans when set to \code{TRUE}.}
}
\description{
Returns a list of existing backup plans for an authenticated account.
The list is populated only if the advanced option is set for the backup
plan. The list contains information such as Amazon Resource Names
(ARNs), plan IDs, creation and deletion dates, version IDs, plan names,
and creator request IDs.
}
\section{Request syntax}{
\preformatted{svc$list_backup_plans(
  NextToken = "string",
  MaxResults = 123,
  IncludeDeleted = TRUE|FALSE
)
}
}

\keyword{internal}
