% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_analytics_configuration}
\alias{s3_put_bucket_analytics_configuration}
\title{Sets an analytics configuration for the bucket (specified by the
analytics configuration ID)}
\usage{
s3_put_bucket_analytics_configuration(Bucket, Id,
  AnalyticsConfiguration)
}
\arguments{
\item{Bucket}{[required] The name of the bucket to which an analytics configuration is stored.}

\item{Id}{[required] The identifier used to represent an analytics configuration.}

\item{AnalyticsConfiguration}{[required] The configuration and any analyses for the analytics filter.}
}
\description{
Sets an analytics configuration for the bucket (specified by the
analytics configuration ID).
}
\section{Request syntax}{
\preformatted{svc$put_bucket_analytics_configuration(
  Bucket = "string",
  Id = "string",
  AnalyticsConfiguration = list(
    Id = "string",
    Filter = list(
      Prefix = "string",
      Tag = list(
        Key = "string",
        Value = "string"
      ),
      And = list(
        Prefix = "string",
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      )
    ),
    StorageClassAnalysis = list(
      DataExport = list(
        OutputSchemaVersion = "V_1",
        Destination = list(
          S3BucketDestination = list(
            Format = "CSV",
            BucketAccountId = "string",
            Bucket = "string",
            Prefix = "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
