% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_describe_custom_key_stores}
\alias{kms_describe_custom_key_stores}
\title{Gets information about custom key stores in the account and Region}
\usage{
kms_describe_custom_key_stores(
  CustomKeyStoreId = NULL,
  CustomKeyStoreName = NULL,
  Limit = NULL,
  Marker = NULL
)
}
\arguments{
\item{CustomKeyStoreId}{Gets only information about the specified custom key store. Enter the
key store ID.

By default, this operation gets information about all custom key stores
in the account and Region. To limit the output to a particular custom
key store, provide either the \code{CustomKeyStoreId} or \code{CustomKeyStoreName}
parameter, but not both.}

\item{CustomKeyStoreName}{Gets only information about the specified custom key store. Enter the
friendly name of the custom key store.

By default, this operation gets information about all custom key stores
in the account and Region. To limit the output to a particular custom
key store, provide either the \code{CustomKeyStoreId} or \code{CustomKeyStoreName}
parameter, but not both.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, KMS does not return more than the specified
number of items, but it might return fewer.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}
}
\description{
Gets information about \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key stores} in the account and Region.

See \url{https://www.paws-r-sdk.com/docs/kms_describe_custom_key_stores/} for full documentation.
}
\keyword{internal}
