% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_promote_permission_created_from_policy}
\alias{ram_promote_permission_created_from_policy}
\title{When you attach a resource-based policy to a resource, RAM automatically
creates a resource share of featureSet=CREATED_FROM_POLICY with a
managed permission that has the same IAM permissions as the original
resource-based policy}
\usage{
ram_promote_permission_created_from_policy(
  permissionArn,
  name,
  clientToken = NULL
)
}
\arguments{
\item{permissionArn}{[required] Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the \code{CREATED_FROM_POLICY} permission that you want to promote. You
can get this \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
by calling the
\code{\link[=ram_list_resource_share_permissions]{list_resource_share_permissions}}
operation.}

\item{name}{[required] Specifies a name for the promoted customer managed permission.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}
}
\description{
When you attach a resource-based policy to a resource, RAM automatically creates a resource share of \code{featureSet}=\code{CREATED_FROM_POLICY} with a managed permission that has the same IAM permissions as the original resource-based policy. However, this type of managed permission is visible to only the resource share owner, and the associated resource share can't be modified by using RAM.

See \url{https://www.paws-r-sdk.com/docs/ram_promote_permission_created_from_policy/} for full documentation.
}
\keyword{internal}
