% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_list_tags_for_resource}
\alias{wafv2_list_tags_for_resource}
\title{Retrieves the TagInfoForResource for the specified resource}
\usage{
wafv2_list_tags_for_resource(NextMarker = NULL, Limit = NULL, ResourceARN)
}
\arguments{
\item{NextMarker}{When you request a list of objects with a \code{Limit} setting, if the number
of objects that are still available for retrieval exceeds the limit, WAF
returns a \code{NextMarker} value in the response. To retrieve the next batch
of objects, provide the marker from the prior call in your next request.}

\item{Limit}{The maximum number of objects that you want WAF to return for this
request. If more objects are available, in the response, WAF provides a
\code{NextMarker} value that you can use in a subsequent call to get the next
batch of objects.}

\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the resource.}
}
\description{
Retrieves the TagInfoForResource for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.

See \url{https://www.paws-r-sdk.com/docs/wafv2_list_tags_for_resource/} for full documentation.
}
\keyword{internal}
