% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_parameters_for_import}
\alias{kms_get_parameters_for_import}
\title{Returns the items you need to import key material into a symmetric
encryption KMS key}
\usage{
kms_get_parameters_for_import(KeyId, WrappingAlgorithm, WrappingKeySpec)
}
\arguments{
\item{KeyId}{[required] The identifier of the symmetric encryption KMS key into which you will
import key material. The \code{Origin} of the KMS key must be \code{EXTERNAL}.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{WrappingAlgorithm}{[required] The algorithm you will use to encrypt the key material before importing
it with \code{\link[=kms_import_key_material]{import_key_material}}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html}{Encrypt the Key Material}
in the \emph{Key Management Service Developer Guide}.}

\item{WrappingKeySpec}{[required] The type of wrapping key (public key) to return in the response. Only
2048-bit RSA public keys are supported.}
}
\description{
Returns the items you need to import key material into a symmetric encryption KMS key. For more information about importing key material into KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{Importing key material} in the \emph{Key Management Service Developer Guide}.

See \url{https://paws-r.github.io/docs/kms/get_parameters_for_import.html} for full documentation.
}
\keyword{internal}
