% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_remove_client_id_from_open_id_connect_provider}
\alias{iam_remove_client_id_from_open_id_connect_provider}
\title{Removes the specified client ID (also known as audience) from the list
of client IDs registered for the specified IAM OpenID Connect (OIDC)
provider resource object}
\usage{
iam_remove_client_id_from_open_id_connect_provider(
  OpenIDConnectProviderArn, ClientID)
}
\arguments{
\item{OpenIDConnectProviderArn}{[required] The Amazon Resource Name (ARN) of the IAM OIDC provider resource to
remove the client ID from. You can get a list of OIDC provider ARNs by
using the ListOpenIDConnectProviders operation.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}

\item{ClientID}{[required] The client ID (also known as audience) to remove from the IAM OIDC
provider resource. For more information about client IDs, see
CreateOpenIDConnectProvider.}
}
\description{
Removes the specified client ID (also known as audience) from the list
of client IDs registered for the specified IAM OpenID Connect (OIDC)
provider resource object.
}
\details{
This operation is idempotent; it does not fail or return an error if you
try to remove a client ID that does not exist.
}
\section{Request syntax}{
\preformatted{svc$remove_client_id_from_open_id_connect_provider(
  OpenIDConnectProviderArn = "string",
  ClientID = "string"
)
}
}

\keyword{internal}
