% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_export_certificate}
\alias{acm_export_certificate}
\title{Exports a private certificate issued by a private certificate authority
(CA) for use anywhere}
\usage{
acm_export_certificate(CertificateArn, Passphrase)
}
\arguments{
\item{CertificateArn}{[required] An Amazon Resource Name (ARN) of the issued certificate. This must be of
the form:

\code{arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012}}

\item{Passphrase}{[required] Passphrase to associate with the encrypted exported private key. If you
want to later decrypt the private key, you must have the passphrase. You
can use the following OpenSSL command to decrypt a private key:

\verb{openssl rsa -in encrypted_key.pem -out decrypted_key.pem}}
}
\description{
Exports a private certificate issued by a private certificate authority
(CA) for use anywhere. The exported file contains the certificate, the
certificate chain, and the encrypted private 2048-bit RSA key associated
with the public key that is embedded in the certificate. For security,
you must assign a passphrase for the private key when exporting it.
}
\details{
For information about exporting and formatting a certificate using the
ACM console or CLI, see \href{https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html}{Export a Private Certificate}.
}
\section{Request syntax}{
\preformatted{svc$export_certificate(
  CertificateArn = "string",
  Passphrase = raw
)
}
}

\keyword{internal}
