% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_stop_monitoring_members}
\alias{guardduty_stop_monitoring_members}
\title{Disables GuardDuty from monitoring findings of the member accounts
specified by the account IDs}
\usage{
guardduty_stop_monitoring_members(DetectorId, AccountIds)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account that you want to
stop from monitor members' findings.}

\item{AccountIds}{[required] A list of account IDs of the GuardDuty member accounts whose findings
you want the master account to stop monitoring.}
}
\description{
Disables GuardDuty from monitoring findings of the member accounts
specified by the account IDs. After running this command, a master
GuardDuty account can run StartMonitoringMembers to re-enable GuardDuty
to monitor these members' findings.
}
\section{Request syntax}{
\preformatted{svc$stop_monitoring_members(
  DetectorId = "string",
  AccountIds = list(
    "string"
  )
)
}
}

\keyword{internal}
