% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_size_constraint_set}
\alias{waf_delete_size_constraint_set}
\title{This is AWS WAF Classic documentation}
\usage{
waf_delete_size_constraint_set(SizeConstraintSetId, ChangeToken)
}
\arguments{
\item{SizeConstraintSetId}{[required] The \code{SizeConstraintSetId} of the SizeConstraintSet that you want to
delete. \code{SizeConstraintSetId} is returned by
\code{\link[=waf_create_size_constraint_set]{create_size_constraint_set}} and by
\code{\link[=waf_list_size_constraint_sets]{list_size_constraint_sets}}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=waf_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a SizeConstraintSet. You can't delete a
\code{SizeConstraintSet} if it's still used in any \code{Rules} or if it still
includes any SizeConstraint objects (any filters).

If you just want to remove a \code{SizeConstraintSet} from a \code{Rule}, use
\code{\link[=waf_update_rule]{update_rule}}.

To permanently delete a \code{SizeConstraintSet}, perform the following
steps:
\enumerate{
\item Update the \code{SizeConstraintSet} to remove filters, if any. For more
information, see
\code{\link[=waf_update_size_constraint_set]{update_size_constraint_set}}.
\item Use \code{\link[=waf_get_change_token]{get_change_token}} to get the change
token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=waf_delete_size_constraint_set]{delete_size_constraint_set}}
request.
\item Submit a
\code{\link[=waf_delete_size_constraint_set]{delete_size_constraint_set}}
request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_size_constraint_set(
  SizeConstraintSetId = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes a size constraint set  with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$delete_size_constraint_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  SizeConstraintSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)
}

}
\keyword{internal}
