% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_xss_match_set}
\alias{wafregional_delete_xss_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_delete_xss_match_set(XssMatchSetId, ChangeToken)
}
\arguments{
\item{XssMatchSetId}{[required] The \code{XssMatchSetId} of the XssMatchSet that you want to delete.
\code{XssMatchSetId} is returned by CreateXssMatchSet and by
ListXssMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes an XssMatchSet. You can't delete an \code{XssMatchSet} if
it's still used in any \code{Rules} or if it still contains any XssMatchTuple
objects.

If you just want to remove an \code{XssMatchSet} from a \code{Rule}, use
UpdateRule.

To permanently delete an \code{XssMatchSet} from AWS WAF, perform the
following steps:
\enumerate{
\item Update the \code{XssMatchSet} to remove filters, if any. For more
information, see UpdateXssMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteXssMatchSet} request.
\item Submit a \code{DeleteXssMatchSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_xss_match_set(
  XssMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes an XSS match set with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$delete_xss_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  XssMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)
}

}
\keyword{internal}
