% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_restore_from_snapshot}
\alias{directoryservice_restore_from_snapshot}
\title{Restores a directory using an existing directory snapshot}
\usage{
directoryservice_restore_from_snapshot(SnapshotId)
}
\arguments{
\item{SnapshotId}{[required] The identifier of the snapshot to restore from.}
}
\description{
Restores a directory using an existing directory snapshot.

When you restore a directory from a snapshot, any changes made to the
directory after the snapshot date are overwritten.

This action returns as soon as the restore operation is initiated. You
can monitor the progress of the restore operation by calling the
DescribeDirectories operation with the directory identifier. When the
\strong{DirectoryDescription.Stage} value changes to \code{Active}, the restore
operation is complete.
}
\section{Request syntax}{
\preformatted{svc$restore_from_snapshot(
  SnapshotId = "string"
)
}
}

\keyword{internal}
