% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_rotate_secret}
\alias{secretsmanager_rotate_secret}
\title{Configures and starts the asynchronous process of rotating this secret}
\usage{
secretsmanager_rotate_secret(SecretId, ClientRequestToken,
  RotationLambdaARN, RotationRules)
}
\arguments{
\item{SecretId}{[required] Specifies the secret that you want to rotate. You can specify either the
Amazon Resource Name (ARN) or the friendly name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}

\item{ClientRequestToken}{(Optional) Specifies a unique identifier for the new version of the
secret that helps ensure idempotency.

If you use the AWS CLI or one of the AWS SDK to call this operation,
then you can leave this parameter empty. The CLI or SDK generates a
random UUID for you and includes that in the request for this parameter.
If you don't use the SDK and instead generate a raw HTTP request to the
Secrets Manager service endpoint, then you must generate a
\code{ClientRequestToken} yourself for new versions and include that value in
the request.

You only need to specify your own value if you are implementing your own
retry logic and want to ensure that a given secret is not created twice.
We recommend that you generate a
\href{https://wikipedia.org/wiki/Universally_unique_identifier}{UUID-type}
value to ensure uniqueness within the specified secret.

Secrets Manager uses this value to prevent the accidental creation of
duplicate versions if there are failures and retries during the
function's processing. This value becomes the \code{VersionId} of the new
version.}

\item{RotationLambdaARN}{(Optional) Specifies the ARN of the Lambda function that can rotate the
secret.}

\item{RotationRules}{A structure that defines the rotation configuration for this secret.}
}
\description{
Configures and starts the asynchronous process of rotating this secret.
If you include the configuration parameters, the operation sets those
values for the secret and then immediately starts a rotation. If you do
not include the configuration parameters, the operation starts a
rotation with the values already stored in the secret. After the
rotation completes, the protected service and its clients all use the
new version of the secret.
}
\details{
This required configuration information includes the ARN of an AWS
Lambda function and the time between scheduled rotations. The Lambda
rotation function creates a new version of the secret and creates or
updates the credentials on the protected service to match. After testing
the new credentials, the function marks the new secret with the staging
label \code{AWSCURRENT} so that your clients all immediately begin to use the
new version. For more information about rotating secrets and how to
configure a Lambda function to rotate the secrets for your protected
service, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/rotating-secrets.html}{Rotating Secrets in AWS Secrets Manager}
in the \emph{AWS Secrets Manager User Guide}.

Secrets Manager schedules the next rotation when the previous one is
complete. Secrets Manager schedules the date by adding the rotation
interval (number of days) to the actual date of the last rotation. The
service chooses the hour within that 24-hour date window randomly. The
minute is also chosen somewhat randomly, but weighted towards the top of
the hour and influenced by a variety of factors that help distribute
load.

The rotation function must end with the versions of the secret in one of
two states:
\itemize{
\item The \code{AWSPENDING} and \code{AWSCURRENT} staging labels are attached to the
same version of the secret, or
\item The \code{AWSPENDING} staging label is not attached to any version of the
secret.
}

If instead the \code{AWSPENDING} staging label is present but is not attached
to the same version as \code{AWSCURRENT} then any later invocation of
\code{RotateSecret} assumes that a previous rotation request is still in
progress and returns an error.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:RotateSecret
\item lambda:InvokeFunction (on the function specified in the secret's
metadata)
}

\strong{Related operations}
\itemize{
\item To list the secrets in your account, use ListSecrets.
\item To get the details for a version of a secret, use DescribeSecret.
\item To create a new version of a secret, use CreateSecret.
\item To attach staging labels to or remove staging labels from a version
of a secret, use UpdateSecretVersionStage.
}
}
\section{Request syntax}{
\preformatted{svc$rotate_secret(
  SecretId = "string",
  ClientRequestToken = "string",
  RotationLambdaARN = "string",
  RotationRules = list(
    AutomaticallyAfterDays = 123
  )
)
}
}

\examples{
# The following example configures rotation for a secret by providing the
# ARN of a Lambda rotation function (which must already exist) and the
# number of days between rotation. The first rotation happens immediately
# upon completion of this command. The rotation function runs
# asynchronously in the background.
\donttest{svc$rotate_secret(
  RotationLambdaARN = "arn:aws:lambda:us-west-2:123456789012:function:MyTestDatabaseRotation...",
  RotationRules = list(
    AutomaticallyAfterDays = 30L
  ),
  SecretId = "MyTestDatabaseSecret"
)}

# The following example requests an immediate invocation of the secret's
# Lambda rotation function. It assumes that the specified secret already
# has rotation configured. The rotation function runs asynchronously in
# the background.
\donttest{svc$rotate_secret(
  SecretId = "MyTestDatabaseSecret"
)}

}
\keyword{internal}
