% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_issue_certificate}
\alias{acmpca_issue_certificate}
\title{Uses your private certificate authority (CA) to issue a client
certificate}
\usage{
acmpca_issue_certificate(CertificateAuthorityArn, Csr, SigningAlgorithm,
  Validity, IdempotencyToken)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must be of the form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }}

\item{Csr}{[required] The certificate signing request (CSR) for the certificate you want to
issue. You can use the following OpenSSL command to create the CSR and a
2048 bit RSA private key.

\code{openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr}

If you have a configuration file, you can use the following OpenSSL
command. The \code{usr_cert} block in the configuration file contains your
X509 version 3 extensions.

\code{openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr}}

\item{SigningAlgorithm}{[required] The name of the algorithm that will be used to sign the certificate to
be issued.}

\item{Validity}{[required] The type of the validity period.}

\item{IdempotencyToken}{Custom string that can be used to distinguish between calls to the
\strong{IssueCertificate} operation. Idempotency tokens time out after one
hour. Therefore, if you call \strong{IssueCertificate} multiple times with
the same idempotency token within 5 minutes, ACM PCA recognizes that you
are requesting only one certificate and will issue only one. If you
change the idempotency token for each call, PCA recognizes that you are
requesting multiple certificates.}
}
\description{
Uses your private certificate authority (CA) to issue a client
certificate. This operation returns the Amazon Resource Name (ARN) of
the certificate. You can retrieve the certificate by calling the
GetCertificate operation and specifying the ARN.
}
\details{
You cannot use the ACM \strong{ListCertificateAuthorities} operation to
retrieve the ARNs of the certificates that you issue by using ACM PCA.
}
\section{Request syntax}{
\preformatted{svc$issue_certificate(
  CertificateAuthorityArn = "string",
  Csr = raw,
  SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
  Validity = list(
    Value = 123,
    Type = "END_DATE"|"ABSOLUTE"|"DAYS"|"MONTHS"|"YEARS"
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
