# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include globalaccelerator_service.R
NULL

#' Associate a virtual private cloud (VPC) subnet endpoint with your custom
#' routing accelerator
#'
#' @description
#' Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_add_custom_routing_endpoints/](https://www.paws-r-sdk.com/docs/globalaccelerator_add_custom_routing_endpoints/) for full documentation.
#'
#' @param EndpointConfigurations &#91;required&#93; The list of endpoint objects to add to a custom routing accelerator.
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group for the custom
#' routing endpoint.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_add_custom_routing_endpoints
globalaccelerator_add_custom_routing_endpoints <- function(EndpointConfigurations, EndpointGroupArn) {
  op <- new_operation(
    name = "AddCustomRoutingEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$add_custom_routing_endpoints_input(EndpointConfigurations = EndpointConfigurations, EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$add_custom_routing_endpoints_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$add_custom_routing_endpoints <- globalaccelerator_add_custom_routing_endpoints

#' Add endpoints to an endpoint group
#'
#' @description
#' Add endpoints to an endpoint group. The [`add_endpoints`][globalaccelerator_add_endpoints] API operation is the recommended option for adding endpoints. The alternative options are to add endpoints when you create an endpoint group (with the [`create_endpoint_group`][globalaccelerator_create_endpoint_group] API) or when you update an endpoint group (with the [`update_endpoint_group`][globalaccelerator_update_endpoint_group] API).
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_add_endpoints/](https://www.paws-r-sdk.com/docs/globalaccelerator_add_endpoints/) for full documentation.
#'
#' @param EndpointConfigurations &#91;required&#93; The list of endpoint objects.
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_add_endpoints
globalaccelerator_add_endpoints <- function(EndpointConfigurations, EndpointGroupArn) {
  op <- new_operation(
    name = "AddEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$add_endpoints_input(EndpointConfigurations = EndpointConfigurations, EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$add_endpoints_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$add_endpoints <- globalaccelerator_add_endpoints

#' Advertises an IPv4 address range that is provisioned for use with your
#' Amazon Web Services resources through bring your own IP addresses
#' (BYOIP)
#'
#' @description
#' Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of propagation delays.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_advertise_byoip_cidr/](https://www.paws-r-sdk.com/docs/globalaccelerator_advertise_byoip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation. This must be the exact range that
#' you provisioned. You can't advertise only a portion of the provisioned
#' range.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_advertise_byoip_cidr
globalaccelerator_advertise_byoip_cidr <- function(Cidr) {
  op <- new_operation(
    name = "AdvertiseByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$advertise_byoip_cidr_input(Cidr = Cidr)
  output <- .globalaccelerator$advertise_byoip_cidr_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$advertise_byoip_cidr <- globalaccelerator_advertise_byoip_cidr

#' Specify the Amazon EC2 instance (destination) IP addresses and ports for
#' a VPC subnet endpoint that can receive traffic for a custom routing
#' accelerator
#'
#' @description
#' Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_allow_custom_routing_traffic/](https://www.paws-r-sdk.com/docs/globalaccelerator_allow_custom_routing_traffic/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group.
#' @param EndpointId &#91;required&#93; An ID for the endpoint. For custom routing accelerators, this is the
#' virtual private cloud (VPC) subnet ID.
#' @param DestinationAddresses A list of specific Amazon EC2 instance IP addresses (destination
#' addresses) in a subnet that you want to allow to receive traffic. The IP
#' addresses must be a subset of the IP addresses that you specified for
#' the endpoint group.
#' 
#' `DestinationAddresses` is required if `AllowAllTrafficToEndpoint` is
#' `FALSE` or is not specified.
#' @param DestinationPorts A list of specific Amazon EC2 instance ports (destination ports) that
#' you want to allow to receive traffic.
#' @param AllowAllTrafficToEndpoint Indicates whether all destination IP addresses and ports for a specified
#' VPC subnet endpoint can receive traffic from a custom routing
#' accelerator. The value is TRUE or FALSE.
#' 
#' When set to TRUE, *all* destinations in the custom routing VPC subnet
#' can receive traffic. Note that you cannot specify destination IP
#' addresses and ports when the value is set to TRUE.
#' 
#' When set to FALSE (or not specified), you *must* specify a list of
#' destination IP addresses that are allowed to receive traffic. A list of
#' ports is optional. If you don't specify a list of ports, the ports that
#' can accept traffic is the same as the ports configured for the endpoint
#' group.
#' 
#' The default value is FALSE.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_allow_custom_routing_traffic
globalaccelerator_allow_custom_routing_traffic <- function(EndpointGroupArn, EndpointId, DestinationAddresses = NULL, DestinationPorts = NULL, AllowAllTrafficToEndpoint = NULL) {
  op <- new_operation(
    name = "AllowCustomRoutingTraffic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$allow_custom_routing_traffic_input(EndpointGroupArn = EndpointGroupArn, EndpointId = EndpointId, DestinationAddresses = DestinationAddresses, DestinationPorts = DestinationPorts, AllowAllTrafficToEndpoint = AllowAllTrafficToEndpoint)
  output <- .globalaccelerator$allow_custom_routing_traffic_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$allow_custom_routing_traffic <- globalaccelerator_allow_custom_routing_traffic

#' Create an accelerator
#'
#' @description
#' Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_create_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_create_accelerator/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the accelerator. The name can have a maximum of 64
#' characters, must contain only alphanumeric characters, periods (.), or
#' hyphens (-), and must not begin or end with a hyphen or period.
#' @param IpAddressType The IP address type that an accelerator supports. For a standard
#' accelerator, the value can be IPV4 or DUAL_STACK.
#' @param IpAddresses Optionally, if you've added your own IP address pool to Global
#' Accelerator (BYOIP), you can choose an IPv4 address from your own pool
#' to use for the accelerator's static IPv4 address when you create an
#' accelerator.
#' 
#' After you bring an address range to Amazon Web Services, it appears in
#' your account as an address pool. When you create an accelerator, you can
#' assign one IPv4 address from your range to it. Global Accelerator
#' assigns you a second static IPv4 address from an Amazon IP address
#' range. If you bring two IPv4 address ranges to Amazon Web Services, you
#' can assign one IPv4 address from each range to your accelerator. This
#' restriction is because Global Accelerator assigns each address range to
#' a different network zone, for high availability.
#' 
#' You can specify one or two addresses, separated by a space. Do not
#' include the /32 suffix.
#' 
#' Note that you can't update IP addresses for an existing accelerator. To
#' change them, you must create a new accelerator with the new addresses.
#' 
#' For more information, see [Bring your own IP addresses
#' (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
#' in the *Global Accelerator Developer Guide*.
#' @param Enabled Indicates whether an accelerator is enabled. The value is true or false.
#' The default value is true.
#' 
#' If the value is set to true, an accelerator cannot be deleted. If set to
#' false, the accelerator can be deleted.
#' @param IdempotencyToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency—that is, the uniqueness—of an accelerator.
#' @param Tags Create tags for an accelerator.
#' 
#' For more information, see [Tagging in Global
#' Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
#' in the *Global Accelerator Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_create_accelerator
globalaccelerator_create_accelerator <- function(Name, IpAddressType = NULL, IpAddresses = NULL, Enabled = NULL, IdempotencyToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$create_accelerator_input(Name = Name, IpAddressType = IpAddressType, IpAddresses = IpAddresses, Enabled = Enabled, IdempotencyToken = IdempotencyToken, Tags = Tags)
  output <- .globalaccelerator$create_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$create_accelerator <- globalaccelerator_create_accelerator

#' Create a custom routing accelerator
#'
#' @description
#' Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_create_custom_routing_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_create_custom_routing_accelerator/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of a custom routing accelerator. The name can have a maximum of
#' 64 characters, must contain only alphanumeric characters or hyphens (-),
#' and must not begin or end with a hyphen.
#' @param IpAddressType The IP address type that an accelerator supports. For a custom routing
#' accelerator, the value must be IPV4.
#' @param IpAddresses Optionally, if you've added your own IP address pool to Global
#' Accelerator (BYOIP), you can choose an IPv4 address from your own pool
#' to use for the accelerator's static IPv4 address when you create an
#' accelerator.
#' 
#' After you bring an address range to Amazon Web Services, it appears in
#' your account as an address pool. When you create an accelerator, you can
#' assign one IPv4 address from your range to it. Global Accelerator
#' assigns you a second static IPv4 address from an Amazon IP address
#' range. If you bring two IPv4 address ranges to Amazon Web Services, you
#' can assign one IPv4 address from each range to your accelerator. This
#' restriction is because Global Accelerator assigns each address range to
#' a different network zone, for high availability.
#' 
#' You can specify one or two addresses, separated by a space. Do not
#' include the /32 suffix.
#' 
#' Note that you can't update IP addresses for an existing accelerator. To
#' change them, you must create a new accelerator with the new addresses.
#' 
#' For more information, see [Bring your own IP addresses
#' (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html)
#' in the *Global Accelerator Developer Guide*.
#' @param Enabled Indicates whether an accelerator is enabled. The value is true or false.
#' The default value is true.
#' 
#' If the value is set to true, an accelerator cannot be deleted. If set to
#' false, the accelerator can be deleted.
#' @param IdempotencyToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency—that is, the uniqueness—of the request.
#' @param Tags Create tags for an accelerator.
#' 
#' For more information, see [Tagging in Global
#' Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html)
#' in the *Global Accelerator Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_create_custom_routing_accelerator
globalaccelerator_create_custom_routing_accelerator <- function(Name, IpAddressType = NULL, IpAddresses = NULL, Enabled = NULL, IdempotencyToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateCustomRoutingAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$create_custom_routing_accelerator_input(Name = Name, IpAddressType = IpAddressType, IpAddresses = IpAddresses, Enabled = Enabled, IdempotencyToken = IdempotencyToken, Tags = Tags)
  output <- .globalaccelerator$create_custom_routing_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$create_custom_routing_accelerator <- globalaccelerator_create_custom_routing_accelerator

#' Create an endpoint group for the specified listener for a custom routing
#' accelerator
#'
#' @description
#' Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_create_custom_routing_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_create_custom_routing_endpoint_group/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener for a custom routing
#' endpoint.
#' @param EndpointGroupRegion &#91;required&#93; The Amazon Web Services Region where the endpoint group is located. A
#' listener can have only one endpoint group in a specific Region.
#' @param DestinationConfigurations &#91;required&#93; Sets the port range and protocol for all endpoints (virtual private
#' cloud subnets) in a custom routing endpoint group to accept client
#' traffic on.
#' @param IdempotencyToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency—that is, the uniqueness—of the request.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_create_custom_routing_endpoint_group
globalaccelerator_create_custom_routing_endpoint_group <- function(ListenerArn, EndpointGroupRegion, DestinationConfigurations, IdempotencyToken) {
  op <- new_operation(
    name = "CreateCustomRoutingEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$create_custom_routing_endpoint_group_input(ListenerArn = ListenerArn, EndpointGroupRegion = EndpointGroupRegion, DestinationConfigurations = DestinationConfigurations, IdempotencyToken = IdempotencyToken)
  output <- .globalaccelerator$create_custom_routing_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$create_custom_routing_endpoint_group <- globalaccelerator_create_custom_routing_endpoint_group

#' Create a listener to process inbound connections from clients to a
#' custom routing accelerator
#'
#' @description
#' Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_create_custom_routing_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_create_custom_routing_listener/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator for a custom routing
#' listener.
#' @param PortRanges &#91;required&#93; The port range to support for connections from clients to your
#' accelerator.
#' 
#' Separately, you set port ranges for endpoints. For more information, see
#' [About endpoints for custom routing
#' accelerators](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html).
#' @param IdempotencyToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency—that is, the uniqueness—of the request.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_create_custom_routing_listener
globalaccelerator_create_custom_routing_listener <- function(AcceleratorArn, PortRanges, IdempotencyToken) {
  op <- new_operation(
    name = "CreateCustomRoutingListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$create_custom_routing_listener_input(AcceleratorArn = AcceleratorArn, PortRanges = PortRanges, IdempotencyToken = IdempotencyToken)
  output <- .globalaccelerator$create_custom_routing_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$create_custom_routing_listener <- globalaccelerator_create_custom_routing_listener

#' Create an endpoint group for the specified listener
#'
#' @description
#' Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon Web Services Region. A resource must be valid and active when you add it as an endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_create_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_create_endpoint_group/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#' @param EndpointGroupRegion &#91;required&#93; The Amazon Web Services Region where the endpoint group is located. A
#' listener can have only one endpoint group in a specific Region.
#' @param EndpointConfigurations The list of endpoint objects.
#' @param TrafficDialPercentage The percentage of traffic to send to an Amazon Web Services Region.
#' Additional traffic is distributed to other endpoint groups for this
#' listener.
#' 
#' Use this action to increase (dial up) or decrease (dial down) traffic to
#' a specific Region. The percentage is applied to the traffic that would
#' otherwise have been routed to the Region based on optimal routing.
#' 
#' The default value is 100.
#' @param HealthCheckPort The port that Global Accelerator uses to check the health of endpoints
#' that are part of this endpoint group. The default port is the listener
#' port that this endpoint group is associated with. If listener port is a
#' list of ports, Global Accelerator uses the first port in the list.
#' @param HealthCheckProtocol The protocol that Global Accelerator uses to check the health of
#' endpoints that are part of this endpoint group. The default value is
#' TCP.
#' @param HealthCheckPath If the protocol is HTTP/S, then this specifies the path that is the
#' destination for health check targets. The default value is slash (/).
#' @param HealthCheckIntervalSeconds The time—10 seconds or 30 seconds—between each health check for an
#' endpoint. The default value is 30.
#' @param ThresholdCount The number of consecutive health checks required to set the state of a
#' healthy endpoint to unhealthy, or to set an unhealthy endpoint to
#' healthy. The default value is 3.
#' @param IdempotencyToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency—that is, the uniqueness—of the request.
#' @param PortOverrides Override specific listener ports used to route traffic to endpoints that
#' are part of this endpoint group. For example, you can create a port
#' override in which the listener receives user traffic on ports 80 and
#' 443, but your accelerator routes that traffic to ports 1080 and 1443,
#' respectively, on the endpoints.
#' 
#' For more information, see [Overriding listener
#' ports](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html)
#' in the *Global Accelerator Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_create_endpoint_group
globalaccelerator_create_endpoint_group <- function(ListenerArn, EndpointGroupRegion, EndpointConfigurations = NULL, TrafficDialPercentage = NULL, HealthCheckPort = NULL, HealthCheckProtocol = NULL, HealthCheckPath = NULL, HealthCheckIntervalSeconds = NULL, ThresholdCount = NULL, IdempotencyToken, PortOverrides = NULL) {
  op <- new_operation(
    name = "CreateEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$create_endpoint_group_input(ListenerArn = ListenerArn, EndpointGroupRegion = EndpointGroupRegion, EndpointConfigurations = EndpointConfigurations, TrafficDialPercentage = TrafficDialPercentage, HealthCheckPort = HealthCheckPort, HealthCheckProtocol = HealthCheckProtocol, HealthCheckPath = HealthCheckPath, HealthCheckIntervalSeconds = HealthCheckIntervalSeconds, ThresholdCount = ThresholdCount, IdempotencyToken = IdempotencyToken, PortOverrides = PortOverrides)
  output <- .globalaccelerator$create_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$create_endpoint_group <- globalaccelerator_create_endpoint_group

#' Create a listener to process inbound connections from clients to an
#' accelerator
#'
#' @description
#' Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_create_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_create_listener/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of your accelerator.
#' @param PortRanges &#91;required&#93; The list of port ranges to support for connections from clients to your
#' accelerator.
#' @param Protocol &#91;required&#93; The protocol for connections from clients to your accelerator.
#' @param ClientAffinity Client affinity lets you direct all requests from a user to the same
#' endpoint, if you have stateful applications, regardless of the port and
#' protocol of the client request. Client affinity gives you control over
#' whether to always route each client to the same specific endpoint.
#' 
#' Global Accelerator uses a consistent-flow hashing algorithm to choose
#' the optimal endpoint for a connection. If client affinity is `NONE`,
#' Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
#' address, source port, destination IP address, destination port, and
#' protocol—to select the hash value, and then chooses the best endpoint.
#' However, with this setting, if someone uses different ports to connect
#' to Global Accelerator, their connections might not be always routed to
#' the same endpoint because the hash value changes.
#' 
#' If you want a given client to always be routed to the same endpoint, set
#' client affinity to `SOURCE_IP` instead. When you use the `SOURCE_IP`
#' setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
#' source (client) IP address and destination IP address—to select the hash
#' value.
#' 
#' The default value is `NONE`.
#' @param IdempotencyToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency—that is, the uniqueness—of the request.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_create_listener
globalaccelerator_create_listener <- function(AcceleratorArn, PortRanges, Protocol, ClientAffinity = NULL, IdempotencyToken) {
  op <- new_operation(
    name = "CreateListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$create_listener_input(AcceleratorArn = AcceleratorArn, PortRanges = PortRanges, Protocol = Protocol, ClientAffinity = ClientAffinity, IdempotencyToken = IdempotencyToken)
  output <- .globalaccelerator$create_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$create_listener <- globalaccelerator_create_listener

#' Delete an accelerator
#'
#' @description
#' Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_delete_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_delete_accelerator/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of an accelerator.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_delete_accelerator
globalaccelerator_delete_accelerator <- function(AcceleratorArn) {
  op <- new_operation(
    name = "DeleteAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$delete_accelerator_input(AcceleratorArn = AcceleratorArn)
  output <- .globalaccelerator$delete_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$delete_accelerator <- globalaccelerator_delete_accelerator

#' Delete a custom routing accelerator
#'
#' @description
#' Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_delete_custom_routing_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_delete_custom_routing_accelerator/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the custom routing accelerator to
#' delete.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_delete_custom_routing_accelerator
globalaccelerator_delete_custom_routing_accelerator <- function(AcceleratorArn) {
  op <- new_operation(
    name = "DeleteCustomRoutingAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$delete_custom_routing_accelerator_input(AcceleratorArn = AcceleratorArn)
  output <- .globalaccelerator$delete_custom_routing_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$delete_custom_routing_accelerator <- globalaccelerator_delete_custom_routing_accelerator

#' Delete an endpoint group from a listener for a custom routing
#' accelerator
#'
#' @description
#' Delete an endpoint group from a listener for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_delete_custom_routing_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_delete_custom_routing_endpoint_group/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group to delete.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_delete_custom_routing_endpoint_group
globalaccelerator_delete_custom_routing_endpoint_group <- function(EndpointGroupArn) {
  op <- new_operation(
    name = "DeleteCustomRoutingEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$delete_custom_routing_endpoint_group_input(EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$delete_custom_routing_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$delete_custom_routing_endpoint_group <- globalaccelerator_delete_custom_routing_endpoint_group

#' Delete a listener for a custom routing accelerator
#'
#' @description
#' Delete a listener for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_delete_custom_routing_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_delete_custom_routing_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener to delete.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_delete_custom_routing_listener
globalaccelerator_delete_custom_routing_listener <- function(ListenerArn) {
  op <- new_operation(
    name = "DeleteCustomRoutingListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$delete_custom_routing_listener_input(ListenerArn = ListenerArn)
  output <- .globalaccelerator$delete_custom_routing_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$delete_custom_routing_listener <- globalaccelerator_delete_custom_routing_listener

#' Delete an endpoint group from a listener
#'
#' @description
#' Delete an endpoint group from a listener.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_delete_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_delete_endpoint_group/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group to delete.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_delete_endpoint_group
globalaccelerator_delete_endpoint_group <- function(EndpointGroupArn) {
  op <- new_operation(
    name = "DeleteEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$delete_endpoint_group_input(EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$delete_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$delete_endpoint_group <- globalaccelerator_delete_endpoint_group

#' Delete a listener from an accelerator
#'
#' @description
#' Delete a listener from an accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_delete_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_delete_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_delete_listener
globalaccelerator_delete_listener <- function(ListenerArn) {
  op <- new_operation(
    name = "DeleteListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$delete_listener_input(ListenerArn = ListenerArn)
  output <- .globalaccelerator$delete_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$delete_listener <- globalaccelerator_delete_listener

#' Specify the Amazon EC2 instance (destination) IP addresses and ports for
#' a VPC subnet endpoint that cannot receive traffic for a custom routing
#' accelerator
#'
#' @description
#' Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_deny_custom_routing_traffic/](https://www.paws-r-sdk.com/docs/globalaccelerator_deny_custom_routing_traffic/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group.
#' @param EndpointId &#91;required&#93; An ID for the endpoint. For custom routing accelerators, this is the
#' virtual private cloud (VPC) subnet ID.
#' @param DestinationAddresses A list of specific Amazon EC2 instance IP addresses (destination
#' addresses) in a subnet that you want to prevent from receiving traffic.
#' The IP addresses must be a subset of the IP addresses allowed for the
#' VPC subnet associated with the endpoint group.
#' @param DestinationPorts A list of specific Amazon EC2 instance ports (destination ports) in a
#' subnet endpoint that you want to prevent from receiving traffic.
#' @param DenyAllTrafficToEndpoint Indicates whether all destination IP addresses and ports for a specified
#' VPC subnet endpoint *cannot* receive traffic from a custom routing
#' accelerator. The value is TRUE or FALSE.
#' 
#' When set to TRUE, *no* destinations in the custom routing VPC subnet can
#' receive traffic. Note that you cannot specify destination IP addresses
#' and ports when the value is set to TRUE.
#' 
#' When set to FALSE (or not specified), you *must* specify a list of
#' destination IP addresses that cannot receive traffic. A list of ports is
#' optional. If you don't specify a list of ports, the ports that can
#' accept traffic is the same as the ports configured for the endpoint
#' group.
#' 
#' The default value is FALSE.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_deny_custom_routing_traffic
globalaccelerator_deny_custom_routing_traffic <- function(EndpointGroupArn, EndpointId, DestinationAddresses = NULL, DestinationPorts = NULL, DenyAllTrafficToEndpoint = NULL) {
  op <- new_operation(
    name = "DenyCustomRoutingTraffic",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$deny_custom_routing_traffic_input(EndpointGroupArn = EndpointGroupArn, EndpointId = EndpointId, DestinationAddresses = DestinationAddresses, DestinationPorts = DestinationPorts, DenyAllTrafficToEndpoint = DenyAllTrafficToEndpoint)
  output <- .globalaccelerator$deny_custom_routing_traffic_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$deny_custom_routing_traffic <- globalaccelerator_deny_custom_routing_traffic

#' Releases the specified address range that you provisioned to use with
#' your Amazon Web Services resources through bring your own IP addresses
#' (BYOIP) and deletes the corresponding address pool
#'
#' @description
#' Releases the specified address range that you provisioned to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_deprovision_byoip_cidr/](https://www.paws-r-sdk.com/docs/globalaccelerator_deprovision_byoip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation. The prefix must be the same prefix
#' that you specified when you provisioned the address range.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_deprovision_byoip_cidr
globalaccelerator_deprovision_byoip_cidr <- function(Cidr) {
  op <- new_operation(
    name = "DeprovisionByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$deprovision_byoip_cidr_input(Cidr = Cidr)
  output <- .globalaccelerator$deprovision_byoip_cidr_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$deprovision_byoip_cidr <- globalaccelerator_deprovision_byoip_cidr

#' Describe an accelerator
#'
#' @description
#' Describe an accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_accelerator/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_accelerator
globalaccelerator_describe_accelerator <- function(AcceleratorArn) {
  op <- new_operation(
    name = "DescribeAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_accelerator_input(AcceleratorArn = AcceleratorArn)
  output <- .globalaccelerator$describe_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_accelerator <- globalaccelerator_describe_accelerator

#' Describe the attributes of an accelerator
#'
#' @description
#' Describe the attributes of an accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_accelerator_attributes/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_accelerator_attributes/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator with the attributes
#' that you want to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_accelerator_attributes
globalaccelerator_describe_accelerator_attributes <- function(AcceleratorArn) {
  op <- new_operation(
    name = "DescribeAcceleratorAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_accelerator_attributes_input(AcceleratorArn = AcceleratorArn)
  output <- .globalaccelerator$describe_accelerator_attributes_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_accelerator_attributes <- globalaccelerator_describe_accelerator_attributes

#' Describe a custom routing accelerator
#'
#' @description
#' Describe a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_accelerator/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_custom_routing_accelerator
globalaccelerator_describe_custom_routing_accelerator <- function(AcceleratorArn) {
  op <- new_operation(
    name = "DescribeCustomRoutingAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_custom_routing_accelerator_input(AcceleratorArn = AcceleratorArn)
  output <- .globalaccelerator$describe_custom_routing_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_custom_routing_accelerator <- globalaccelerator_describe_custom_routing_accelerator

#' Describe the attributes of a custom routing accelerator
#'
#' @description
#' Describe the attributes of a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_accelerator_attributes/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_accelerator_attributes/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the custom routing accelerator to
#' describe the attributes for.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_descri_custom_routin_accele_attrib
globalaccelerator_describe_custom_routing_accelerator_attributes <- function(AcceleratorArn) {
  op <- new_operation(
    name = "DescribeCustomRoutingAcceleratorAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_custom_routing_accelerator_attributes_input(AcceleratorArn = AcceleratorArn)
  output <- .globalaccelerator$describe_custom_routing_accelerator_attributes_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_custom_routing_accelerator_attributes <- globalaccelerator_describe_custom_routing_accelerator_attributes

#' Describe an endpoint group for a custom routing accelerator
#'
#' @description
#' Describe an endpoint group for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_endpoint_group/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_custom_routing_endpoint_group
globalaccelerator_describe_custom_routing_endpoint_group <- function(EndpointGroupArn) {
  op <- new_operation(
    name = "DescribeCustomRoutingEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_custom_routing_endpoint_group_input(EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$describe_custom_routing_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_custom_routing_endpoint_group <- globalaccelerator_describe_custom_routing_endpoint_group

#' The description of a listener for a custom routing accelerator
#'
#' @description
#' The description of a listener for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_custom_routing_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_custom_routing_listener
globalaccelerator_describe_custom_routing_listener <- function(ListenerArn) {
  op <- new_operation(
    name = "DescribeCustomRoutingListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_custom_routing_listener_input(ListenerArn = ListenerArn)
  output <- .globalaccelerator$describe_custom_routing_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_custom_routing_listener <- globalaccelerator_describe_custom_routing_listener

#' Describe an endpoint group
#'
#' @description
#' Describe an endpoint group.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_endpoint_group/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_endpoint_group
globalaccelerator_describe_endpoint_group <- function(EndpointGroupArn) {
  op <- new_operation(
    name = "DescribeEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_endpoint_group_input(EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$describe_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_endpoint_group <- globalaccelerator_describe_endpoint_group

#' Describe a listener
#'
#' @description
#' Describe a listener.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_describe_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_describe_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener to describe.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_describe_listener
globalaccelerator_describe_listener <- function(ListenerArn) {
  op <- new_operation(
    name = "DescribeListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$describe_listener_input(ListenerArn = ListenerArn)
  output <- .globalaccelerator$describe_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$describe_listener <- globalaccelerator_describe_listener

#' List the accelerators for an Amazon Web Services account
#'
#' @description
#' List the accelerators for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_accelerators/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_accelerators/) for full documentation.
#'
#' @param MaxResults The number of Global Accelerator objects that you want to return with
#' this call. The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_accelerators
globalaccelerator_list_accelerators <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAccelerators",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Accelerators")
  )
  input <- .globalaccelerator$list_accelerators_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_accelerators_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_accelerators <- globalaccelerator_list_accelerators

#' Lists the IP address ranges that were specified in calls to
#' ProvisionByoipCidr, including the current state and a history of state
#' changes
#'
#' @description
#' Lists the IP address ranges that were specified in calls to [`provision_byoip_cidr`][globalaccelerator_provision_byoip_cidr], including the current state and a history of state changes.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_byoip_cidrs/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_byoip_cidrs/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_byoip_cidrs
globalaccelerator_list_byoip_cidrs <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListByoipCidrs",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ByoipCidrs")
  )
  input <- .globalaccelerator$list_byoip_cidrs_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_byoip_cidrs_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_byoip_cidrs <- globalaccelerator_list_byoip_cidrs

#' List the custom routing accelerators for an Amazon Web Services account
#'
#' @description
#' List the custom routing accelerators for an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_accelerators/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_accelerators/) for full documentation.
#'
#' @param MaxResults The number of custom routing Global Accelerator objects that you want to
#' return with this call. The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_custom_routing_accelerators
globalaccelerator_list_custom_routing_accelerators <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomRoutingAccelerators",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Accelerators")
  )
  input <- .globalaccelerator$list_custom_routing_accelerators_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_custom_routing_accelerators_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_custom_routing_accelerators <- globalaccelerator_list_custom_routing_accelerators

#' List the endpoint groups that are associated with a listener for a
#' custom routing accelerator
#'
#' @description
#' List the endpoint groups that are associated with a listener for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_endpoint_groups/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_endpoint_groups/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener to list endpoint groups
#' for.
#' @param MaxResults The number of endpoint group objects that you want to return with this
#' call. The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_custom_routing_endpoint_groups
globalaccelerator_list_custom_routing_endpoint_groups <- function(ListenerArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomRoutingEndpointGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .globalaccelerator$list_custom_routing_endpoint_groups_input(ListenerArn = ListenerArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_custom_routing_endpoint_groups_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_custom_routing_endpoint_groups <- globalaccelerator_list_custom_routing_endpoint_groups

#' List the listeners for a custom routing accelerator
#'
#' @description
#' List the listeners for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_listeners/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_listeners/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to list listeners for.
#' @param MaxResults The number of listener objects that you want to return with this call.
#' The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_custom_routing_listeners
globalaccelerator_list_custom_routing_listeners <- function(AcceleratorArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomRoutingListeners",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Listeners")
  )
  input <- .globalaccelerator$list_custom_routing_listeners_input(AcceleratorArn = AcceleratorArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_custom_routing_listeners_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_custom_routing_listeners <- globalaccelerator_list_custom_routing_listeners

#' Provides a complete mapping from the public accelerator IP address and
#' port to destination EC2 instance IP addresses and ports in the virtual
#' public cloud (VPC) subnet endpoint for a custom routing accelerator
#'
#' @description
#' Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_port_mappings/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_port_mappings/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to list the custom
#' routing port mappings for.
#' @param EndpointGroupArn The Amazon Resource Name (ARN) of the endpoint group to list the custom
#' routing port mappings for.
#' @param MaxResults The number of destination port mappings that you want to return with
#' this call. The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_custom_routing_port_mappings
globalaccelerator_list_custom_routing_port_mappings <- function(AcceleratorArn, EndpointGroupArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomRoutingPortMappings",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "PortMappings")
  )
  input <- .globalaccelerator$list_custom_routing_port_mappings_input(AcceleratorArn = AcceleratorArn, EndpointGroupArn = EndpointGroupArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_custom_routing_port_mappings_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_custom_routing_port_mappings <- globalaccelerator_list_custom_routing_port_mappings

#' List the port mappings for a specific EC2 instance (destination) in a
#' VPC subnet endpoint
#'
#' @description
#' List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a specific destination instance.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_port_mappings_by_destination/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_custom_routing_port_mappings_by_destination/) for full documentation.
#'
#' @param EndpointId &#91;required&#93; The ID for the virtual private cloud (VPC) subnet.
#' @param DestinationAddress &#91;required&#93; The endpoint IP address in a virtual private cloud (VPC) subnet for
#' which you want to receive back port mappings.
#' @param MaxResults The number of destination port mappings that you want to return with
#' this call. The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_custo_routi_port_mappi_by_desti
globalaccelerator_list_custom_routing_port_mappings_by_destination <- function(EndpointId, DestinationAddress, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCustomRoutingPortMappingsByDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DestinationPortMappings")
  )
  input <- .globalaccelerator$list_custom_routing_port_mappings_by_destination_input(EndpointId = EndpointId, DestinationAddress = DestinationAddress, MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_custom_routing_port_mappings_by_destination_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_custom_routing_port_mappings_by_destination <- globalaccelerator_list_custom_routing_port_mappings_by_destination

#' List the endpoint groups that are associated with a listener
#'
#' @description
#' List the endpoint groups that are associated with a listener.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_endpoint_groups/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_endpoint_groups/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener.
#' @param MaxResults The number of endpoint group objects that you want to return with this
#' call. The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_endpoint_groups
globalaccelerator_list_endpoint_groups <- function(ListenerArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListEndpointGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "EndpointGroups")
  )
  input <- .globalaccelerator$list_endpoint_groups_input(ListenerArn = ListenerArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_endpoint_groups_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_endpoint_groups <- globalaccelerator_list_endpoint_groups

#' List the listeners for an accelerator
#'
#' @description
#' List the listeners for an accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_listeners/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_listeners/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator for which you want to
#' list listener objects.
#' @param MaxResults The number of listener objects that you want to return with this call.
#' The default value is 10.
#' @param NextToken The token for the next set of results. You receive this token from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_listeners
globalaccelerator_list_listeners <- function(AcceleratorArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListListeners",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Listeners")
  )
  input <- .globalaccelerator$list_listeners_input(AcceleratorArn = AcceleratorArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .globalaccelerator$list_listeners_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_listeners <- globalaccelerator_list_listeners

#' List all tags for an accelerator
#'
#' @description
#' List all tags for an accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/globalaccelerator_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to list tags for. An
#' ARN uniquely identifies an accelerator.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_list_tags_for_resource
globalaccelerator_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .globalaccelerator$list_tags_for_resource_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$list_tags_for_resource <- globalaccelerator_list_tags_for_resource

#' Provisions an IP address range to use with your Amazon Web Services
#' resources through bring your own IP addresses (BYOIP) and creates a
#' corresponding address pool
#'
#' @description
#' Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using [AdvertiseByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/).
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_provision_byoip_cidr/](https://www.paws-r-sdk.com/docs/globalaccelerator_provision_byoip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; The public IPv4 address range, in CIDR notation. The most specific IP
#' prefix that you can specify is /24. The address range cannot overlap
#' with another address range that you've brought to this or another
#' Region.
#' @param CidrAuthorizationContext &#91;required&#93; A signed document that proves that you are authorized to bring the
#' specified IP address range to Amazon using BYOIP.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_provision_byoip_cidr
globalaccelerator_provision_byoip_cidr <- function(Cidr, CidrAuthorizationContext) {
  op <- new_operation(
    name = "ProvisionByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$provision_byoip_cidr_input(Cidr = Cidr, CidrAuthorizationContext = CidrAuthorizationContext)
  output <- .globalaccelerator$provision_byoip_cidr_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$provision_byoip_cidr <- globalaccelerator_provision_byoip_cidr

#' Remove endpoints from a custom routing accelerator
#'
#' @description
#' Remove endpoints from a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_remove_custom_routing_endpoints/](https://www.paws-r-sdk.com/docs/globalaccelerator_remove_custom_routing_endpoints/) for full documentation.
#'
#' @param EndpointIds &#91;required&#93; The IDs for the endpoints. For custom routing accelerators, endpoint IDs
#' are the virtual private cloud (VPC) subnet IDs.
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group to remove endpoints
#' from.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_remove_custom_routing_endpoints
globalaccelerator_remove_custom_routing_endpoints <- function(EndpointIds, EndpointGroupArn) {
  op <- new_operation(
    name = "RemoveCustomRoutingEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$remove_custom_routing_endpoints_input(EndpointIds = EndpointIds, EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$remove_custom_routing_endpoints_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$remove_custom_routing_endpoints <- globalaccelerator_remove_custom_routing_endpoints

#' Remove endpoints from an endpoint group
#'
#' @description
#' Remove endpoints from an endpoint group.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_remove_endpoints/](https://www.paws-r-sdk.com/docs/globalaccelerator_remove_endpoints/) for full documentation.
#'
#' @param EndpointIdentifiers &#91;required&#93; The identifiers of the endpoints that you want to remove.
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_remove_endpoints
globalaccelerator_remove_endpoints <- function(EndpointIdentifiers, EndpointGroupArn) {
  op <- new_operation(
    name = "RemoveEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$remove_endpoints_input(EndpointIdentifiers = EndpointIdentifiers, EndpointGroupArn = EndpointGroupArn)
  output <- .globalaccelerator$remove_endpoints_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$remove_endpoints <- globalaccelerator_remove_endpoints

#' Add tags to an accelerator resource
#'
#' @description
#' Add tags to an accelerator resource.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_tag_resource/](https://www.paws-r-sdk.com/docs/globalaccelerator_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Global Accelerator resource to add
#' tags to. An ARN uniquely identifies a resource.
#' @param Tags &#91;required&#93; The tags to add to a resource. A tag consists of a key and a value that
#' you define.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_tag_resource
globalaccelerator_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .globalaccelerator$tag_resource_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$tag_resource <- globalaccelerator_tag_resource

#' Remove tags from a Global Accelerator resource
#'
#' @description
#' Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_untag_resource/](https://www.paws-r-sdk.com/docs/globalaccelerator_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Global Accelerator resource to
#' remove tags from. An ARN uniquely identifies a resource.
#' @param TagKeys &#91;required&#93; The tag key pairs that you want to remove from the specified resources.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_untag_resource
globalaccelerator_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .globalaccelerator$untag_resource_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$untag_resource <- globalaccelerator_untag_resource

#' Update an accelerator to make changes, such as the following:
#'
#' @description
#' Update an accelerator to make changes, such as the following:
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_accelerator/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to update.
#' @param Name The name of the accelerator. The name can have a maximum of 64
#' characters, must contain only alphanumeric characters, periods (.), or
#' hyphens (-), and must not begin or end with a hyphen or period.
#' @param IpAddressType The IP address type that an accelerator supports. For a standard
#' accelerator, the value can be IPV4 or DUAL_STACK.
#' @param Enabled Indicates whether an accelerator is enabled. The value is true or false.
#' The default value is true.
#' 
#' If the value is set to true, the accelerator cannot be deleted. If set
#' to false, the accelerator can be deleted.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_accelerator
globalaccelerator_update_accelerator <- function(AcceleratorArn, Name = NULL, IpAddressType = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "UpdateAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_accelerator_input(AcceleratorArn = AcceleratorArn, Name = Name, IpAddressType = IpAddressType, Enabled = Enabled)
  output <- .globalaccelerator$update_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_accelerator <- globalaccelerator_update_accelerator

#' Update the attributes for an accelerator
#'
#' @description
#' Update the attributes for an accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_accelerator_attributes/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_accelerator_attributes/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator that you want to
#' update.
#' @param FlowLogsEnabled Update whether flow logs are enabled. The default value is false. If the
#' value is true, `FlowLogsS3Bucket` and `FlowLogsS3Prefix` must be
#' specified.
#' 
#' For more information, see [Flow
#' Logs](https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
#' in the *Global Accelerator Developer Guide*.
#' @param FlowLogsS3Bucket The name of the Amazon S3 bucket for the flow logs. Attribute is
#' required if `FlowLogsEnabled` is `true`. The bucket must exist and have
#' a bucket policy that grants Global Accelerator permission to write to
#' the bucket.
#' @param FlowLogsS3Prefix Update the prefix for the location in the Amazon S3 bucket for the flow
#' logs. Attribute is required if `FlowLogsEnabled` is `true`.
#' 
#' If you specify slash (/) for the S3 bucket prefix, the log file bucket
#' folder structure will include a double slash (//), like the following:
#' 
#' s3-bucket_name//AWSLogs/aws_account_id
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_accelerator_attributes
globalaccelerator_update_accelerator_attributes <- function(AcceleratorArn, FlowLogsEnabled = NULL, FlowLogsS3Bucket = NULL, FlowLogsS3Prefix = NULL) {
  op <- new_operation(
    name = "UpdateAcceleratorAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_accelerator_attributes_input(AcceleratorArn = AcceleratorArn, FlowLogsEnabled = FlowLogsEnabled, FlowLogsS3Bucket = FlowLogsS3Bucket, FlowLogsS3Prefix = FlowLogsS3Prefix)
  output <- .globalaccelerator$update_accelerator_attributes_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_accelerator_attributes <- globalaccelerator_update_accelerator_attributes

#' Update a custom routing accelerator
#'
#' @description
#' Update a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_accelerator/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_accelerator/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the accelerator to update.
#' @param Name The name of the accelerator. The name can have a maximum of 64
#' characters, must contain only alphanumeric characters, periods (.), or
#' hyphens (-), and must not begin or end with a hyphen or period.
#' @param IpAddressType The IP address type that an accelerator supports. For a custom routing
#' accelerator, the value must be IPV4.
#' @param Enabled Indicates whether an accelerator is enabled. The value is true or false.
#' The default value is true.
#' 
#' If the value is set to true, the accelerator cannot be deleted. If set
#' to false, the accelerator can be deleted.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_custom_routing_accelerator
globalaccelerator_update_custom_routing_accelerator <- function(AcceleratorArn, Name = NULL, IpAddressType = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "UpdateCustomRoutingAccelerator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_custom_routing_accelerator_input(AcceleratorArn = AcceleratorArn, Name = Name, IpAddressType = IpAddressType, Enabled = Enabled)
  output <- .globalaccelerator$update_custom_routing_accelerator_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_custom_routing_accelerator <- globalaccelerator_update_custom_routing_accelerator

#' Update the attributes for a custom routing accelerator
#'
#' @description
#' Update the attributes for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_accelerator_attributes/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_accelerator_attributes/) for full documentation.
#'
#' @param AcceleratorArn &#91;required&#93; The Amazon Resource Name (ARN) of the custom routing accelerator to
#' update attributes for.
#' @param FlowLogsEnabled Update whether flow logs are enabled. The default value is false. If the
#' value is true, `FlowLogsS3Bucket` and `FlowLogsS3Prefix` must be
#' specified.
#' 
#' For more information, see [Flow
#' logs](https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html)
#' in the *Global Accelerator Developer Guide*.
#' @param FlowLogsS3Bucket The name of the Amazon S3 bucket for the flow logs. Attribute is
#' required if `FlowLogsEnabled` is `true`. The bucket must exist and have
#' a bucket policy that grants Global Accelerator permission to write to
#' the bucket.
#' @param FlowLogsS3Prefix Update the prefix for the location in the Amazon S3 bucket for the flow
#' logs. Attribute is required if `FlowLogsEnabled` is `true`.
#' 
#' If you don’t specify a prefix, the flow logs are stored in the root of
#' the bucket. If you specify slash (/) for the S3 bucket prefix, the log
#' file bucket folder structure will include a double slash (//), like the
#' following:
#' 
#' DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_custom_routin_accele_attrib
globalaccelerator_update_custom_routing_accelerator_attributes <- function(AcceleratorArn, FlowLogsEnabled = NULL, FlowLogsS3Bucket = NULL, FlowLogsS3Prefix = NULL) {
  op <- new_operation(
    name = "UpdateCustomRoutingAcceleratorAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_custom_routing_accelerator_attributes_input(AcceleratorArn = AcceleratorArn, FlowLogsEnabled = FlowLogsEnabled, FlowLogsS3Bucket = FlowLogsS3Bucket, FlowLogsS3Prefix = FlowLogsS3Prefix)
  output <- .globalaccelerator$update_custom_routing_accelerator_attributes_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_custom_routing_accelerator_attributes <- globalaccelerator_update_custom_routing_accelerator_attributes

#' Update a listener for a custom routing accelerator
#'
#' @description
#' Update a listener for a custom routing accelerator.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener to update.
#' @param PortRanges &#91;required&#93; The updated port range to support for connections from clients to your
#' accelerator. If you remove ports that are currently being used by a
#' subnet endpoint, the call fails.
#' 
#' Separately, you set port ranges for endpoints. For more information, see
#' [About endpoints for custom routing
#' accelerators](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html).
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_custom_routing_listener
globalaccelerator_update_custom_routing_listener <- function(ListenerArn, PortRanges) {
  op <- new_operation(
    name = "UpdateCustomRoutingListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_custom_routing_listener_input(ListenerArn = ListenerArn, PortRanges = PortRanges)
  output <- .globalaccelerator$update_custom_routing_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_custom_routing_listener <- globalaccelerator_update_custom_routing_listener

#' Update an endpoint group
#'
#' @description
#' Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_endpoint_group/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_endpoint_group/) for full documentation.
#'
#' @param EndpointGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the endpoint group.
#' @param EndpointConfigurations The list of endpoint objects. A resource must be valid and active when
#' you add it as an endpoint.
#' @param TrafficDialPercentage The percentage of traffic to send to an Amazon Web Services Region.
#' Additional traffic is distributed to other endpoint groups for this
#' listener.
#' 
#' Use this action to increase (dial up) or decrease (dial down) traffic to
#' a specific Region. The percentage is applied to the traffic that would
#' otherwise have been routed to the Region based on optimal routing.
#' 
#' The default value is 100.
#' @param HealthCheckPort The port that Global Accelerator uses to check the health of endpoints
#' that are part of this endpoint group. The default port is the listener
#' port that this endpoint group is associated with. If the listener port
#' is a list of ports, Global Accelerator uses the first port in the list.
#' @param HealthCheckProtocol The protocol that Global Accelerator uses to check the health of
#' endpoints that are part of this endpoint group. The default value is
#' TCP.
#' @param HealthCheckPath If the protocol is HTTP/S, then this specifies the path that is the
#' destination for health check targets. The default value is slash (/).
#' @param HealthCheckIntervalSeconds The time—10 seconds or 30 seconds—between each health check for an
#' endpoint. The default value is 30.
#' @param ThresholdCount The number of consecutive health checks required to set the state of a
#' healthy endpoint to unhealthy, or to set an unhealthy endpoint to
#' healthy. The default value is 3.
#' @param PortOverrides Override specific listener ports used to route traffic to endpoints that
#' are part of this endpoint group. For example, you can create a port
#' override in which the listener receives user traffic on ports 80 and
#' 443, but your accelerator routes that traffic to ports 1080 and 1443,
#' respectively, on the endpoints.
#' 
#' For more information, see [Overriding listener
#' ports](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html)
#' in the *Global Accelerator Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_endpoint_group
globalaccelerator_update_endpoint_group <- function(EndpointGroupArn, EndpointConfigurations = NULL, TrafficDialPercentage = NULL, HealthCheckPort = NULL, HealthCheckProtocol = NULL, HealthCheckPath = NULL, HealthCheckIntervalSeconds = NULL, ThresholdCount = NULL, PortOverrides = NULL) {
  op <- new_operation(
    name = "UpdateEndpointGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_endpoint_group_input(EndpointGroupArn = EndpointGroupArn, EndpointConfigurations = EndpointConfigurations, TrafficDialPercentage = TrafficDialPercentage, HealthCheckPort = HealthCheckPort, HealthCheckProtocol = HealthCheckProtocol, HealthCheckPath = HealthCheckPath, HealthCheckIntervalSeconds = HealthCheckIntervalSeconds, ThresholdCount = ThresholdCount, PortOverrides = PortOverrides)
  output <- .globalaccelerator$update_endpoint_group_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_endpoint_group <- globalaccelerator_update_endpoint_group

#' Update a listener
#'
#' @description
#' Update a listener.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_update_listener/](https://www.paws-r-sdk.com/docs/globalaccelerator_update_listener/) for full documentation.
#'
#' @param ListenerArn &#91;required&#93; The Amazon Resource Name (ARN) of the listener to update.
#' @param PortRanges The updated list of port ranges for the connections from clients to the
#' accelerator.
#' @param Protocol The updated protocol for the connections from clients to the
#' accelerator.
#' @param ClientAffinity Client affinity lets you direct all requests from a user to the same
#' endpoint, if you have stateful applications, regardless of the port and
#' protocol of the client request. Client affinity gives you control over
#' whether to always route each client to the same specific endpoint.
#' 
#' Global Accelerator uses a consistent-flow hashing algorithm to choose
#' the optimal endpoint for a connection. If client affinity is `NONE`,
#' Global Accelerator uses the "five-tuple" (5-tuple) properties—source IP
#' address, source port, destination IP address, destination port, and
#' protocol—to select the hash value, and then chooses the best endpoint.
#' However, with this setting, if someone uses different ports to connect
#' to Global Accelerator, their connections might not be always routed to
#' the same endpoint because the hash value changes.
#' 
#' If you want a given client to always be routed to the same endpoint, set
#' client affinity to `SOURCE_IP` instead. When you use the `SOURCE_IP`
#' setting, Global Accelerator uses the "two-tuple" (2-tuple) properties—
#' source (client) IP address and destination IP address—to select the hash
#' value.
#' 
#' The default value is `NONE`.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_update_listener
globalaccelerator_update_listener <- function(ListenerArn, PortRanges = NULL, Protocol = NULL, ClientAffinity = NULL) {
  op <- new_operation(
    name = "UpdateListener",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$update_listener_input(ListenerArn = ListenerArn, PortRanges = PortRanges, Protocol = Protocol, ClientAffinity = ClientAffinity)
  output <- .globalaccelerator$update_listener_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$update_listener <- globalaccelerator_update_listener

#' Stops advertising an address range that is provisioned as an address
#' pool
#'
#' @description
#' Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.
#'
#' See [https://www.paws-r-sdk.com/docs/globalaccelerator_withdraw_byoip_cidr/](https://www.paws-r-sdk.com/docs/globalaccelerator_withdraw_byoip_cidr/) for full documentation.
#'
#' @param Cidr &#91;required&#93; The address range, in CIDR notation.
#'
#' @keywords internal
#'
#' @rdname globalaccelerator_withdraw_byoip_cidr
globalaccelerator_withdraw_byoip_cidr <- function(Cidr) {
  op <- new_operation(
    name = "WithdrawByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .globalaccelerator$withdraw_byoip_cidr_input(Cidr = Cidr)
  output <- .globalaccelerator$withdraw_byoip_cidr_output()
  config <- get_config()
  svc <- .globalaccelerator$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.globalaccelerator$operations$withdraw_byoip_cidr <- globalaccelerator_withdraw_byoip_cidr
