% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_update_gateway_route}
\alias{appmesh_update_gateway_route}
\title{Updates an existing gateway route that is associated to a specified
virtual gateway in a service mesh}
\usage{
appmesh_update_gateway_route(
  clientToken = NULL,
  gatewayRouteName,
  meshName,
  meshOwner = NULL,
  spec,
  virtualGatewayName
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{gatewayRouteName}{[required] The name of the gateway route to update.}

\item{meshName}{[required] The name of the service mesh that the gateway route resides in.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then it's the ID of the account that shared
the mesh with your account. For more information about mesh sharing, see
\href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The new gateway route specification to apply. This overwrites the
existing data.}

\item{virtualGatewayName}{[required] The name of the virtual gateway that the gateway route is associated
with.}
}
\description{
Updates an existing gateway route that is associated to a specified virtual gateway in a service mesh.

See \url{https://www.paws-r-sdk.com/docs/appmesh_update_gateway_route/} for full documentation.
}
\keyword{internal}
