% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_vpc_association_authorization}
\alias{route53_create_vpc_association_authorization}
\title{Authorizes the Amazon Web Services account that created a specified VPC
to submit an AssociateVPCWithHostedZone request to associate the VPC
with a specified hosted zone that was created by a different account}
\usage{
route53_create_vpc_association_authorization(HostedZoneId, VPC)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the private hosted zone that you want to authorize associating
a VPC with.}

\item{VPC}{[required] A complex type that contains the VPC ID and region for the VPC that you
want to authorize associating with your hosted zone.}
}
\description{
Authorizes the Amazon Web Services account that created a specified VPC to submit an \code{\link[=route53_associate_vpc_with_hosted_zone]{associate_vpc_with_hosted_zone}} request to associate the VPC with a specified hosted zone that was created by a different account. To submit a \code{\link[=route53_create_vpc_association_authorization]{create_vpc_association_authorization}} request, you must use the account that created the hosted zone. After you authorize the association, use the account that created the VPC to submit an \code{\link[=route53_associate_vpc_with_hosted_zone]{associate_vpc_with_hosted_zone}} request.

See \url{https://paws-r.github.io/docs/route53/create_vpc_association_authorization.html} for full documentation.
}
\keyword{internal}
