% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_create_rule_group}
\alias{networkfirewall_create_rule_group}
\title{Creates the specified stateless or stateful rule group, which includes
the rules for network traffic inspection, a capacity setting, and tags}
\usage{
networkfirewall_create_rule_group(
  RuleGroupName,
  RuleGroup = NULL,
  Rules = NULL,
  Type,
  Description = NULL,
  Capacity,
  Tags = NULL,
  DryRun = NULL,
  EncryptionConfiguration = NULL,
  SourceMetadata = NULL
)
}
\arguments{
\item{RuleGroupName}{[required] The descriptive name of the rule group. You can't change the name of a
rule group after you create it.}

\item{RuleGroup}{An object that defines the rule group rules.

You must provide either this rule group setting or a \code{Rules} setting,
but not both.}

\item{Rules}{A string containing stateful rule group rules specifications in Suricata
flat format, with one rule per line. Use this to import your existing
Suricata compatible rule groups.

You must provide either this rules setting or a populated \code{RuleGroup}
setting, but not both.

You can provide your rule group specification in Suricata flat format
through this setting when you create or update your rule group. The call
response returns a RuleGroup object that Network Firewall has populated
from your string.}

\item{Type}{[required] Indicates whether the rule group is stateless or stateful. If the rule
group is stateless, it contains stateless rules. If it is stateful, it
contains stateful rules.}

\item{Description}{A description of the rule group.}

\item{Capacity}{[required] The maximum operating resources that this rule group can use. Rule group
capacity is fixed at creation. When you update a rule group, you are
limited to this capacity. When you reference a rule group from a
firewall policy, Network Firewall reserves this capacity for the rule
group.

You can retrieve the capacity that would be required for a rule group
before you create the rule group by calling
\code{\link[=networkfirewall_create_rule_group]{create_rule_group}} with \code{DryRun}
set to \code{TRUE}.

You can't change or exceed this capacity when you update the rule group,
so leave room for your rule group to grow.

\strong{Capacity for a stateless rule group}

For a stateless rule group, the capacity required is the sum of the
capacity requirements of the individual rules that you expect to have in
the rule group.

To calculate the capacity requirement of a single rule, multiply the
capacity requirement values of each of the rule's match settings:
\itemize{
\item A match setting with no criteria specified has a value of 1.
\item A match setting with \code{Any} specified has a value of 1.
\item All other match settings have a value equal to the number of
elements provided in the setting. For example, a protocol setting
["UDP"] and a source setting ["10.0.0.0/24"] each have a value
of 1. A protocol setting ["UDP","TCP"] has a value of 2. A source
setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"] has a value of
3.
}

A rule with no criteria specified in any of its match settings has a
capacity requirement of 1. A rule with protocol setting ["UDP","TCP"],
source setting ["10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"], and a
single specification or no specification for each of the other match
settings has a capacity requirement of 6.

\strong{Capacity for a stateful rule group}

For a stateful rule group, the minimum capacity required is the number
of individual rules that you expect to have in the rule group.}

\item{Tags}{The key:value pairs to associate with the resource.}

\item{DryRun}{Indicates whether you want Network Firewall to just check the validity
of the request, rather than run the request.

If set to \code{TRUE}, Network Firewall checks whether the request can run
successfully, but doesn't actually make the requested changes. The call
returns the value that the request would return if you ran it with dry
run set to \code{FALSE}, but doesn't make additions or changes to your
resources. This option allows you to make sure that you have the
required permissions to run the request and that your request parameters
are valid.

If set to \code{FALSE}, Network Firewall makes the requested changes to your
resources.}

\item{EncryptionConfiguration}{A complex type that contains settings for encryption of your rule group
resources.}

\item{SourceMetadata}{A complex type that contains metadata about the rule group that your own
rule group is copied from. You can use the metadata to keep track of
updates made to the originating rule group.}
}
\description{
Creates the specified stateless or stateful rule group, which includes the rules for network traffic inspection, a capacity setting, and tags.

See \url{https://paws-r.github.io/docs/networkfirewall/create_rule_group.html} for full documentation.
}
\keyword{internal}
