% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_get_domain_names}
\alias{apigatewayv2_get_domain_names}
\title{Gets the domain names for an AWS account}
\usage{
apigatewayv2_get_domain_names(MaxResults, NextToken)
}
\arguments{
\item{MaxResults}{The maximum number of elements to be returned for this resource.}

\item{NextToken}{The next page of elements from this collection. Not valid for the last
element of the collection.}
}
\value{
A list with the following syntax:\preformatted{list(
  Items = list(
    list(
      ApiMappingSelectionExpression = "string",
      DomainName = "string",
      DomainNameConfigurations = list(
        list(
          ApiGatewayDomainName = "string",
          CertificateArn = "string",
          CertificateName = "string",
          CertificateUploadDate = as.POSIXct(
            "2015-01-01"
          ),
          DomainNameStatus = "AVAILABLE"|"UPDATING",
          DomainNameStatusMessage = "string",
          EndpointType = "REGIONAL"|"EDGE",
          HostedZoneId = "string",
          SecurityPolicy = "TLS_1_0"|"TLS_1_2"
        )
      ),
      MutualTlsAuthentication = list(
        TruststoreUri = "string",
        TruststoreVersion = "string",
        TruststoreWarnings = list(
          "string"
        )
      ),
      Tags = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets the domain names for an AWS account.
}
\section{Request syntax}{
\preformatted{svc$get_domain_names(
  MaxResults = "string",
  NextToken = "string"
)
}
}

\keyword{internal}
