% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_virtual_service}
\alias{appmesh_delete_virtual_service}
\title{Deletes an existing virtual service}
\usage{
appmesh_delete_virtual_service(meshName, meshOwner, virtualServiceName)
}
\arguments{
\item{meshName}{[required] The name of the service mesh to delete the virtual service in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it's the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualServiceName}{[required] The name of the virtual service to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  virtualService = list(
    meshName = "string",
    metadata = list(
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      meshOwner = "string",
      resourceOwner = "string",
      uid = "string",
      version = 123
    ),
    spec = list(
      provider = list(
        virtualNode = list(
          virtualNodeName = "string"
        ),
        virtualRouter = list(
          virtualRouterName = "string"
        )
      )
    ),
    status = list(
      status = "ACTIVE"|"INACTIVE"|"DELETED"
    ),
    virtualServiceName = "string"
  )
)
}
}
\description{
Deletes an existing virtual service.
}
\section{Request syntax}{
\preformatted{svc$delete_virtual_service(
  meshName = "string",
  meshOwner = "string",
  virtualServiceName = "string"
)
}
}

\keyword{internal}
