% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_create_app_version_app_component}
\alias{resiliencehub_create_app_version_app_component}
\title{Creates a new Application Component in the Resilience Hub application}
\usage{
resiliencehub_create_app_version_app_component(
  additionalInfo = NULL,
  appArn,
  clientToken = NULL,
  id = NULL,
  name,
  type
)
}
\arguments{
\item{additionalInfo}{Currently, there is no supported additional information for Application
Components.}

\item{appArn}{[required] Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{id}{Identifier of the Application Component.}

\item{name}{[required] Name of the Application Component.}

\item{type}{[required] Type of Application Component. For more information about the types of
Application Component, see \href{https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html}{Grouping resources in an AppComponent}.}
}
\description{
Creates a new Application Component in the Resilience Hub application.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_create_app_version_app_component/} for full documentation.
}
\keyword{internal}
