% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_create_deployment}
\alias{opsworks_create_deployment}
\title{Runs deployment or stack commands}
\usage{
opsworks_create_deployment(
  StackId,
  AppId = NULL,
  InstanceIds = NULL,
  LayerIds = NULL,
  Command,
  Comment = NULL,
  CustomJson = NULL
)
}
\arguments{
\item{StackId}{[required] The stack ID.}

\item{AppId}{The app ID. This parameter is required for app deployments, but not for
other deployment commands.}

\item{InstanceIds}{The instance IDs for the deployment targets.}

\item{LayerIds}{The layer IDs for the deployment targets.}

\item{Command}{[required] A \code{DeploymentCommand} object that specifies the deployment command and
any associated arguments.}

\item{Comment}{A user-defined comment.}

\item{CustomJson}{A string that contains user-defined, custom JSON. You can use this
parameter to override some corresponding default stack configuration
JSON values. The string should be in the following format:

\verb{"\{\\"key1\\": \\"value1\\", \\"key2\\": \\"value2\\",...\}"}

For more information about custom JSON, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html}{Use Custom JSON to Modify the Stack Configuration Attributes}
and \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html}{Overriding Attributes With Custom JSON}.}
}
\description{
Runs deployment or stack commands. For more information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html}{Deploying Apps} and \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html}{Run Stack Commands}.

See \url{https://www.paws-r-sdk.com/docs/opsworks_create_deployment/} for full documentation.
}
\keyword{internal}
