% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchinternetmonitor_operations.R
\name{cloudwatchinternetmonitor_start_query}
\alias{cloudwatchinternetmonitor_start_query}
\title{Start a query to return data for a specific query type for the Amazon
CloudWatch Internet Monitor query interface}
\usage{
cloudwatchinternetmonitor_start_query(
  MonitorName,
  StartTime,
  EndTime,
  QueryType,
  FilterParameters = NULL
)
}
\arguments{
\item{MonitorName}{[required] The name of the monitor to query.}

\item{StartTime}{[required] The timestamp that is the beginning of the period that you want to
retrieve data for with your query.}

\item{EndTime}{[required] The timestamp that is the end of the period that you want to retrieve
data for with your query.}

\item{QueryType}{[required] The type of query to run. The following are the three types of queries
that you can run using the Internet Monitor query interface:
\itemize{
\item \code{MEASUREMENTS}: TBD definition
\item \code{TOP_LOCATIONS}: TBD definition
\item \code{TOP_LOCATION_DETAILS}: TBD definition
}

For lists of the fields returned with each query type and more
information about how each type of query is performed, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html}{Using the Amazon CloudWatch Internet Monitor query interface}
in the Amazon CloudWatch Internet Monitor User Guide.}

\item{FilterParameters}{The \code{FilterParameters} field that you use with Amazon CloudWatch
Internet Monitor queries is a string the defines how you want a query to
be filtered. The filter parameters that you can specify depend on the
query type, since each query type returns a different set of Internet
Monitor data.

For more information about specifying filter parameters, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html}{Using the Amazon CloudWatch Internet Monitor query interface}
in the Amazon CloudWatch Internet Monitor User Guide.}
}
\description{
Start a query to return data for a specific query type for the Amazon CloudWatch Internet Monitor query interface. Specify a time period for the data that you want returned by using \code{StartTime} and \code{EndTime}. You filter the query results to return by providing parameters that you specify with \code{FilterParameters}.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchinternetmonitor_start_query/} for full documentation.
}
\keyword{internal}
