# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon CloudWatch Evidently
#'
#' @description
#' You can use Amazon CloudWatch Evidently to safely validate new features
#' by serving them to a specified percentage of your users while you roll
#' out the feature. You can monitor the performance of the new feature to
#' help you decide when to ramp up traffic to your users. This helps you
#' reduce risk and identify unintended consequences before you fully launch
#' the feature.
#' 
#' You can also conduct A/B experiments to make feature design decisions
#' based on evidence and data. An experiment can test as many as five
#' variations at once. Evidently collects experiment data and analyzes it
#' using statistical methods. It also provides clear recommendations about
#' which variations perform better. You can test both user-facing features
#' and backend features.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudwatchevidently(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudwatchevidently()
#' svc$batch_evaluate_feature(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudwatchevidently_batch_evaluate_feature]{batch_evaluate_feature} \tab This operation assigns feature variation to user sessions\cr
#'  \link[=cloudwatchevidently_create_experiment]{create_experiment} \tab Creates an Evidently experiment\cr
#'  \link[=cloudwatchevidently_create_feature]{create_feature} \tab Creates an Evidently feature that you want to launch or test\cr
#'  \link[=cloudwatchevidently_create_launch]{create_launch} \tab Creates a launch of a given feature\cr
#'  \link[=cloudwatchevidently_create_project]{create_project} \tab Creates a project, which is the logical object in Evidently that can contain features, launches, and experiments\cr
#'  \link[=cloudwatchevidently_create_segment]{create_segment} \tab Use this operation to define a segment of your audience\cr
#'  \link[=cloudwatchevidently_delete_experiment]{delete_experiment} \tab Deletes an Evidently experiment\cr
#'  \link[=cloudwatchevidently_delete_feature]{delete_feature} \tab Deletes an Evidently feature\cr
#'  \link[=cloudwatchevidently_delete_launch]{delete_launch} \tab Deletes an Evidently launch\cr
#'  \link[=cloudwatchevidently_delete_project]{delete_project} \tab Deletes an Evidently project\cr
#'  \link[=cloudwatchevidently_delete_segment]{delete_segment} \tab Deletes a segment\cr
#'  \link[=cloudwatchevidently_evaluate_feature]{evaluate_feature} \tab This operation assigns a feature variation to one given user session\cr
#'  \link[=cloudwatchevidently_get_experiment]{get_experiment} \tab Returns the details about one experiment\cr
#'  \link[=cloudwatchevidently_get_experiment_results]{get_experiment_results} \tab Retrieves the results of a running or completed experiment\cr
#'  \link[=cloudwatchevidently_get_feature]{get_feature} \tab Returns the details about one feature\cr
#'  \link[=cloudwatchevidently_get_launch]{get_launch} \tab Returns the details about one launch\cr
#'  \link[=cloudwatchevidently_get_project]{get_project} \tab Returns the details about one launch\cr
#'  \link[=cloudwatchevidently_get_segment]{get_segment} \tab Returns information about the specified segment\cr
#'  \link[=cloudwatchevidently_list_experiments]{list_experiments} \tab Returns configuration details about all the experiments in the specified project\cr
#'  \link[=cloudwatchevidently_list_features]{list_features} \tab Returns configuration details about all the features in the specified project\cr
#'  \link[=cloudwatchevidently_list_launches]{list_launches} \tab Returns configuration details about all the launches in the specified project\cr
#'  \link[=cloudwatchevidently_list_projects]{list_projects} \tab Returns configuration details about all the projects in the current Region in your account\cr
#'  \link[=cloudwatchevidently_list_segment_references]{list_segment_references} \tab Use this operation to find which experiments or launches are using a specified segment\cr
#'  \link[=cloudwatchevidently_list_segments]{list_segments} \tab Returns a list of audience segments that you have created in your account in this Region\cr
#'  \link[=cloudwatchevidently_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with an Evidently resource\cr
#'  \link[=cloudwatchevidently_put_project_events]{put_project_events} \tab Sends performance events to Evidently\cr
#'  \link[=cloudwatchevidently_start_experiment]{start_experiment} \tab Starts an existing experiment\cr
#'  \link[=cloudwatchevidently_start_launch]{start_launch} \tab Starts an existing launch\cr
#'  \link[=cloudwatchevidently_stop_experiment]{stop_experiment} \tab Stops an experiment that is currently running\cr
#'  \link[=cloudwatchevidently_stop_launch]{stop_launch} \tab Stops a launch that is currently running\cr
#'  \link[=cloudwatchevidently_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified CloudWatch Evidently resource\cr
#'  \link[=cloudwatchevidently_test_segment_pattern]{test_segment_pattern} \tab Use this operation to test a rules pattern that you plan to use to create an audience segment\cr
#'  \link[=cloudwatchevidently_untag_resource]{untag_resource} \tab Removes one or more tags from the specified resource\cr
#'  \link[=cloudwatchevidently_update_experiment]{update_experiment} \tab Updates an Evidently experiment\cr
#'  \link[=cloudwatchevidently_update_feature]{update_feature} \tab Updates an existing feature\cr
#'  \link[=cloudwatchevidently_update_launch]{update_launch} \tab Updates a launch of a given feature\cr
#'  \link[=cloudwatchevidently_update_project]{update_project} \tab Updates the description of an existing project\cr
#'  \link[=cloudwatchevidently_update_project_data_delivery]{update_project_data_delivery} \tab Updates the data storage options for this project
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloudwatchevidently
#' @export
cloudwatchevidently <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .cloudwatchevidently$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudwatchevidently <- list()

.cloudwatchevidently$operations <- list()

.cloudwatchevidently$metadata <- list(
  service_name = "cloudwatchevidently",
  endpoints = list("*" = list(endpoint = "evidently.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "evidently.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "evidently.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "evidently.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Evidently",
  api_version = "2021-02-01",
  signing_name = "evidently",
  json_version = "1.1",
  target_prefix = ""
)

.cloudwatchevidently$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.cloudwatchevidently$metadata, handlers, config)
}
