% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managedgrafana_operations.R
\name{managedgrafana_list_permissions}
\alias{managedgrafana_list_permissions}
\title{Lists the users and groups who have the Grafana Admin and Editor roles
in this workspace}
\usage{
managedgrafana_list_permissions(
  groupId = NULL,
  maxResults = NULL,
  nextToken = NULL,
  userId = NULL,
  userType = NULL,
  workspaceId
)
}
\arguments{
\item{groupId}{(Optional) Limits the results to only the group that matches this ID.}

\item{maxResults}{The maximum number of results to include in the response.}

\item{nextToken}{The token to use when requesting the next set of results. You received
this token from a previous
\code{\link[=managedgrafana_list_permissions]{list_permissions}} operation.}

\item{userId}{(Optional) Limits the results to only the user that matches this ID.}

\item{userType}{(Optional) If you specify \code{SSO_USER}, then only the permissions of
Amazon Web Services SSO users are returned. If you specify \code{SSO_GROUP},
only the permissions of Amazon Web Services SSO groups are returned.}

\item{workspaceId}{[required] The ID of the workspace to list permissions for. This parameter is
required.}
}
\description{
Lists the users and groups who have the Grafana \code{Admin} and \code{Editor} roles in this workspace. If you use this operation without specifying \code{userId} or \code{groupId}, the operation returns the roles of all users and groups. If you specify a \code{userId} or a \code{groupId}, only the roles for that user or group are returned. If you do this, you can specify only one \code{userId} or one \code{groupId}.

See \url{https://paws-r.github.io/docs/managedgrafana/list_permissions.html} for full documentation.
}
\keyword{internal}
