% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationautoscaling_service.R
\name{applicationautoscaling}
\alias{applicationautoscaling}
\title{Application Auto Scaling}
\usage{
applicationautoscaling(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
With Application Auto Scaling, you can configure automatic scaling for
the following resources:
\itemize{
\item Amazon AppStream 2.0 fleets
\item Amazon Aurora Replicas
\item Amazon Comprehend document classification and entity recognizer
endpoints
\item Amazon DynamoDB tables and global secondary indexes throughput
capacity
\item Amazon ECS services
\item Amazon ElastiCache for Redis clusters (replication groups)
\item Amazon EMR clusters
\item Amazon Keyspaces (for Apache Cassandra) tables
\item Lambda function provisioned concurrency
\item Amazon Managed Streaming for Apache Kafka broker storage
\item Amazon Neptune clusters
\item Amazon SageMaker endpoint variants
\item Spot Fleets (Amazon EC2)
\item Custom resources provided by your own applications or services
}

\strong{API Summary}

The Application Auto Scaling service API includes three key sets of
actions:
\itemize{
\item Register and manage scalable targets - Register Amazon Web Services
or custom resources as scalable targets (a resource that Application
Auto Scaling can scale), set minimum and maximum capacity limits,
and retrieve information on existing scalable targets.
\item Configure and manage automatic scaling - Define scaling policies to
dynamically scale your resources in response to CloudWatch alarms,
schedule one-time or recurring scaling actions, and retrieve your
recent scaling activity history.
\item Suspend and resume scaling - Temporarily suspend and later resume
automatic scaling by calling the
\code{\link[=applicationautoscaling_register_scalable_target]{register_scalable_target}}
API action for any Application Auto Scaling scalable target. You can
suspend and resume (individually or in combination) scale-out
activities that are triggered by a scaling policy, scale-in
activities that are triggered by a scaling policy, and scheduled
scaling.
}

To learn more about Application Auto Scaling, including information
about granting IAM users required permissions for Application Auto
Scaling actions, see the \href{https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html}{Application Auto Scaling User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- applicationautoscaling(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=applicationautoscaling_delete_scaling_policy]{delete_scaling_policy} \tab Deletes the specified scaling policy for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified scheduled action for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_deregister_scalable_target]{deregister_scalable_target} \tab Deregisters an Application Auto Scaling scalable target when you have finished using it\cr
\link[=applicationautoscaling_describe_scalable_targets]{describe_scalable_targets} \tab Gets information about the scalable targets in the specified namespace\cr
\link[=applicationautoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Provides descriptive information about the scaling activities in the specified namespace from the previous six weeks\cr
\link[=applicationautoscaling_describe_scaling_policies]{describe_scaling_policies} \tab Describes the Application Auto Scaling scaling policies for the specified service namespace\cr
\link[=applicationautoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Describes the Application Auto Scaling scheduled actions for the specified service namespace\cr
\link[=applicationautoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a scaling policy for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_put_scheduled_action]{put_scheduled_action} \tab Creates or updates a scheduled action for an Application Auto Scaling scalable target\cr
\link[=applicationautoscaling_register_scalable_target]{register_scalable_target} \tab Registers or updates a scalable target
}
}

\examples{
\dontrun{
svc <- applicationautoscaling()
# This example deletes a scaling policy for the Amazon ECS service called
# web-app, which is running in the default cluster.
svc$delete_scaling_policy(
  PolicyName = "web-app-cpu-lt-25",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs"
)
}

}
