% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_affected_accounts_for_organization}
\alias{health_describe_affected_accounts_for_organization}
\title{Returns a list of accounts in the organization from AWS Organizations
that are affected by the provided event}
\usage{
health_describe_affected_accounts_for_organization(eventArn, nextToken,
  maxResults)
}
\arguments{
\item{eventArn}{[required] The unique identifier for the event. Format:
\verb{arn:aws:health:<i>event-region</i>::event/<i>SERVICE</i>/<i>EVENT_TYPE_CODE</i>/<i>EVENT_TYPE_PLUS_ID</i> }.
Example:
\verb{Example: arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-DEF456}}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}
}
\description{
Returns a list of accounts in the organization from AWS Organizations
that are affected by the provided event.
}
\details{
Before you can call this operation, you must first enable AWS Health to
work with AWS Organizations. To do this, call the
EnableHealthServiceAccessForOrganization operation from your
organization\'s master account.
}
\section{Request syntax}{
\preformatted{svc$describe_affected_accounts_for_organization(
  eventArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
