% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_trusted_advisor_check_result}
\alias{support_describe_trusted_advisor_check_result}
\title{Returns the results of the Trusted Advisor check that has the specified
check ID}
\usage{
support_describe_trusted_advisor_check_result(checkId, language)
}
\arguments{
\item{checkId}{[required] The unique identifier for the Trusted Advisor check.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English ("en") and Japanese ("ja").
Language parameters must be passed explicitly for operations that take
them.}
}
\description{
Returns the results of the Trusted Advisor check that has the specified
check ID. Check IDs can be obtained by calling
DescribeTrustedAdvisorChecks.
}
\details{
The response contains a TrustedAdvisorCheckResult object, which contains
these three objects:
\itemize{
\item TrustedAdvisorCategorySpecificSummary
\item TrustedAdvisorResourceDetail
\item TrustedAdvisorResourcesSummary
}

In addition, the response contains these fields:
\itemize{
\item \strong{status.} The alert status of the check: "ok" (green),
"warning" (yellow), "error" (red), or "not\_available".
\item \strong{timestamp.} The time of the last refresh of the check.
\item \strong{checkId.} The unique identifier for the check.
}
}
\section{Request syntax}{
\preformatted{svc$describe_trusted_advisor_check_result(
  checkId = "string",
  language = "string"
)
}
}

\keyword{internal}
