% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_license_configurations}
\alias{licensemanager_list_license_configurations}
\title{Lists license configuration objects for an account, each containing the
name, description, license type, and other license terms modeled from a
license agreement}
\usage{
licensemanager_list_license_configurations(LicenseConfigurationArns,
  MaxResults, NextToken, Filters)
}
\arguments{
\item{LicenseConfigurationArns}{An array of ARNs for the calling account's license configurations.}

\item{MaxResults}{Maximum number of results to return in a single call. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{Token for the next set of results.}

\item{Filters}{One or more filters.}
}
\description{
Lists license configuration objects for an account, each containing the
name, description, license type, and other license terms modeled from a
license agreement.
}
\section{Request syntax}{
\preformatted{svc$list_license_configurations(
  LicenseConfigurationArns = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
