% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_usage_for_license_configuration}
\alias{licensemanager_list_usage_for_license_configuration}
\title{Lists all license usage records for a license configuration, displaying
license consumption details by resource at a selected point in time}
\usage{
licensemanager_list_usage_for_license_configuration(
  LicenseConfigurationArn, MaxResults, NextToken, Filters)
}
\arguments{
\item{LicenseConfigurationArn}{[required] ARN of the targeted \code{LicenseConfiguration} object.}

\item{MaxResults}{Maximum number of results to return in a single call. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{Token for the next set of results.}

\item{Filters}{List of filters to apply.}
}
\description{
Lists all license usage records for a license configuration, displaying
license consumption details by resource at a selected point in time. Use
this action to audit the current license consumption for any license
inventory and configuration.
}
\section{Request syntax}{
\preformatted{svc$list_usage_for_license_configuration(
  LicenseConfigurationArn = "string",
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
