% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_instance_patch_states_for_patch_group}
\alias{ssm_describe_instance_patch_states_for_patch_group}
\title{Retrieves the high-level patch state for the instances in the specified
patch group}
\usage{
ssm_describe_instance_patch_states_for_patch_group(PatchGroup, Filters,
  NextToken, MaxResults)
}
\arguments{
\item{PatchGroup}{[required] The name of the patch group for which the patch state information should
be retrieved.}

\item{Filters}{Each entry in the array is a structure containing:

Key (string between 1 and 200 characters)

Values (array containing a single string)

Type (string "Equal", "NotEqual", "LessThan", "GreaterThan")}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of patches to return (per page).}
}
\value{
A list with the following syntax:\preformatted{list(
  InstancePatchStates = list(
    list(
      InstanceId = "string",
      PatchGroup = "string",
      BaselineId = "string",
      SnapshotId = "string",
      InstallOverrideList = "string",
      OwnerInformation = "string",
      InstalledCount = 123,
      InstalledOtherCount = 123,
      InstalledPendingRebootCount = 123,
      InstalledRejectedCount = 123,
      MissingCount = 123,
      FailedCount = 123,
      UnreportedNotApplicableCount = 123,
      NotApplicableCount = 123,
      OperationStartTime = as.POSIXct(
        "2015-01-01"
      ),
      OperationEndTime = as.POSIXct(
        "2015-01-01"
      ),
      Operation = "Scan"|"Install",
      LastNoRebootInstallOperationTime = as.POSIXct(
        "2015-01-01"
      ),
      RebootOption = "RebootIfNeeded"|"NoReboot"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves the high-level patch state for the instances in the specified
patch group.
}
\section{Request syntax}{
\preformatted{svc$describe_instance_patch_states_for_patch_group(
  PatchGroup = "string",
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      ),
      Type = "Equal"|"NotEqual"|"LessThan"|"GreaterThan"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
