% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_deregister_ecs_cluster}
\alias{opsworks_deregister_ecs_cluster}
\title{Deregisters a specified Amazon ECS cluster from a stack}
\usage{
opsworks_deregister_ecs_cluster(EcsClusterArn)
}
\arguments{
\item{EcsClusterArn}{[required] The cluster's Amazon Resource Number (ARN).}
}
\value{
An empty list.
}
\description{
Deregisters a specified Amazon ECS cluster from a stack. For more
information, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete}{Resource Management}.

\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack or an attached policy that
explicitly grants permissions. For more information on user permissions,
see
\url{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}.
}
\section{Request syntax}{
\preformatted{svc$deregister_ecs_cluster(
  EcsClusterArn = "string"
)
}
}

\keyword{internal}
