% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_list_monitors}
\alias{forecastservice_list_monitors}
\title{Returns a list of monitors created with the CreateMonitor operation and
CreateAutoPredictor operation}
\usage{
forecastservice_list_monitors(
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL
)
}
\arguments{
\item{NextToken}{If the result of the previous request was truncated, the response
includes a \code{NextToken}. To retrieve the next set of results, use the
token in the next request. Tokens expire after 24 hours.}

\item{MaxResults}{The maximum number of monitors to include in the response.}

\item{Filters}{An array of filters. For each filter, provide a condition and a match
statement. The condition is either \code{IS} or \code{IS_NOT}, which specifies
whether to include or exclude the resources that match the statement
from the list. The match statement consists of a key and a value.

\strong{Filter properties}
\itemize{
\item \code{Condition} - The condition to apply. Valid values are \code{IS} and
\code{IS_NOT}.
\item \code{Key} - The name of the parameter to filter on. The only valid value
is \code{Status}.
\item \code{Value} - The value to match.
}

For example, to list all monitors who's status is ACTIVE, you would
specify:

\verb{"Filters": [ \{ "Condition": "IS", "Key": "Status", "Value": "ACTIVE" \} ]}}
}
\description{
Returns a list of monitors created with the \code{\link[=forecastservice_create_monitor]{create_monitor}} operation and \code{\link[=forecastservice_create_auto_predictor]{create_auto_predictor}} operation. For each monitor resource, this operation returns of a summary of its properties, including its Amazon Resource Name (ARN). You can retrieve a complete set of properties of a monitor resource by specify the monitor's ARN in the \code{\link[=forecastservice_describe_monitor]{describe_monitor}} operation.

See \url{https://www.paws-r-sdk.com/docs/forecastservice_list_monitors/} for full documentation.
}
\keyword{internal}
