% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_space}
\alias{sagemaker_create_space}
\title{Creates a space used for real time collaboration in a domain}
\usage{
sagemaker_create_space(
  DomainId,
  SpaceName,
  Tags = NULL,
  SpaceSettings = NULL,
  OwnershipSettings = NULL,
  SpaceSharingSettings = NULL,
  SpaceDisplayName = NULL
)
}
\arguments{
\item{DomainId}{[required] The ID of the associated domain.}

\item{SpaceName}{[required] The name of the space.}

\item{Tags}{Tags to associated with the space. Each tag consists of a key and an
optional value. Tag keys must be unique for each resource. Tags are
searchable using the \code{\link[=sagemaker_search]{search}} API.}

\item{SpaceSettings}{A collection of space settings.}

\item{OwnershipSettings}{A collection of ownership settings.}

\item{SpaceSharingSettings}{A collection of space sharing settings.}

\item{SpaceDisplayName}{The name of the space that appears in the SageMaker Studio UI.}
}
\description{
Creates a space used for real time collaboration in a domain.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_space/} for full documentation.
}
\keyword{internal}
