% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalizeruntime_operations.R
\name{personalizeruntime_get_recommendations}
\alias{personalizeruntime_get_recommendations}
\title{Returns a list of recommended items}
\usage{
personalizeruntime_get_recommendations(
  campaignArn = NULL,
  itemId = NULL,
  userId = NULL,
  numResults = NULL,
  context = NULL,
  filterArn = NULL,
  filterValues = NULL,
  recommenderArn = NULL,
  promotions = NULL,
  metadataColumns = NULL
)
}
\arguments{
\item{campaignArn}{The Amazon Resource Name (ARN) of the campaign to use for getting
recommendations.}

\item{itemId}{The item ID to provide recommendations for.

Required for \code{RELATED_ITEMS} recipe type.}

\item{userId}{The user ID to provide recommendations for.

Required for \code{USER_PERSONALIZATION} recipe type.}

\item{numResults}{The number of results to return. The default is 25. If you are including
metadata in recommendations, the maximum is 50. Otherwise, the maximum
is 500.}

\item{context}{The contextual metadata to use when getting recommendations. Contextual
metadata includes any interaction information that might be relevant
when getting a user's recommendations, such as the user's current
location or device type.}

\item{filterArn}{The ARN of the filter to apply to the returned recommendations. For more
information, see \href{https://docs.aws.amazon.com/personalize/latest/dg/filter.html}{Filtering Recommendations}.

When using this parameter, be sure the filter resource is \code{ACTIVE}.}

\item{filterValues}{The values to use when filtering recommendations. For each placeholder
parameter in your filter expression, provide the parameter name (in
matching case) as a key and the filter value(s) as the corresponding
value. Separate multiple values for one parameter with a comma.

For filter expressions that use an \code{INCLUDE} element to include items,
you must provide values for all parameters that are defined in the
expression. For filters with expressions that use an \code{EXCLUDE} element
to exclude items, you can omit the \code{filter-values}.In this case, Amazon
Personalize doesn't use that portion of the expression to filter
recommendations.

For more information, see \href{https://docs.aws.amazon.com/personalize/latest/dg/filter.html}{Filtering recommendations and user segments}.}

\item{recommenderArn}{The Amazon Resource Name (ARN) of the recommender to use to get
recommendations. Provide a recommender ARN if you created a Domain
dataset group with a recommender for a domain use case.}

\item{promotions}{The promotions to apply to the recommendation request. A promotion
defines additional business rules that apply to a configurable subset of
recommended items.}

\item{metadataColumns}{If you enabled metadata in recommendations when you created or updated
the campaign or recommender, specify the metadata columns from your
Items dataset to include in item recommendations. The map key is \code{ITEMS}
and the value is a list of column names from your Items dataset. The
maximum number of columns you can provide is 10.

For information about enabling metadata for a campaign, see \href{https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata}{Enabling metadata in recommendations for a campaign}.
For information about enabling metadata for a recommender, see \href{https://docs.aws.amazon.com/personalize/latest/dg/creating-recommenders.html#create-recommender-return-metadata}{Enabling metadata in recommendations for a recommender}.}
}
\description{
Returns a list of recommended items. For campaigns, the campaign's Amazon Resource Name (ARN) is required and the required user and item input depends on the recipe type used to create the solution backing the campaign as follows:

See \url{https://www.paws-r-sdk.com/docs/personalizeruntime_get_recommendations/} for full documentation.
}
\keyword{internal}
